<?php if(!defined('ABSPATH')) { die('You are not allowed to call this page directly.'); } ?>

<div class="wrap prli-welcome">
  <h1><?php esc_html_e('Welcome to Pretty Links!', 'pretty-link'); ?></h1>

  <div class="prli-welcome-badge">
    <img src="<?php echo PRLI_IMAGES_URL . '/welcome-desk.png'; ?>" alt="<?php esc_attr_e('Welcome to Pretty Links!', 'pretty-link'); ?>">
  </div>

  <p class="prli-welcome-about"><?php esc_html_e('Congratulations, you\'ve just installed the most powerful link management platform for WordPress on Earth!', 'pretty-link'); ?></p>
  <p class="prli-welcome-about"><?php esc_html_e('With Pretty Links, you\'ll no longer need to manage links from a spreadsheet and you\'ll be able to maximize the visibility of your links - these benefits (and more) will make it possible to make more money from your content like never before!', 'pretty-link'); ?></p>

  <hr>

  <div class="prli-center-section">
    <div>&nbsp;</div>
    <h2><?php esc_html_e('Getting Started', 'pretty-link'); ?></h2>
    <p><?php esc_html_e('Start by creating your first Pretty Link:', 'pretty-link'); ?></p>
  </div>

  <div class="prli-center-section">
    <div>&nbsp;</div>
    <p class="prli-welcome-step">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-add-new.png'; ?>" alt="<?php esc_attr_e('Click "Add New Link"', 'pretty-link'); ?>">
      <?php esc_html_e('1. Click "Add New Link"', 'pretty-link'); ?>
    </p>
    <p class="prli-welcome-step">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-enter-url.png'; ?>" alt="<?php esc_attr_e('Enter the URL of your Affiliate Link', 'pretty-link'); ?>">
      <?php esc_html_e('2. Enter the URL of your Affiliate Link', 'pretty-link'); ?>
    </p>
    <p class="prli-welcome-step">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-customize-slug.png'; ?>" alt="<?php esc_attr_e('Customize your Pretty Link Slug', 'pretty-link'); ?>">
      <?php esc_html_e('3. Customize your Pretty Link Slug', 'pretty-link'); ?>
    </p>
    <p class="prli-welcome-step">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-click-update.png'; ?>" alt="<?php esc_attr_e('Click "Update"', 'pretty-link'); ?>">
      <?php esc_html_e('4. Click "Update"', 'pretty-link'); ?>
    </p>
    <p class="prli-welcome-step">
      <img class="prli-welcome-step" src="<?php echo PRLI_IMAGES_URL . '/welcome-copy-url.png'; ?>" alt="<?php esc_attr_e('Copy the Pretty Link URL', 'pretty-link'); ?>">
      <?php esc_html_e('5. Copy the Pretty Link URL', 'pretty-link'); ?>
    </p>
    <div>&nbsp;</div>

    <p><?php esc_html_e('Wasn\'t that easy? Now, you can use this link wherever you want!', 'pretty-link'); ?></p>

  </div>

  <hr>

  <div class="prli-center-section">
    <div>&nbsp;</div>
    <h2><?php esc_html_e('The Power of Pretty Links Pro', 'pretty-link'); ?></h2>
    <p><?php esc_html_e('There are many reasons that premium users of Pretty Links are able to take their business to the next level:', 'pretty-link'); ?></p>
  </div>

  <div class="prli-center-section prli-row prli-2-columns prli-is-wider-left">
    <div class="prli-column prli-align-vertically">
      <h3><?php esc_html_e('Automated, Site-Wide Link Placement (Keyword Replacement)', 'pretty-link'); ?></h3>
      <p><?php esc_html_e('Imagine if you never had to hand-edit links, copy and paste from a spreadsheet, or actively have to keep up with you links ever again. Well that time has come! Now with Pretty Links, all you have to do is create your links and let Pretty Links do the rest!', 'pretty-link'); ?></p>
      <p><?php esc_html_e('Pretty Links will scan your content for the keywords or URLs that you want to target and will replace them with Pretty Links automatically! This will save you tons of time so you can focus on growing your business!', 'pretty-link'); ?></p>
    </div>
    <div class="prli-column">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-link.png'; ?>" alt="<?php esc_attr_e('Automated, Site-Wide Link Placement (Keyword Replacement)', 'pretty-link'); ?>">
    </div>
  </div>

  <div class="prli-center-section prli-row prli-2-columns prli-is-wider-right">
    <div class="prli-column">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-categories.png'; ?>" alt="<?php esc_attr_e('Categories & Tags', 'pretty-link'); ?>">
    </div>
    <div class="prli-column prli-align-vertically">
      <h3><?php esc_html_e('Categories & Tags', 'pretty-link'); ?></h3>
      <p><?php esc_html_e('When you are dealing with a large number of links, it can be easy to be overwhelmed and confused by which links to you planned to use where. It\'s now easier than ever to organize your links and group them any way that you like for ultimate productivity and monetization!', 'pretty-link'); ?></p>
    </div>
  </div>

  <div class="prli-center-section prli-row prli-2-columns prli-is-wider-left">
    <div class="prli-column prli-align-vertically">
      <h3><?php esc_html_e('Advanced Redirect Types', 'pretty-link'); ?></h3>
      <p><?php esc_html_e('Lite users can take advantage of 301 & 302 server side redirects but our pro users can also redirect with cloaking, JavaScript, Meta-refresh and more.', 'pretty-link'); ?></p>
      <p><?php esc_html_e('So if you have social media links, a landing page, or a new page or post you\'d like to redirect your customers to, this feature will definitely come in handy!', 'pretty-link'); ?></p>
    </div>
    <div class="prli-column">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-advanced-redirects.png'; ?>" alt="<?php esc_attr_e('Advanced Redirect Types', 'pretty-link'); ?>">
    </div>
  </div>

  <div class="prli-center-section prli-row prli-2-columns prli-is-wider-right">
    <div class="prli-column">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-dynamic-redirects.png'; ?>" alt="<?php esc_attr_e('Dynamic Redirect Types', 'pretty-link'); ?>">
    </div>
    <div class="prli-column prli-align-vertically">
      <h3><?php esc_html_e('Dynamic Redirect Types', 'pretty-link'); ?></h3>
      <p><?php esc_html_e('Would you like your Pretty Link to redirect somewhere custom depending on what country your user is in, device they\'re using, time they\'re clicking the link or just randomly? Our pro users can do this easily with our Dynamic Redirections!', 'pretty-link'); ?></p>
      <p><?php esc_html_e('This feature is excellent if you are running a time-sensitive sales, want to create custom content for you customers, create stellar landing pages for customers in different countries!', 'pretty-link'); ?></p>
    </div>
  </div>

  <div class="prli-center-section prli-row prli-2-columns prli-is-wider-left">
    <div class="prli-column prli-align-vertically">
      <h3><?php esc_html_e('Import and Export Links', 'pretty-link'); ?></h3>
      <p><?php esc_html_e('Export your links to a spreadsheet or import them en masse - our pro users can do this with ease. Simply download your spreadsheet, upload to WordPress, and your links are automatically added to Pretty Links!', 'pretty-link'); ?></p>
    </div>
    <div class="prli-column">
      <img src="<?php echo PRLI_IMAGES_URL . '/welcome-import-export.png'; ?>" alt="<?php esc_attr_e('Import and Export Links', 'pretty-link'); ?>">
    </div>
  </div>

  <div class="prli-center-section">
    <h3><?php esc_html_e('The list goes on and on', 'pretty-link'); ?></h3>
    <p><?php esc_html_e('Our premium editions of Pretty Links are a HUGE upgrade from Lite. Don’t miss out on our critical PRO benefits!', 'pretty-link'); ?></p>
  </div>

  <div class="prli-center-section prli-button-section">
    <a href="https://prettylinks.com/pl/welcome-page/upgrade" class="button button-primary"><?php esc_html_e('Upgrade to Pro', 'pretty-link'); ?></a>
    <p><?php esc_html_e('Upgrade NOW and get 50% off of your subscription!!!', 'pretty-link'); ?></p>
  </div>

</div>
