# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Test du module de gestion des horaires pour les groupes de machine
#  
###########################################################################
""" teste time_manager.py"""
from . import autopath
from amon.ipset import time_manager as t
import os

def setup_module(module):
    t.time_file = "/usr/share/python-support/python-amon-backend/amon/ipset/tests/datas/time%d.pickle"
    if os.path.isfile(t.time_file%0):
        os.unlink(t.time_file)

def test_add_schedule():
    """ teste l'ajout de plage horaire """
    group = 'groupe_test'
    jour = 'lundi'
    hdeb = '0:00'
    hfin = '10:00'
    t.add_schedule(0, group, jour, hdeb, hfin)
    assert t.get_schedules(0) == {'groupe_test':{'lundi':[{'hdeb':hdeb, 'hfin':hfin}]}}
    t.del_schedule(0, group)

def test_del_schedule():
    """ teste la suppression de plage horaire """
    group = 'groupe_test'
    jour = 'lundi'
    hdeb = '0:00'
    hfin = '10:00'
    if group not in t.get_schedules(0):
        t.add_schedule(0, group, jour, hdeb, hfin)
    t.del_schedule(0, group, jour, hdeb, hfin)
    assert t.get_schedules(0) == {'groupe_test':{'lundi':[]}}
    t.del_schedule(0,group)

def test_copy_schedule():
    """ teste la copie d'horaire d'un groupe à un autre """
    group_from = 'groupe_from'
    group_to = 'group_to'
    jour = 'lundi'
    hdeb = '0:00'
    hfin = '10:00'
    t.add_schedule(0, group_from, jour, hdeb, hfin)
    assert t.get_schedules(0, 'groupe_from') == {'lundi':[{'hdeb':hdeb, 'hfin':hfin}]}
    t.copy_schedules(0, group_from, group_to)
    assert t.get_schedules(0) == {'groupe_from':{'lundi':[{'hdeb':hdeb, 'hfin':hfin}]},
                                 'group_to':{'lundi':[{'hdeb':hdeb, 'hfin':hfin}]}}
