#-*-coding:utf-8-*-
"""
    Teste les fonctions du module amon.era
"""
import os
import datetime
from amon.era import postes
from amon.config import WEB_PORTS, VIRTDISABLED

# décalage UTC
dt = datetime.datetime.now(tz=datetime.timezone.utc)
offset = int(dt.astimezone().utcoffset().total_seconds() / 3600)

test_dir = '/usr/share/amon/tests'
num_zone = 0
eth0name = "enp4s0"
eth1name = "enp5s0"
eth = eth1name

dest_rule1 = """/sbin/iptables -I FORWARD -i %s -d %s -j REJECT"""
dest_rule2 = """/sbin/iptables -I INPUT -i %s -s %s -j REJECT"""

poste1 = '1.1.1.1'
hdeb1 = 10
hfin1 = 15
jdeb1 = 'lundi'
jfin1 = 'jeudi'

if VIRTDISABLED:
    eth1proxy = eth1name
    poste1_forbid_rule = [
    ('/sbin/iptables -t nat -I PREROUTING -i %s -m multiport -p tcp --dports %s -s %s -m time --timestart %d:0 --timestop %d:0  --weekdays Mon,Tue,Wed,Thu -j REDIRECT --to-ports 83' % (eth1proxy, WEB_PORTS, poste1, hdeb1-offset, hfin1-offset), 'proxy'),
    ('/sbin/iptables -I INPUT -i %s -s %s -p tcp --dport 83  -m time --timestart %d:0 --timestop %d:0  --weekdays Mon,Tue,Wed,Thu -j ACCEPT' % (eth1proxy, poste1, hdeb1-offset, hfin1-offset), 'proxy')
    ]
else:
    eth1proxy = 'eth1'
    poste1_forbid_rule = [
    ('/sbin/iptables -t nat -I PREROUTING -i %s -m multiport -p tcp --dports %s -s %s -m time --timestart %d:0 --timestop %d:0  --weekdays Mon,Tue,Wed,Thu -j DNAT  --to-destination 192.0.2.1:83' % (eth1proxy, WEB_PORTS, poste1, hdeb1-offset, hfin1-offset), 'proxy'),
    ('/sbin/iptables -I FORWARD -i %s -o containers -s %s -p tcp --dport 83  -m time --timestart %d:0 --timestop %d:0  --weekdays Mon,Tue,Wed,Thu -j ACCEPT' % (eth1proxy, poste1, hdeb1-offset, hfin1-offset), 'proxy'),
    ('/sbin/iptables -t nat -A POSTROUTING -s %s -o containers -j SNAT --to-source 192.0.2.53' % (poste1,), 'proxy'),
    ('/sbin/iptables -I INPUT -i br0 -s %s -p tcp --dport 83  -m time --timestart %d:0 --timestop %d:0  --weekdays Mon,Tue,Wed,Thu -j ACCEPT' % (poste1, hdeb1-offset, hfin1-offset), None)
    ]

poste1_dest_rule1 = dest_rule1 % (eth1name, poste1)
poste1_dest_rule2 = dest_rule2 % (eth1name, poste1)
poste1_dest_rule = [(poste1_dest_rule1, 'root'), (poste1_dest_rule2, 'root')]

poste2 = '1.1.1.2'
hdeb2 = '15:00'
hfin2 = '19:00'
jdeb2 = 'Thu'
jfin2 = 'Mon'
poste2_dest_rule1 = dest_rule1 % (eth1name, poste2)
poste2_dest_rule2 = dest_rule2 % (eth1name, poste2)
poste2_dest_rule = [(poste2_dest_rule1, 'root'), (poste2_dest_rule2, 'root')]


def setup_module(module):
    """ initialisation """
    if not os.path.isdir("%s/datas/" % test_dir):
        os.system("mkdir %s/datas" % test_dir)
    postes.f_poste_name = {'all':'%s/datas/test_all%%d.txt' % test_dir,
                           'web':'%s/datas/test_web%%d.txt' % test_dir,
                           'destination':'%s/datas/test_dest%%d.txt' % test_dir}

def test_get_interface():
    """ teste la détection d'interface """
    assert eth in postes.get_interface(num_zone)

def test_web_interdiction():
    """ teste l'interdiction web pour un ou plusieurs postes
    """
    p1 = dict(poste=poste1, hdeb='{}:00'.format(hdeb1), hfin='{}:00'.format(hfin1), jdeb=jdeb1, jfin=jfin1, interface=eth)
    p2 = dict(poste=poste2, hdeb=hdeb2, hfin=hfin2, jdeb=jdeb2, jfin=jfin2, interface=eth)
    assert postes.save_forbidden_poste(0, 'web', [p1, p2])
    assert postes.load_forbidden_poste(0, 'web') == [p1, p2]
    assert postes.save_forbidden_poste(0, 'web', [p1])
    assert postes.generate_postes_rules() == poste1_forbid_rule
    postes.save_forbidden_poste(0, 'web', [])
    assert postes.load_forbidden_poste(0, 'web') == []

def test_all_interdiction():
    p1 = dict(poste=poste1, interface=eth)
    p2 = dict(poste=poste2)
    postes.save_forbidden_poste(0, 'all', [p1, p2])
    assert postes.load_forbidden_poste(0, 'all') == [p1, p2]
    postes.save_forbidden_poste(0, 'all', [])
    assert postes.load_forbidden_poste(0, 'all') == []

def test_destination():
    dest1 = dict(poste=poste1, interface=eth)
    dest2 = dict(poste=poste2)

    postes.save_forbidden_poste(0, 'destination', [dest1, dest2])
    assert postes.load_forbidden_poste(0, 'destination') == [dest1, dest2]
    assert postes.generate_destinations_rules() == poste1_dest_rule + poste2_dest_rule
    postes.save_forbidden_poste(0, 'destination', [])
    assert postes.load_forbidden_poste(0, 'destination') == []

def teardown_module(module):
    for _file in postes.f_poste_name.values():
        if os.path.isfile(_file%0):
            os.unlink(_file%0)

