#-*-coding:utf-8-*-
"""
    Tests amon
"""
import subprocess as c
import os
from amon.backend import get_filter_zones, command_statusoutput
from amon.ipset import group_manager, time_manager, rule_generator, tools as ipset_tools
from amon.era.main import bastion_restart
from pytest import raises

test_dir = '/usr/share/amon/tests'

zones = get_filter_zones()
num_zone = 0
eth = zones[0][0]['nom']
# nom des groupes de machine et de port que l'on utilise
gr_machine_name = "___groupemachinetest___"
port_group_name = "___portgroupname___"
ipfrom = "1.1.1.235"
ipto = "1.1.1.237"
iprange = ["1.1.1.235", "1.1.1.236", "1.1.1.237"]

portfrom = "22"
portto = "80"
# les horaires que l'on utilise
jour = 'lundi'
hdeb1 = '0:00'
hfin1 = '10:00'
hdeb2 = "11:00"
hfin2 = "13:00"
# horaires à problème
hdeb3 = "9:00"
hfin3 = "12:00"


def setup_module(module):
    """
        initialisation changement des fichiers de destination des modules
        creation du rep temporaire
    """
    if not os.path.isdir("%s/datas/" % test_dir):
        os.system("mkdir %s/datas" % test_dir)
    module.old_group_file = group_manager.group_file
    group_manager.group_file = "%s/datas/group%%d.txt" % test_dir
    a = open(group_manager.group_file%0, 'w')
    a.write('')
    a.close()
    module.old_time_file = time_manager.time_file
    time_manager.time_file = "%s/datas/time%%d.pickle" % test_dir
    if os.path.isfile(time_manager.time_file%0):
        os.unlink(time_manager.time_file%0)

class IpsetKernelError(Exception):
    pass

class IpsetTester:
    """
    Teste les commandes ipset utilisé sur Amon
    """
    exist = "ipset -L"
    save = "ipset --save"
    create = "ipset create %s ipmap --from %s --to %s" % (gr_machine_name, ipfrom, ipto)
    create_portmap = "ipset create %s portmap --from %s --to %s" % (port_group_name, portfrom, portto)
    #suppression des commandes bind, option deprecated dans ipset
    #bind = "ipset -B %s :default: -b %s" % (gr_machine_name, port_group_name)
    delete = "ipset -X %s" % gr_machine_name
    delete_portmap = "ipset -X %s" % port_group_name

    def test(self):
        for cmd in ['exist', 'save', 'create', 'create_portmap', 'delete', 'delete_portmap']:
            self.test_cmd(cmd)

    def test_cmd(self, _type):
        cmd = getattr(self, _type)
        ret_code, ret_value = c.getstatusoutput(cmd)
        if ret_code:
            raise IpsetKernelError("Le module ipset renvoie une erreur : %s avec la commande %s" % (ret_value, cmd))

def test_ipset():
    tester = IpsetTester()
    tester.test()

class IpsetManagerTester:
    """
        Teste les fonctionnalités de base du manager
    """
    def test(self):
        try:
            self.test_create()
            self.test_get_all_groups()
            self.test_get_group()
            self.test_active_group()
            self.test_unactive_group()
            self.test_active_time()
            self.test_unactive_time()
        except:
            pass
        finally:
            self.test_delete()

    def test_create(self):
        assert group_manager.create_group(num_zone, gr_machine_name, ipfrom, ipto, eth)

    def test_get_all_groups(self):
        expected = [{'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'0', 'time':'0', 'interface':eth}]
        assert group_manager.get_all_groups(num_zone) == expected

    def test_get_group(self):
        expected = {'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'0', 'time':'0', 'interface':eth}
        assert group_manager.get_group(num_zone, gr_machine_name) == expected

    def test_active_group(self):
        group_manager.active(num_zone, gr_machine_name)
        expected = [{'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'1', 'time':'0', 'interface':eth}]
        assert group_manager.get_all_groups(0) == expected

    def test_unactive_group(self):
        group_manager.unactive(num_zone, gr_machine_name)
        expected = [{'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'0', 'time':'0', 'interface':eth}]
        assert group_manager.get_all_groups(0) == expected

    def test_active_time(self):
        group_manager.active_time(num_zone, gr_machine_name)
        expected = [{'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'0', 'time':'1', 'interface':eth}]
        assert group_manager.get_all_groups(0) == expected

    def test_unactive_time(self):
        group_manager.unactive_time(num_zone, gr_machine_name)
        expected = [{'name':gr_machine_name,'ip_from':ipfrom, 'ip_to':ipto,'active':'0', 'time':'0', 'interface':eth}]
        assert group_manager.get_all_groups(0) == expected

    def test_delete(self):
        group_manager.del_only_group(num_zone, gr_machine_name)
        assert not group_manager.is_group(num_zone, gr_machine_name)
        assert group_manager.get_all_groups(num_zone) == []

def test_ipset_manager():
    """
        test les fonctions de creation du manager
    """
    tester = IpsetManagerTester()
    tester.test()

class TimeManegerTester():
    """
        Teste le module de gestion des horaires de groupe de machine
    """
    def test(self):
        self.test_add_schedule()
        self.test_get_schedules()
        self.test_copy_schedules()
        self.test_del_schedule()

    def test_add_schedule(self):
        assert time_manager.add_schedule(num_zone, gr_machine_name, jour, hdeb1, hfin1)
        assert time_manager.add_schedule(num_zone, gr_machine_name, jour, hdeb2, hfin2)
        raises(Exception, time_manager.add_schedule, num_zone, gr_machine_name, jour, hdeb3, hfin3)

    def test_get_schedules(self):
        assert time_manager.get_schedules(num_zone) == {gr_machine_name:{jour:[{'hdeb':hdeb1, 'hfin':hfin1},
                                                                               {'hdeb':hdeb2, 'hfin':hfin2}
                                                                               ]
                                                                        }
                                                        }
    def test_copy_schedules(self):
        time_manager.copy_schedules(num_zone, gr_machine_name, gr_machine_name+"copy")
        expected_schedules = {jour:[{'hdeb':hdeb1, 'hfin':hfin1}, {'hdeb':hdeb2, 'hfin':hfin2}]}
        assert time_manager.get_schedules(num_zone) == {gr_machine_name:expected_schedules,
                                                        gr_machine_name+"copy":expected_schedules}

    def test_del_schedule(self):
        assert time_manager.del_schedule(num_zone, gr_machine_name, jour, hdeb1, hfin1)
        assert time_manager.del_schedule(num_zone, gr_machine_name, jour, hdeb2, hfin2)

def test_schedule():
    tester = TimeManegerTester()
    tester.test()


def _test_ipset_present(gr_name):
    save = "ipset --save"
    ret_code, ret_value = c.getstatusoutput(save)
    assert not ret_code
    for val in ret_value.split('\n'):
        if val.startswith('create {}'.format(gr_name)):
            return True
    return False

def test_group_perso():
    """une règle IPSET créée à la main pour l'utilisateur doit rester après génération des groupes de machines
    """
    #supprime la règle si existante
    delete = "ipset -X %s" % gr_machine_name
    c.getstatusoutput(delete)

    #créé la règle personnalisée
    create = "ipset create %s ipmap --from %s --to %s" % (gr_machine_name, ipfrom, ipto)
    ret_code, ret_value = c.getstatusoutput(create)
    assert _test_ipset_present(gr_machine_name)
    assert not ret_code, "erreur a la creation du set {} : {}".format(create, ret_value)

    #relance la génération des règles
    handler = rule_generator.RuleGenerator()
    handler.create_ip_sets()

    #la règle personnalisée existe encore
    assert _test_ipset_present(gr_machine_name)


def test_group_start_with_group():
    """une règle IPSET débutant par "group-" doit être supprimée
    """

    gr_name = "group-perso"
    #supprime la règle si existante
    delete = "ipset -X %s" % gr_name
    c.getstatusoutput(delete)

    #créé la règle personnalisée
    create = "ipset create %s ipmap --from %s --to %s" % (gr_name, ipfrom, ipto)
    ret_code, ret_value = c.getstatusoutput(create)
    assert _test_ipset_present(gr_name)
    assert not ret_code, "erreur a la creation du set {} : {}".format(create, ret_value)

    #relance la génération des règles
    handler = rule_generator.RuleGenerator()
    handler.create_ip_sets()

    #la règle personnalisée n'existe plus
    assert not _test_ipset_present(gr_name)


def teardown_module(module):
    """
        Supprime les fichiers temporaires utilisés pour les tests
    """
    if os.path.isfile(time_manager.time_file%0):
        os.unlink(time_manager.time_file%0)
    if os.path.isfile(group_manager.group_file%0):
        os.unlink(group_manager.group_file%0)

    group_manager.group_file = module.old_group_file
    time_manager.time_file = module.old_time_file
    assert bastion_restart()
