# -*- coding: utf-8 -*-


"""
    Outil de configuration du mode de filtrage de contenu (méta, on, off)
"""
from amon.guardian import config
from os.path import join
# désactivation du filtrage de contenu
empty = "'%s'"%join(config.DANS_DIR, 'listsf%d/empty')
dico_desactive = {
                    'anonregexplist':         empty,
                    'exceptionregexpurllist': empty,
                    'greyregexpurllist':      empty,
                    'bannedphraselist':       empty,
                    'weightedphraselist':     empty,
                    'exceptionphraselist':    empty,
                    'bannedregexpurllist':    empty,
                    'bannedextensionlist':    empty,
                    'bannedmimetypelist':     empty,
                    'contentregexplist':      empty,
                }

dico_desactive2 = {'weightedphrasemode': '2',
        'phrasefiltermode':   '1'}

# activation du filtrage de contenu complet
dico_active_c = {    'anonregexplist':         "'%s'"%join(config.DANS_DIR, 'listsf%d/anonregexplist'),
                     'exceptionregexpurllist': "'%s'"%join(config.DANS_DIR, 'listsf%d/exceptionregexpurllist'),
                     'greyregexpurllist':      "'%s'"%join(config.DANS_DIR, 'listsf%d/greyregexpurllist'),
                     'bannedphraselist':       "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedphraselist'),
                     'weightedphraselist':     "'%s'"%join(config.DANS_DIR, 'listsf%d/weightedphraselist'),
                     'exceptionphraselist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/exceptionphraselist'),
                     'bannedregexpurllist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedregexpurllist'),
                     'contentregexplist':      "'%s'"%join(config.DANS_DIR, 'listsf%d/contentregexplist'),
                     'bannedextensionlist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedextensionlist'),
                     'bannedmimetypelist':     "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedmimetypelist'),
                  }

dico_active_c2 = {'weightedphrasemode': '2',
                  'phrasefiltermode':   '1'}

# activation du filtrage de contenu sur META
dico_active_m = {    'anonregexplist':         "'%s'"%join(config.DANS_DIR, 'listsf%d/anonregexplist'),
                     'exceptionregexpurllist': "'%s'"%join(config.DANS_DIR, 'listsf%d/exceptionregexpurllist'),
                     'greyregexpurllist':      "'%s'"%join(config.DANS_DIR, 'listsf%d/greyregexpurllist'),
                     'bannedphraselist':       "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedphraselist'),
                     'weightedphraselist':     "'%s'"%join(config.DANS_DIR, 'listsf%d/weightedphraselist.meta'),
                     'exceptionphraselist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/exceptionphraselist'),
                     'bannedregexpurllist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedregexpurllist'),
                     'contentregexplist':      "'%s'"%join(config.DANS_DIR, 'listsf%d/contentregexplist'),
                     'bannedextensionlist':    "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedextensionlist'),
                     'bannedmimetypelist':     "'%s'"%join(config.DANS_DIR, 'listsf%d/bannedmimetypelist'),
                 }
dico_active_m2 = {'weightedphrasemode': '1',
                  'phrasefiltermode':   '3'}

########### modele de filtrage

def ouvrirfich(fich):
    liste = open(fich).read().splitlines()
    return liste

def ecrirefich(fich,liste):
    fh = open(fich,'w')
    fh.write('\n'.join(liste))
    fh.close()

def modifie_template_conf(fich, dico, zone, policy):
    """ edite les fichiers /etc/dansguardian/dansguardianZfX.conf
        pour la configuration du filtrage de contenu avec gestion de template
    """
    liste = ouvrirfich(fich)
    for i in liste:
        for j in dico:
            if j == i[:len(j)]:
                liste[liste.index(i)] = '%s = %s'%(j, dico[j]%(zone, policy))
    ecrirefich(fich,liste)

def modifie_conf(fich,dico):
    """ edite les fichiers /etc/dansguardian/dansguardianZ.conf
        et /etc/dansguardian/dansguardianZfX.conf
        pour la configuration du filtrage de contenu sans gestion de template
    """
    liste = ouvrirfich(fich)
    for i in liste:
        for j in dico:
            if j == i[:len(j)]:
                liste[liste.index(i)] = '%s = %s'%(j, dico[j])
    ecrirefich(fich,liste)

def desactive(zone):
    """ désactive le filtrage de contenu pour la zone zone """

    for policy in config.policies:
        # on teste car les rep listf2, listf3, listf4 n'existent pas
        if policy in config.spec_policies:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy), dico_desactive, zone, 1)
        else:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy), dico_desactive, zone, policy)

    modifie_conf(join(config.DANS_FULL_DIR, 'guardian.conf')%zone, dico_desactive2)

def active_c(zone):
    """ active le fitrage sur l'intérgalité des pages web pour la zone zone """

    for policy in config.policies:
        # on teste car les rep listf2, listf3, listf4 n'existent pas
        if policy in config.spec_policies:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy),dico_active_c, zone, 1)
        else:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy),dico_active_c, zone, policy)

    modifie_conf(join(config.DANS_FULL_DIR, 'guardian.conf')%zone,dico_active_c2)

def active_m(zone):
    """ active le fitrage sur les metas des pages web pour la zone zone """

    for policy in config.policies:
        # on teste car les rep listf2, listf3, listf4 n'existent pas
        if policy in config.spec_policies:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy),dico_active_m, zone, 1)
        else:
            modifie_template_conf(join(config.DANS_FULL_DIR, 'guardianf%d.conf')%(zone, policy),dico_active_m, zone, policy)

    modifie_conf(join(config.DANS_FULL_DIR, 'guardian.conf')%zone,dico_active_m2)
