#a simple elixir fork

import sqlalchemy
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import create_engine, orm, MetaData
from arv.config import sqlite_database


Entity = declarative_base()


class Query:
    def __get__(self, instance, owner):
        return session.query(owner)


def entity_add(self, *args, **kwargs):
    true_init(self, *args, **kwargs)
    session.add(self)


def entity_delete(self):
    session.delete(self)


Entity.query = Query()
true_init = Entity.__init__
Entity.__init__ = entity_add
Entity.delete = entity_delete


class BaseCollection(list):
    def __init__(self, entities=None):
        list.__init__(self)
        if entities is not None:
            self.extend(entities)

    def extend(self, entities):
        for e in entities:
            self.append(e)

    def clear(self):
        del self[:]

    def resolve_absolute(self, key, full_path, entity=None, root=None):
        if root is None:
            root = entity._descriptor.resolve_root
        if root:
            full_path = '%s.%s' % (root, full_path)
        module_path, classname = rsplit(full_path, '.', 1)
        module = sys.modules[module_path]
        res = getattr(module, classname, None)
        if res is None:
            if entity is not None:
                raise Exception("Couldn't resolve target '%s' <%s> in '%s'!"
                                % (key, full_path, entity.__name__))
            else:
                raise Exception("Couldn't resolve target '%s' <%s>!"
                                % (key, full_path))
        return res

    def __getattr__(self, key):
        return self.resolve(key)

# default entity collection
class GlobalEntityCollection(BaseCollection):
    def __init__(self, entities=None):
        # _entities is a dict of entities keyed on their name.
        self._entities = {}
        super(GlobalEntityCollection, self).__init__(entities)

    def append(self, entity):
        '''
        Add an entity to the collection.
        '''
        super(EntityCollection, self).append(entity)

        existing_entities = self._entities.setdefault(entity.__name__, [])
        existing_entities.append(entity)

    def resolve(self, key, entity=None):
        '''
        Resolve a key to an Entity. The optional `entity` argument is the
        "source" entity when resolving relationship targets.
        '''
        # Do we have a fully qualified entity name?
        if '.' in key:
            return self.resolve_absolute(key, key, entity)
        else:
            # Otherwise we look in the entities of this collection
            res = self._entities.get(key, None)
            if res is None:
                if entity:
                    raise Exception("Couldn't resolve target '%s' in '%s'"
                                    % (key, entity.__name__))
                else:
                    raise Exception("This collection does not contain any "
                                    "entity corresponding to the key '%s'!"
                                    % key)
            elif len(res) > 1:
                raise Exception("'%s' resolves to several entities, you should"
                                " use the full path (including the full module"
                                " name) to that entity." % key)
            else:
                return res[0]

    def clear(self):
        self._entities = {}
        super(GlobalEntityCollection, self).clear()

# default session
engine = create_engine('sqlite:///%s' % sqlite_database)
session = orm.scoped_session(orm.sessionmaker(bind=engine))


#metadatas = set()
#
## default metadata
#metadata = sqlalchemy.MetaData()

# default entity collection
entities = GlobalEntityCollection()


def _cleanup_autosetup_triggers(cls):
    if not hasattr(cls, '_has_triggers'):
        return

    for name in ('table', 'mapper'):
        setattr(cls, name, None)

    for name in ('c', 'query'):
        delattr(cls, name)

    desc = cls._descriptor
    md = desc.metadata

    # the fake table could have already been removed (namely in a
    # single table inheritance scenario)
    md.tables.pop(cls._table_key, None)

    del cls._has_triggers


def setup_entities(entities):
    '''Setup all entities in the list passed as argument'''

    for entity in entities:
        # delete all Elixir properties so that it doesn't interfere with
        # SQLAlchemy. At this point they should have be converted to
        # builders.
        for name, attr in entity.__dict__.items():
            if isinstance(attr, Property):
                delattr(entity, name)

        if entity._descriptor.autosetup:
            _cleanup_autosetup_triggers(entity)

    for method_name in (
            'setup_autoload_table', 'create_pk_cols', 'setup_relkeys',
            'before_table', 'setup_table', 'setup_reltables', 'after_table',
            'setup_events',
            'before_mapper', 'setup_mapper', 'after_mapper',
            'setup_properties',
            'finalize'):
#        if DEBUG:
#            print "=" * 40
#            print method_name
#            print "=" * 40
        for entity in entities:
#            print entity.__name__, "...",
            if hasattr(entity, '_setup_done'):
#                print "already done"
                continue
            method = getattr(entity._descriptor, method_name)
            method()
#            print "ok"


def create_all():
    Entity.metadata.create_all(engine)


def setup_all():
    '''Setup the table and mapper of all entities in the default entity
    collection.

    This is called automatically if any entity of the collection is configured
    with the `autosetup` option and it is first accessed,
    instanciated (called) or the create_all method of a metadata containing
    tables from any of those entities is called.
    '''
    setup_entities(entities)
