# -*- coding: utf-8 -*-
from sqlalchemy.orm import sessionmaker
from sqlalchemy import create_engine
from sqlalchemy.orm import mapper
from sqlalchemy import Table, Column, Integer, String, MetaData, ForeignKey, LargeBinary as Binary, Text, Index
from sqlalchemy.sql.functions import current_timestamp

metadata = MetaData()
#metadata.bind.echo = True
# ____________________________________________________________

"""
>>> import sqlalchemy
>>> sqlalchemy.__version__
'0.5.8'

http://www.sqlalchemy.org/docs/05/
http://www.sqlalchemy.org/docs/05/ormtutorial.html
http://www.sqlalchemy.org/docs/05/sqlexpression.html
"""

# table identities
"""
CREATE TABLE identities (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  type INTEGER NOT NULL,
  data BLOB NOT NULL,
  UNIQUE (type, data)
);
"""
identities_table = Table('identities', metadata,
                Column('id', Integer, primary_key=True, autoincrement=True),
                Column('type', Integer, nullable=False), #FIXME : UNIQUE (data) => UNIQUE (type, data)
                Column('data', Binary, unique=True)
                )

# table proposals
"""
CREATE TABLE proposals (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  proposal TEXT NOT NULL
);

"""
proposals_table = Table('proposals', metadata,
                  Column('id', Integer, primary_key=True, autoincrement=True),
                  Column('proposal', Text, nullable=False)
                  )

# table ike_config_proposal
"""
CREATE TABLE ike_config_proposal (
  ike_cfg INTEGER NOT NULL,
  prio INTEGER NOT NULL,
  prop INTEGER NOT NULL
);
"""
ike_config_proposal_table = Table('ike_config_proposal', metadata,
                  Column('ike_cfg', Integer, nullable=False, primary_key=True),
                  Column('prio', Integer, nullable=False, primary_key=False),
                  Column('prop', Integer, nullable=False, primary_key=True),
                  )

# table child_config_proposal
"""
CREATE TABLE child_config_proposal (
  child_cfg INTEGER NOT NULL,
  prio INTEGER NOT NULL,
  prop INTEGER NOT NULL
);
"""
child_config_proposal_table = Table('child_config_proposal', metadata,
                  Column('child_cfg', Integer, nullable=False, primary_key=True),
                  Column('prio', Integer, nullable=False, primary_key=False),
                  Column('prop', Integer, nullable=False, primary_key=True),
                  )

# table child_configs
"""
CREATE TABLE child_configs (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  lifetime INTEGER NOT NULL DEFAULT '1200',
  rekeytime INTEGER NOT NULL DEFAULT '1020',
  jitter INTEGER NOT NULL DEFAULT '180',
  updown TEXT DEFAULT NULL,
  hostaccess INTEGER NOT NULL DEFAULT '0',
  mode INTEGER NOT NULL DEFAULT '2',
  dpd_action INTEGER NOT NULL DEFAULT '2',
  start_action INTEGER NOT NULL DEFAULT '2',
  close_action INTEGER NOT NULL DEFAULT '0',
  ipcomp INTEGER NOT NULL DEFAULT '0'
  reqid INTEGER NOT NULL DEFAULT '0'
);
"""
childconfigs_table = Table('child_configs', metadata,
                Column('id', Integer, primary_key=True, autoincrement=True),
                Column('name', Text, nullable=False),
		        Column('lifetime', Integer, nullable=False, default=1200),
	        	Column('rekeytime', Integer, nullable=False, default=1020),
	        	Column('jitter', Integer, nullable=False, default=180),
                Column('updown', Text, nullable=True, default=None),
		        Column('hostaccess', Integer, nullable=False, default=0),
		        Column('mode', Integer, nullable=False, default=2),
		        Column('dpd_action', Integer, nullable=False, default=2),
		        Column('start_action', Integer, nullable=False, default=2),
		        Column('close_action', Integer, nullable=False, default=0),
		        Column('ipcomp', Integer, nullable=False, default=0),
		        Column('reqid', Integer, nullable=False, default=0)
                )

# index child_configs_name
"""
CREATE INDEX child_configs_name ON child_configs (
  name
);
"""
Index('child_configs_name', childconfigs_table.c.name)

# table child_config_traffic_selector
# FIXME ajout manuel de clef primaire
# PRIMARY KEY sur child_cfg INTEGER NOT NULL,
# primary_key=True, autoincrement=False
"""
CREATE TABLE child_config_traffic_selector (
  child_cfg INTEGER NOT NULL,
  traffic_selector INTEGER NOT NULL,
  kind INTEGER NOT NULL
);
"""
childconfigtrafficselector_table = Table('child_config_traffic_selector', metadata,
	        	Column('child_cfg', Integer, nullable=False, primary_key=True),
		        Column('traffic_selector', Integer, nullable=False, primary_key=True),
		        Column('kind', Integer, nullable=False)
                )
# index child_config_traffic_selector_all
"""
CREATE INDEX child_config_traffic_selector_all ON child_config_traffic_selector (
  child_cfg, traffic_selector
);
"""
Index('child_config_traffic_selector_all', childconfigtrafficselector_table.c.child_cfg,
                childconfigtrafficselector_table.c.traffic_selector
                )

# table ike_configs
"""
CREATE TABLE ike_configs (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  certreq INTEGER NOT NULL DEFAULT '1',
  force_encap INTEGER NOT NULL DEFAULT '0',
  local TEXT NOT NULL,
  remote TEXT NOT NULL
);
"""
ikeconfigs_table = Table('ike_configs', metadata,
                Column('id', Integer, primary_key=True, autoincrement=True),
		        Column('certreq', Integer, nullable=False, default=1),
		        Column('force_encap', Integer, nullable=False, default=0),
                Column('local', Text, nullable=False),
                Column('remote', Text, nullable=False)
                )

# table peer_configs
"""
CREATE TABLE peer_configs (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  ike_version INTEGER NOT NULL DEFAULT '2',
  ike_cfg INTEGER NOT NULL,
  local_id TEXT NOT NULL,
  remote_id TEXT NOT NULL,
  cert_policy INTEGER NOT NULL DEFAULT '1',
  uniqueid INTEGER NOT NULL DEFAULT '0',
  auth_method INTEGER NOT NULL DEFAULT '1',
  eap_type INTEGER NOT NULL DEFAULT '0',
  eap_vendor INTEGER NOT NULL DEFAULT '0',
  keyingtries INTEGER NOT NULL DEFAULT '1',
  rekeytime INTEGER NOT NULL DEFAULT '0',
  reauthtime INTEGER NOT NULL DEFAULT '3600',
  jitter INTEGER NOT NULL DEFAULT '180',
  overtime INTEGER NOT NULL DEFAULT '300',
  mobike INTEGER NOT NULL DEFAULT '1',
  dpd_delay INTEGER NOT NULL DEFAULT '120',
  virtual TEXT DEFAULT NULL,
  pool TEXT DEFAULT NULL,
  mediation INTEGER NOT NULL DEFAULT '0',
  mediated_by INTEGER NOT NULL DEFAULT '0',
  peer_id INTEGER NOT NULL DEFAULT '0'
);
"""
peerconfigs_table = Table('peer_configs', metadata,
                Column('id', Integer, primary_key=True, autoincrement=True),
                Column('name', Text, nullable=False),
		        Column('ike_version', Integer, nullable=False, default=2),
		        Column('ike_cfg', Integer, nullable=False),
                Column('local_id', Text, nullable=False),
                Column('remote_id', Text, nullable=False),
		        Column('cert_policy', Integer, nullable=False, default=1),
		        Column('uniqueid', Integer, nullable=False, default=0),
		        Column('auth_method', Integer, nullable=False, default=1),
		        Column('eap_type', Integer, nullable=False, default=0),
		        Column('eap_vendor', Integer, nullable=False, default=0),
		        Column('keyingtries', Integer, nullable=False, default=1),
		        Column('rekeytime', Integer, nullable=False, default=0),
		        Column('reauthtime', Integer, nullable=False, default=3600),
		        Column('jitter', Integer, nullable=False, default=180),
		        Column('overtime', Integer, nullable=False, default=300),
		        Column('mobike', Integer, nullable=False, default=1),
		        Column('dpd_delay', Integer, nullable=False, default=120),
                Column('virtual', Text, nullable=True, default=None),
                Column('pool', Text, nullable=True, default=None),
		        Column('mediation', Integer, nullable=False, default=0),
		        Column('mediated_by', Integer, nullable=False, default=0),
		        Column('peer_id', Integer, nullable=False, default=0)
                )

# index peer_configs_name
"""
CREATE INDEX peer_configs_name ON peer_configs (
  name
);
"""
Index('peer_configs_name', peerconfigs_table.c.name)

# table peer_config_child_config
"""
CREATE TABLE peer_config_child_config (
  peer_cfg INTEGER NOT NULL,
  child_cfg INTEGER NOT NULL,
  PRIMARY KEY (peer_cfg, child_cfg)
);
"""
peerconfigchildconfig_table = Table('peer_config_child_config', metadata,
		        Column('peer_cfg', Integer, nullable=False, primary_key=True),
		        Column('child_cfg', Integer, nullable=False, primary_key=True),
                )

# table traffic_selectors
"""
CREATE TABLE traffic_selectors (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  type INTEGER NOT NULL DEFAULT '7',
  protocol INTEGER NOT NULL DEFAULT '0',
  start_addr BLOB DEFAULT NULL,
  end_addr BLOB DEFAULT NULL,
  start_port INTEGER NOT NULL DEFAULT '0',
  end_port INTEGER NOT NULL DEFAULT '65535'
);
"""
trafficselectors_table = Table('traffic_selectors', metadata,
                Column('id', Integer, primary_key=True, autoincrement=True),
                Column('type', Integer, nullable=False, default=7),
                Column('protocol', Integer, nullable=False, default=0),
                Column('start_addr', Binary, nullable=True, default=None),
                Column('end_addr', Binary, nullable=True, default=None),
                Column('start_port', Integer, nullable=False, default=0),
                Column('end_port', Integer, nullable=False, default=65535)
                )

# table certificates
"""
CREATE TABLE certificates (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  type INTEGER NOT NULL,
  keytype INTEGER NOT NULL,
  data BLOB NOT NULL
);
"""
certificates_table = Table('certificates', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('type', Integer, nullable=False),
                Column('keytype', Integer, nullable=False),
                Column('data', Binary, nullable=False)
                )

# table certificate_authorities
"""
CREATE TABLE certificate_authorities (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  certificate INTEGER NOT NULL
);
"""
certificate_authorities_table = Table('certificate_authorities', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('certificate', Integer, nullable=False),
                )
# table certificate_distribution_points
"""
CREATE TABLE certificate_distribution_points (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  ca INTEGER NOT NULL,
  type INTEGER NOT NULL,
  uri TEXT NOT NULL
);
"""
certificate_distribution_points_table = Table('certificate_distribution_points', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('ca', Integer, nullable=False),
                Column('type', Integer, nullable=False),
                Column('uri', Text, nullable=False)
                )
# table certificate_identity
"""
CREATE TABLE certificate_identity (
  certificate INTEGER NOT NULL,
  identity INTEGER NOT NULL,
  PRIMARY KEY (certificate, identity)
);

"""
certificateidentity_table = Table('certificate_identity', metadata,
                Column('certificate', Integer, nullable=False, primary_key=True),
                Column('identity', Integer, nullable=False, primary_key=True)
                )

# table private_keys
"""
CREATE TABLE private_keys (
  id INTEGER NOT NULL  PRIMARY KEY AUTOINCREMENT,
  type INTEGER NOT NULL,
  data BLOB NOT NULL
);
"""
privatekeys_table = Table('private_keys', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('type', Integer, nullable=False),
                Column('data', Binary, nullable=False)
                )

# table private_key_identity
"""
CREATE TABLE private_key_identity (
  private_key INTEGER NOT NULL,
  identity INTEGER NOT NULL,
  PRIMARY KEY (private_key, identity)
);
"""
privatekeyidentity_table = Table('private_key_identity', metadata,
                Column('private_key', Integer, nullable=False, primary_key=True),
                Column('identity', Integer, nullable=False, primary_key=True)
                )

# table shared_secrets
"""
CREATE TABLE shared_secrets (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  type INTEGER NOT NULL,
  data BLOB NOT NULL
);
"""
sharedsecrets_table = Table('shared_secrets', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('type', Integer, nullable=False),
                Column('data', Binary, nullable=False)
                )

# table shared_secret_identity
"""
CREATE TABLE shared_secret_identity (
  shared_secret INTEGER NOT NULL,
  identity INTEGER NOT NULL,
  PRIMARY KEY (shared_secret, identity)
);
"""
sharedsecretidentity_table = Table('shared_secret_identity', metadata,
                Column('shared_secret', Integer, nullable=False, primary_key=True),
                Column('identity', Integer, nullable=False, primary_key=True)
                )

# table pools
"""
CREATE TABLE pools (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  start BLOB NOT NULL,
  end BLOB NOT NULL,
  timeout INTEGER NOT NULL
);
"""
pools_table = Table('pools', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('name', Text, nullable=False),
                Column('start', Binary, nullable=False),
                Column('end', Binary, nullable=False),
                Column('timeout', Integer, nullable=False)
                )

# index pools_name
"""
CREATE INDEX pools_name ON pools (
  name
);
"""
Index('pools_name', pools_table.c.name)

# table addresses
"""
CREATE TABLE addresses (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  pool INTEGER NOT NULL,
  address BLOB NOT NULL,
  identity INTEGER NOT NULL DEFAULT 0,
  acquired INTEGER NOT NULL DEFAULT 0,
  released INTEGER NOT NULL DEFAULT 1
);
"""
addresses_table = Table('addresses', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('pool', Integer, nullable=False),
                Column('address', Binary, nullable=False),
                Column('identity', Integer, nullable=False, default=0),
                Column('acquired', Integer, nullable=False, default=0),
                Column('released', Integer, nullable=False, default=1)
                )

# index addresses_pool
"""
CREATE INDEX addresses_pool ON addresses (
  pool
);
"""
Index('addresses_pool', addresses_table.c.pool)

# index addresses_address
"""
CREATE INDEX addresses_address ON addresses (
  address
);
"""
Index('addresses_address', addresses_table.c.address)

# index addresses_identity
"""
CREATE INDEX addresses_identity ON addresses (
  identity
);
"""
Index('addresses_identity', addresses_table.c.identity)

# table leases
"""
CREATE TABLE leases (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  address INTEGER NOT NULL,
  identity INTEGER NOT NULL,
  acquired INTEGER NOT NULL,
  released INTEGER NOT NULL
);
"""
leases_table = Table('leases', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('address', Integer, nullable=False),
                Column('identity', Integer, nullable=False),
                Column('acquired', Integer, nullable=False),
                Column('released', Integer, nullable=False)
                )

# table attribute_pools
"""
CREATE TABLE attribute_pools (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL
);
"""
attributepools_table = Table('attribute_pools', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('name', Text, nullable=False)
                )

# table attributes
"""
CREATE TABLE attributes (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  identity INTEGER NOT NULL DEFAULT 0,
  pool INTEGER NOT NULL DEFAULT 0,
  type INTEGER NOT NULL,
  value BLOB NOT NULL
);
"""
attributes_table = Table('attributes', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('identity', Integer, nullable=False, default=0),
                Column('pool', Integer, nullable=False, default=0),
                Column('type', Integer, nullable=False),
                Column('value', Binary, nullable=False)
                )

# index attributes_identity
"""
CREATE INDEX attributes_identity ON attributes (
  identity
);
"""
Index('attributes_identity', attributes_table.c.identity)

# index attributes_pool
"""
CREATE INDEX attributes_pool ON attributes (
  pool
);
"""
Index('attributes_pool', attributes_table.c.pool)

# table ike_sas
"""
CREATE TABLE ike_sas (
  local_spi BLOB NOT NULL PRIMARY KEY,
  remote_spi BLOB NOT NULL,
  id INTEGER NOT NULL,
  initiator INTEGER NOT NULL,
  local_id_type INTEGER NOT NULL,
  local_id_data BLOB DEFAULT NULL,
  remote_id_type INTEGER NOT NULL,
  remote_id_data BLOB DEFAULT NULL,
  host_family INTEGER NOT NULL,
  local_host_data BLOB NOT NULL,
  remote_host_data BLOB NOT NULL,
  created INTEGER NOT NULL DEFAULT CURRENT_TIMESTAMP
);
"""
ikesas_table = Table('ike_sas', metadata,
                Column('local_spi', Binary, nullable=False, primary_key=True),
                Column('remote_spi', Binary, nullable=False),
                Column('id', Integer, nullable=False),
                Column('initiator', Integer, nullable=False),
                Column('local_id_type', Integer, nullable=False),
                Column('local_id_data', Binary, nullable=False),
                Column('remote_id_type', Integer, nullable=False),
                Column('remote_id_data', Binary, nullable=False),
                Column('host_family', Integer, nullable=False),
                Column('local_host_data', Binary, nullable=False),
                Column('remote_host_data', Binary, nullable=False),
                Column('created', Integer, nullable=False, default=current_timestamp())
                )

# table logs
"""
CREATE TABLE logs (
  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  local_spi BLOB NOT NULL,
  signal INTEGER NOT NULL,
  level INTEGER NOT NULL,
  msg TEXT NOT NULL,
  time INTEGER NOT NULL DEFAULT CURRENT_TIMESTAMP
);
"""
logs_table = Table('logs', metadata,
                Column('id', Integer, nullable=False, primary_key=True, autoincrement=True),
                Column('local_spi', Binary, nullable=False),
                Column('signal', Integer, nullable=False),
                Column('level', Integer, nullable=False),
                Column('msg', Text, nullable=False),
                Column('time', Integer, nullable=False, default=current_timestamp())
                )

# ____________________________________________________________
# StrongSwan objects build from the tables
class Arguments(object):
    def __init__(self, **args):
        for key, value in args.items():
            setattr(self, key, value)

bindings = {
    'Identity': identities_table,
    'ChildConfig': childconfigs_table,
    'Proposals': proposals_table,
    'IkeConfigProposal': ike_config_proposal_table,
    'ChildConfigProposal': child_config_proposal_table,
    'ChildConfigTrafficSelector': childconfigtrafficselector_table,
    'IkeConfigs': ikeconfigs_table,
    'PeerConfigs': peerconfigs_table,
    'PeerConfigChildConfig': peerconfigchildconfig_table,
    'TrafficSelectors': trafficselectors_table,
    'Certificates': certificates_table,
    'CertificateIdentity': certificateidentity_table,
    'CertificateAuthorities': certificate_authorities_table,
    'CertificateDistributionPoints': certificate_distribution_points_table,
    'PrivateKey': privatekeys_table,
    'SharedSecrets': sharedsecrets_table,
    'SharedSecretIdentity': sharedsecretidentity_table,
    'Pools': pools_table,
    'Addresses': addresses_table,
    'Leases': leases_table,
    'AttributePools': attributepools_table,
    'Attributes': attributes_table,
    'IkeSas': ikesas_table,
    'PrivateKeyIdentity': privatekeyidentity_table,
    'Logs': logs_table
    }

glob = globals()

for cls in bindings:
    glob[cls] = type(cls, (Arguments,), {})

for cls, table in bindings.items():
    # primary_key = None
    # no primary_key for ... 'child_config_proposal'
    if cls in ['ChildConfigProposal']:
        mapper(glob[cls], table)
    else:
        mapper(glob[cls], table)

# ____________________________________________________________
def initialise(strongswan_database):
    engine = create_engine(strongswan_database)
    metadata.create_all(engine)
    Session = sessionmaker(bind=engine)
    return Session()

def purge_database(strongswan_database):
    engine = create_engine(strongswan_database)
    con = engine.connect()
    trans = con.begin()
    for name, table in metadata.tables.items():
        con.execute(table.delete())
    trans.commit()
    Session = sessionmaker(bind=engine)
    session = Session()
    return session

def rollback_database(session):
    session.rollback()

