# -*- coding: utf-8 -*-
"""
    Standard errno symbols
"""

"""Dictionary providing a mapping from the errno value to the string
name in the underlying waring. For instance,
errno.errorcode[errno.EPERM] maps to 'EPERM'."""

errorlevel = {
        1: 'error',
        2: 'warning',
        3: 'info',
}

errorcode = {
        1: ('ERROR', 1),
        2: ('WARNING', 2),
        3: ('INFO', 3),
        4: ('NAME', 1),
        5: ('NAME', 2),
        6: ('NAME', 3),
        7: ('UNUSED', 1),
        8: ('UNUSED', 2),
        9: ('UNUSED', 3),
}

globs = globals()

for key, value in errorlevel.items():
    globs[value] = key


