# -*- coding: utf-8 -*-

import sys
from creole.lint import warnsymb


class Warn:

    def __init__(self, write_level, itemname, warnno, comment, checks):
        self.warnno = warnno
        self.comment = comment
        self.checks = checks
        self.write_level = getattr(warnsymb, write_level)

    def to_dict(self):
        """
            formats a msg warn directly from a warning message
        """
        dico_loc = {}
        for var in self.checks:
            if hasattr(var, 'location'):
                locs = var.location
                for vfile, vline in locs:
                    if vfile == 'dictionnaire':
                        raise Exception('vfile ne doit pas se nommer dictionnaire !!!')
                    if not dico_loc.has_key(vfile):
                        dico_loc[vfile] = []
                    dico_loc[vfile].append((vline, var))
            else:
                if not dico_loc.has_key('dictionnaire'):
                    dico_loc['dictionnaire'] = []
                dico_loc['dictionnaire'].append((None, var))
#                ret = ["[%s:%s:%s] %s : %s (dictionnaire)" %(level, name, self.itemname, self.comment, vname)]
        return dico_loc
