#-*-coding:utf-8*-*
from commands import getstatusoutput
from os import unlink, system
from os.path import isfile
from creole.client import CreoleClient

test_file = '/tmp/test_process'

def _delete_test_file():
    if isfile(test_file):
        unlink(test_file)

def test_runcmd_code_ok():
    assert system('CreoleRun "echo"') == 0

def test_runcmd_code_err():
    _delete_test_file()
    assert system('CreoleRun "ls %s 2>/dev/null"' % test_file) != 0

def test_runcmd_out_ok():
    output = getstatusoutput('CreoleRun "echo -n coucou"')
    assert output[0] == 0
    assert output[1] == 'coucou'

def test_runcmd_out_err():
    _delete_test_file()
    output = getstatusoutput('CreoleRun "ls %s"' % test_file)
    assert output[0] != 1
    # getstatusoutput concatène stdout et stderr
    assert test_file in output[1]

def test_runcmd_out_stdin():
    output = getstatusoutput('echo hello | CreoleRun "cat"')
    assert output[1] == 'hello'

def test_containers():
    """
    Vérifie que la sortie est identique quelque soit le mode
    """
    containers = CreoleClient().get_containers()
    for container in containers:
        # recherche du 1er conteneur différent de root
        if container['name'] not in ['all', 'root']:
            s1 = getstatusoutput('CreoleRun "echo \'\\\\\'" root')
            s2 = getstatusoutput('CreoleRun "echo \'\\\\\'" %s' % container['name'])
            assert s1 == s2
            # Gestion du caractère "*" : #14894
            system('touch {0}'.format(test_file))
            system('CreoleRun "touch {0}" {1}'.format(test_file+'2', container['name']))
            code, res = getstatusoutput('CreoleRun "ls {0}*" {1}'.format(test_file, container['name']))
            if container['real_container'] == 'root':
                assert res == '{0}\n{0}2'.format(test_file)
            else:
                assert res == test_file+'2'
            break
