#-*-coding:utf-8*-*
"""
Tests liés à la migration de variables
"""
from os.path import join, isfile
from creole import eosfunc
from creole.loader import creole_loader
from pyeole.log import init_logging

log=init_logging()

CONFIG_DIR = '/usr/share/creole/tests/configs'
DICO_DIR = '/usr/share/eole/creole/dicos'

def _calc_config_file(test):
    """
    nom du fichier eol lié au test
    """
    return join(CONFIG_DIR, '{0}.eol'.format(test))

def _get_value(config, variable):
    """
    Retourne la valeur d'une variable "connue"
    """
    path = config.find_first(byname=variable, type_='path')
    return config.getattr(path, force_permissive=True)

def _isdico(name):
    """
    Vérifie la présence d'un dictionnaire
    """
    return isfile(join(DICO_DIR, '{}.xml'.format(name)))


def _is_default(config, variable):
    option = config.find_first(byname=variable, type_='option')
    return config.cfgimpl_get_values().is_default_owner(option)


def test_upgrade_hosts_from23():
    """
    Vérifie la migration des variables "activer_ajout_hosts"
    depuis une configuration 2.3 contenant des majuscules #11473
    et un doublon sur le nom court #12266
    """
    if not isfile(join(DICO_DIR, '27_eolead_container.xml')):
        config = creole_loader(force_configeol=_calc_config_file('hosts23'))
        assert _get_value(config, 'activer_ajout_hosts') == 'oui'
        assert _get_value(config, 'nom_court_hosts') == ['min', 'maj', 'wpad', None]
        assert _get_value(config, 'nom_long_hosts') == ['min.min', 'maj.maj', 'wpad.admin.lan', 'wpad.pedago.lan']

def test_upgrade_scribe_dmz():
    """
    Vérifie la migration de la variable "install_scribe_dmz"
    en fonction du remplissage des esclaves associées #11713
    ce test n'est pas compatible avec AmonEcole #11796
    """
    if isfile(join(DICO_DIR, '10_era.xml')) and not isfile(join(DICO_DIR, '50_amonecole.xml')):
        config = creole_loader(force_configeol=_calc_config_file('scribe_dmz_ok'))
        assert _get_value(config, 'install_scribe_dmz') == 'oui'
        config = creole_loader(force_configeol=_calc_config_file('scribe_dmz_ko'))
        assert _get_value(config, 'install_scribe_dmz') == 'non'

def test_serveur_maj():
    """
    Vérifie la migration de la variable serveur_maj
    Les serveurs officiels doivent être renommés
    """
    config = creole_loader(force_configeol=_calc_config_file('maj23'))
    assert _get_value(config, 'serveur_maj') == ['test-eole.ac-dijon.fr', 'eole.ac-dijon.fr', 'eoleng.ac-test.fr', 'ftp.crihan.fr']


#####################################
# tests spécifiques à EOLE >= 2.4.2 #
#####################################

def test_upgrade_force_envole():
    """
    Vérifie la valeur de la redirection par défaut "web_redirection"
    dans le cas où Envole était activé #11582
    test modifié suite à la suppression de la variable alias_envole #10549
    """
    if isfile('/usr/share/eole/creole/dicos/20_web.xml'):
        config = creole_loader(force_configeol=_calc_config_file('envole'))
        if isfile('/usr/share/eole/creole/dicos/21_posh.xml'):
            assert _get_value(config, 'web_redirection') == u'/envole'
        else:
            assert _get_value(config, 'web_redirection') == u'/testenvole'


#####################################
# tests spécifiques à EOLE >= 2.5.0 #
#####################################

def test_upgrade_nut_monitor():
    """
    Vérifie l'activation de la variable "nut_monitor"
    si un onduleur esclave était déclaré #11608
    """
    config = creole_loader(force_configeol=_calc_config_file('onduleur24'))
    assert _get_value(config, 'nut_monitor') == u'oui'

def test_upgrade_postgresql():
    """
    Vérifie la mise à jour des variables postgeSQL #11222
    """
    if isfile('/usr/share/eole/creole/dicos/22_postgresql.xml'):
        config = creole_loader(force_configeol=_calc_config_file('postgres23_default'))
        assert _get_value(config, 'pg_shared_buffers') == 128
        assert _get_value(config, 'pg_shared_buffers_unit') == u'MB'
        config = creole_loader(force_configeol=_calc_config_file('postgres23_modif'))
        assert _get_value(config, 'pg_shared_buffers') == 6000
        assert _get_value(config, 'pg_shared_buffers_unit') == u'kB'


#####################################
# tests spécifiques à EOLE >= 2.5.1 #
#####################################

def test_upgrade_zone_forward():
    """
    Vérifie l'activation de la variable "activer_zone_forward"
    si des zones étaient déclarées #11922
    """
    if isfile('/usr/share/eole/creole/dicos/22_dns.xml'):
        config = creole_loader(force_configeol=_calc_config_file('zone_forward24'))
        assert _get_value(config, 'activer_zone_forward') == u'oui'

def test_upgrade_bareos_from23():
    """
    Valide le renommage des variables bacula en bareos
    entre 2.3 et 2.5.1 #13957
    """
    if isfile('/usr/share/eole/creole/dicos/23_bareos.xml'):
        config = creole_loader(force_configeol=_calc_config_file('bacula23'))
        assert _get_value(config, 'bareos_full_retention') == 13

def test_upgrade_amon23():
    """
    Valide que la migration des variables "etb1.amon" va à son terme #14589
    """
    if isfile('/usr/share/eole/creole/dicos/30_amon.xml'):
        config = creole_loader(force_configeol=_calc_config_file('amon23'))
        assert config.impl_get_information('upgrade', False) == '2.3'
        assert _get_value(config, 'half_closed_clients') == 'off'
        # ajout validation 2.7.0 (#25039)
        assert _get_value(config, 'ssl_subjectaltname') == [u'amonecole.etb3.ac-test.fr']


#####################################
# tests spécifiques à EOLE >= 2.5.2 #
#####################################

def test_upgrade_sphynxhamaster():
    """
    Valide la migration des variables haute-dispo
    sur le master #14881
    """
    if isfile('/usr/share/eole/creole/dicos/30_sphynx.xml'):
        config = creole_loader(force_configeol=_calc_config_file('hamaster241'))
        assert _get_value(config, 'activer_haute_dispo') == 'maitre'
        assert _get_value(config, 'vip_externe') == '192.168.0.10'
        assert _get_value(config, 'vip_interne') == '172.30.101.10'
        assert _get_value(config, 'vip_resource_netmask') == ['255.255.255.0', '255.255.255.0']
        assert _get_value(config, 'vip_resource_gw') == ['192.168.0.1', '255.255.255.255']
        assert _get_value(config, 'service_resource_name') == [u'ipsec_rsc', u'arv_rsc']
        assert _get_value(config, 'service_resource_script') == [u'strongswan', u'arv']
        assert _get_value(config, 'service_resource_arv_startdelay') == 30
        assert _get_value(config, 'service_resource_startdelay') == [15, 30]
        assert _get_value(config, 'activer_resource_arv') == u'oui'


#####################################
# tests spécifiques à EOLE >= 2.6.0 #
#####################################

def test_upgrade_eth_name():
    """
    Valide la migration des variables faisant référence aux noms des interfaces ethX sur eolebase
    """
    config = creole_loader(force_configeol=_calc_config_file('upgrade_eth_name252'))
    assert _get_value(config, 'route_int') == ['0', '1', '2', '3', '4']
    if _isdico('20_dhcrelay') and not _isdico('50_amonecole'):
        assert _get_value(config, 'dhcrelay_interfaces') == ['1', '2']
        assert _get_value(config, 'dhcrelay_server_interface') == '3'
    if _isdico('26_freeradius'):
        assert _get_value(config, 'freerad_listen_int') == '2'
    if _isdico('20_vpn'):
        assert _get_value(config, 'sw_force_ip_src') == '1'
    if _isdico('02_haute_dispo'):
        assert _get_value(config, 'activer_haute_dispo') == 'maitre'
        assert _get_value(config, 'vip_resource_if') == ['0', '1']
        assert _get_value(config, 'corosync_dial_if') == '2'


#####################################
# tests spécifiques à EOLE >= 2.6.1 #
#####################################

def test_upgrade_ntlm():
    """
    Migration des variables NTLM/SMB (#18277)
    """
    if isfile('/usr/share/eole/creole/dicos/23_proxy.xml'):
        config = creole_loader(force_configeol=_calc_config_file('ntlm'))
        assert _get_value(config, 'nom_serveur_smb') == 'scribe'
        assert _get_value(config, 'nom_domaine_smb') == 'dompedago'
        assert _get_value(config, 'ip_serveur_smb') == '10.1.3.5'

def test_upgrade_nom_interface():
    """
    Migration des variables nom_carte_ethX
    """
    config = creole_loader(force_configeol=_calc_config_file('nom_carte'))
    assert _get_value(config, 'nom_carte_eth0') == [eosfunc.get_net_devices()[0]]
    assert _get_value(config, 'nom_carte_eth1') == [u'carte1']


#####################################
# tests spécifiques à EOLE >= 2.6.2 #
#####################################

def test_upgrade_dhcp():
    """
    Valide le remplissage de la nouvelle variable obligatoire nom_plage_dhcp
    """
    if isfile('/usr/share/eole/creole/dicos/20_dhcp.xml'):
        config = creole_loader(force_configeol=_calc_config_file('plagedhcp'), rw=True)
        config.creole.services.activer_dhcp = u'oui'
        assert _get_value(config, 'nom_plage_dhcp') == [u'plage0', u'plage1']

def test_upgrade_backend_ead():
    """
    Valide le remplissage des nouvelles variables obligatoires ip_frontend_ead_distant_ethX et netmask_frontend_ead_distant_ethX
    """
    config = creole_loader(force_configeol=_calc_config_file('config_261'))
    assert _get_value(config, 'acces_distant_backend_ead') == 'oui'
    if isfile('/usr/share/eole/creole/dicos/28_openvswitch.xml'):
        nombre_interfaces = 1 #hack for Hâpy #21039
    else:
        nombre_interfaces = int(_get_value(config, 'nombre_interfaces'))
    for interface in [str(n) for n in range(nombre_interfaces)]:
        variable_frontend = 'frontend_ead_distant_eth' + interface
        variable_ip = 'ip_frontend_ead_distant_eth' + interface
        variable_netmask = 'netmask_frontend_ead_distant_eth' + interface
        assert _get_value(config, variable_frontend) == 'oui'
        assert _get_value(config, variable_ip) == [u'0.0.0.0']
        assert _get_value(config, variable_netmask) == [u'0.0.0.0']

def test_upgrade_seth():
    """
    Valide les modifications apportées dans le dico AD
    - remplissage de la variable oui/non : ad_force_domain_sid (#21295)
    - remplissage de la variable oui/non : ad_filter_network (#21324)
    - fusion des autorisations de pare-feu (#21324)
    """
    if isfile('/usr/share/eole/creole/dicos/25_smb_ad.xml'):
        config = creole_loader(force_configeol=_calc_config_file('seth261'))
        assert _get_value(config, 'ad_force_domain_sid') == 'oui'
        assert _get_value(config, 'ad_filter_network') == 'oui'
        # FIXME: doublons ?
        assert _get_value(config, 'ad_peer_ip') == [u'1.1.1.1', u'2.2.2.2', u'1.1.1.1', u'3.3.3.0']
        assert _get_value(config, 'ad_peer_netmask') == [u'255.255.255.255', u'255.255.255.255', u'255.255.255.255', u'255.255.255.0']

def test_upgrade_squid():
    """
    Valide la transformation des variables Squid passées de minutes en secondes
    * connect_timeout is not customised (60s is the new default value)
    * peer_connect_timeout was already in seconds
    """
    if isfile('/usr/share/eole/creole/dicos/23_proxy.xml'):
        config = creole_loader(force_configeol=_calc_config_file('squid261'))
        for squidvar in ['forward_timeout', 'connect_timeout', 'peer_connect_timeout', 'read_timeout', 'request_timeout', 'persistent_request_timeout']:
            assert _get_value(config, squidvar) == 60

def test_upgrade_exim_relay():
    """
    Valide le remplissage des variables exim_relay et exim_relay_dhcp :
    - Sur Scribe remplissage à 'oui'
    - Sur les autres modules, on garde la valeur par défaut ('non')
    """
    config = creole_loader(force_configeol=_calc_config_file('exim_relay_261'))
    if isfile('/usr/share/eole/creole/dicos/30_scribe.xml'):
        assert _get_value(config, 'exim_relay') == 'oui'
        assert _get_value(config, 'exim_relay_dhcp') == 'oui'
    elif isfile('/usr/share/eole/creole/dicos/30_seshat.xml'):
        assert _get_value(config, 'exim_relay') == 'oui'
    else:
        assert _get_value(config, 'exim_relay') == 'non'


def test_upgrade_cert_empty():
    config = creole_loader(force_configeol=_calc_config_file('certempty_261'))
    assert _get_value(config, 'cert_type') == u'autosigné'
    assert _is_default(config, 'server_cert')
    assert _get_value(config, 'server_cert') == '/etc/ssl/certs/eole.crt'
    assert _is_default(config, 'server_key')
    assert _get_value(config, 'server_key') == '/etc/ssl/private/eole.key'
    assert _is_default(config, 'server_pem')
    assert _get_value(config, 'server_pem') == '/etc/ssl/certs/eole.pem'


def test_upgrade_cert():
    config = creole_loader(force_configeol=_calc_config_file('cert_261'))
    assert _get_value(config, 'cert_type') == 'manuel'
    assert not _is_default(config, 'server_cert')
    assert _get_value(config, 'server_cert') == '/etc/ssl/certs/eole.crt'
    assert _is_default(config, 'server_key')
    assert _get_value(config, 'server_key') == '/etc/ssl/private/eole.key'
    assert not _is_default(config, 'server_pem')
    assert _get_value(config, 'server_pem') == '/etc/ssl/certs/eole.pem'


#####################################
# tests spécifiques à EOLE >= 2.7.0 #
#####################################

def test_upgrade_route_in_vpn():
    """
    Valide le remplissage de la nouvelle variable route_in_vpn en 2.7.0 (#23164)
    """
    if isfile('/usr/share/eole/creole/dicos/20_vpn.xml'):
        config = creole_loader(force_configeol=_calc_config_file('route_in_vpn_262'))
        assert _get_value(config, 'route_in_vpn') == [u'oui', u'oui', u'non']

def test_upgrade_ssl_subjectaltname():
    """
    Vérifie la suppression des adresses IP dans les noms alternatifs (#25009)
    """
    config = creole_loader(force_configeol=_calc_config_file('sslsubjectaltname_262'))
    assert _get_value(config, 'ssl_subjectaltname') == [u'amon.ac-test.fr']

def test_upgrade_vlan_id():
    """
    Vérifie que les id de VLAN sont transformés en entiers (#25084)
    et que les valeurs des variables esclaves associées sont bien migrées
    """
    config = creole_loader(force_configeol=_calc_config_file('vlan262'))
    assert _get_value(config, 'vlan_id_eth0') == [1, 2]
    assert _get_value(config, 'vlan_ip_eth0') == ["10.1.1.1", "10.1.2.1"]
    if not isfile(join(DICO_DIR, '28_openvswitch.xml')):
        assert _get_value(config, 'vlan_id_eth1') == [11, 12]
        assert _get_value(config, 'vlan_ip_eth1') == ["10.1.11.1", "10.1.12.1"]
        if not isfile(join(DICO_DIR, '30_sphynx.xml')):
            assert _get_value(config, 'vlan_id_eth2') == [21, 22]
            assert _get_value(config, 'vlan_ip_eth2') == ["10.1.21.1", "10.1.22.1"]
            # esclave avec mélange de valeurs personnalisées et de valeurs par défaut
            assert _get_value(config, 'vlan_netmask_eth2') == ['255.255.255.0', '255.255.0.0']


#####################################
# tests spécifiques à EOLE >= 2.7.2 #
#####################################

def test_upgrade_nut_foreign():
    """
    Vérifie la transformation des variables mono en multi (#14296)
    """
    config = creole_loader(force_configeol=_calc_config_file('onduleur271'))
    assert _get_value(config, 'nut_monitor_foreign_name') == [u'eoleups']
    assert _get_value(config, 'nut_monitor_foreign_host') == [u'1.1.1.1']
    assert _get_value(config, 'nut_monitor_foreign_user') == [u'eoleups']
    assert _get_value(config, 'nut_monitor_foreign_password') == [u'password']

def test_upgrade_eolesso_cas_folder():
    """
    Vérifie la modification ou non de eolesso_cas_folder (#29814)
    """
    if isfile(join(DICO_DIR, '21_sso.xml')):
        config = creole_loader(force_configeol=_calc_config_file('ssoracine271'))
        assert _get_value(config, 'eolesso_cas_folder') is None
        config = creole_loader(force_configeol=_calc_config_file('ssoperso271'))
        assert _get_value(config, 'eolesso_cas_folder') == '/auth'

def test_upgrade_ad_local():
    """
    Vérifie l'initialisation de la variable ad_local (#31237)
    """
    if isfile(join(DICO_DIR, '25_eolead_container.xml')):
        config = creole_loader(force_configeol=_calc_config_file('scribeNT'))
        assert _get_value(config, 'ad_local') == 'oui'
        config = creole_loader(force_configeol=_calc_config_file('scribeAD'))
        assert _get_value(config, 'ad_local') == 'oui'
        config = creole_loader(force_configeol=_calc_config_file('eoleAD'))
        assert _get_value(config, 'ad_local') == 'non'
