#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""AAF parsing entry point
"""
import time, sys
from os.path import join
from glob import glob
from eoleaaf import aaf

from eoleaaf.config import path_aaf_complet
from eoleaaf.ihm import print_time
from eoleaaf.miscutil import parse_xml_files
from eoleaaf.util import db

times = [time.time()]

def main(xml_path, reset_db):
    """parsing main entry point
    the parsing type depends on the name of the xml file
    """
    # REM: parsing order is very important for database integrity validation
    aaftypes = [
    ("_EtabEducNat_", "parse_aaf_etab_educnat"),
    ("_Eleve_", "parse_aaf_eleves"),
    ("_PersRelEleve_", "parse_aaf_responsables"),
    ("_PersEducNat_", "parse_aaf_profs"),
    ]

    xml_files = glob(join(xml_path, "*.xml"))
    xml_files.sort()

    # parsing etab
    if reset_db:
        aaf.reset_db()
    else:
        aaf.maj_mode = True
    parse_xml_files(aaftypes[0], xml_files, aaf)
    print_time('établissement', times)
    # parsing eleves
    parse_xml_files(aaftypes[1], xml_files, aaf)
    print_time('élèves', times)
    # écriture des classes
    aaf.flush_classes_buffer()
    print_time('classes', times)
    # écriture des groupes
    aaf.flush_groupes_buffer()
    print_time('groupes', times)
    # parsing responsables
    parse_xml_files(aaftypes[2], xml_files, aaf)
    print_time('responsables', times)
    # parsing personnels
    parse_xml_files(aaftypes[3], xml_files, aaf)
    print_time('personnels', times)
    db.close()

if __name__ == '__main__':
    try:
        if sys.argv[1] == 'all':
            reset_db = True
    except:
        reset_db = False
    main(path_aaf_complet, reset_db)
