#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""AAF parsing entry point
"""
import time
from os.path import join
from glob import glob
from eoleaaf import delta
from eoleaaf.config import path_aaf_delta
from eoleaaf.ihm import print_time
from eoleaaf.miscutil import parse_xml_files
from eoleaaf.util import db

times = [time.time()]


def main(xml_path):
    """parsing main entry point
    the parsing type depends on the name of the xml file
    """
    # REM: parsing order is very important for database integrity validation
    aaftypes = [("_EtabEducNat_", "parse_delta_etab_educnat"),
                ("_PersRelEleve_", "parse_delta_responsables"),
                ("_PersEducNat_", "parse_delta_profs"),
                ("_Eleve_", "parse_delta_eleves"),
                ]

    xml_files = glob(join(xml_path, "*.xml"))
    xml_files.sort()

    # parsing etab
    parse_xml_files(aaftypes[0], xml_files, delta)
    print_time('établissement', times)
    # parsing responsables
    parse_xml_files(aaftypes[1], xml_files, delta)
    print_time('responsables', times)
    # parsing eleves
    parse_xml_files(aaftypes[2], xml_files, delta)
    print_time('élèves', times)
    # parsing personnels
    parse_xml_files(aaftypes[3], xml_files, delta)
    print_time('personnels', times)
    db.close()


if __name__ == '__main__':
    main(path_aaf_delta)
