# -*- coding: utf8 -*-
"""common attributes for the ldif generation
"""

# Attributes for ENTPerson objectClass
# and upper objectClasses (Person, organizationalPerson, inetOrgPerson)

ENTPerson_must = """
cn
sn
userPassword
displayName
givenName
uid
ENTPersonLogin
ENTPersonJointure
"""

ENTPerson_may = """
telephoneNumber
title
facsimileTelephoneNumber
homePhone
jpegPhoto
mail
Mobile
roomNumber
personalTitle
ENTPersonAutresPrenoms
ENTPersonNomPatro
ENTPersonSexe
ENTPersonCentresInteret
ENTPersonAdresse
ENTPersonCodePostal
ENTPersonVille
ENTPersonPays
ENTPersonAlias
ENTPersonStructRattach
ENTPersonFonctions
ENTPersonDateNaissance
ENTPersonAutresMails
ENTPersonAutresMobiles
ENTPersonProfils
"""

# Attributes for ENTEleve objectClass

ENTEleve_must = """ENTEleveStatutEleve
ENTEleveMEF
ENTEleveLibelleMEF
ENTEleveNivFormation
ENTEleveFiliere
ENTEleveClasses
ENTEleveMajeur
ENTEleveStructRattachId
"""

ENTEleve_may = """ENTEleveParents
ENTEleveAutoriteParentale
ENTElevePersRelEleve1
ENTEleveQualitePersRelEleve1
ENTElevePersRelEleve2
ENTEleveQualitePersRelEleve2
ENTElevePersRelEleve
ENTEleveBoursier
ENTEleveRegime
ENTEleveTransport
ENTEleveNivFormationDiplome
ENTEleveSpecialite
ENTEleveEnseignements
ENTEleveCodeEnseignements
ENTEleveGroupes
ENTEleveEnsRespStage
ENTEleveEnsTutStage
ENTEleveEntrTutStage
ENTEleveEntrAutres
ENTEleveDelegClasse
ENTEleveDelegAutres
ENTEleveMajeurAnticipe
"""


# Attributes for ENTAuxPersRelEleve objectClass

ENTAuxPersRelEleve_must = "ENTAuxPersRelEleveEleve"

ENTAuxPersRelEleve_may = "ENTAuxPersRelEleveRepresentant"


# Attributes for ENTAuxEnseignant objectClass

ENTAuxEnseignant_must = ""

ENTAuxEnseignant_may = """
ENTAuxEnsCategoDiscipline
ENTAuxsEnsMEF
ENTAuxEnsMatiereEnseignEtab
ENTAuxEnsClasses
ENTAuxEnsGroupes
ENTAuxEnsClassesMatiere
ENTAuxEnsGroupesMatiere
ENTAuxEnsClassePrincipal
ENTAuxEnsRespStage
ENTAuxEnsTutStage
"""


# Attributes for ENTAuxNonEnsServAc objectClass

ENTAuxNonEnsServAc_must = ""

ENTAuxNonEnsServAc_may = """
ENTAuxNonEnsServAcService
ENTAuxNonEnsServAcDomaineEtab
ENTAuxNonEnsServAcDomaineRegroupEtabs
"""

# Attributes for ENTAuxNonEnsEtab objectClass

ENTAuxNonEnsEtab_must = ""

ENTAuxNonEnsEtab_may = """
ENTAuxNonEnsEtabService
"""

##
## Classe ENTAuxNonEnsCollLoc
## La classe ENTAuxNonEnsCollLoc est une classe auxiliaire permettant de
## compléter la classe ENTPerson avec les attributs relatifs à la catégorie
## de personnes Non enseignants rattachés administrativement à une collectivité locale.
##
#
#objectclass (  1.2.250.1.173.1.1.1.2.6
#  NAME 'ENTAuxNonEnsCollLoc'
#  DESC 'Complète la classe ENTPerson pour les personnes non enseignantes rattachées administrativement à une collectivité locale'
#  SUP top AUXILIARY
#  MAY  ( ENTAuxNonEnsCollLocService
#	 ENTAuxNonEnsCollLocDomaineEtab
#	 ENTAuxNonEnsCollLocDomaineRegroupEtabs
#  ) )
#

## classe ENTAuxPersExt
## La classe ENTAuxPersExt est une classe auxiliaire permettant
## de compléter la classe ENTPerson avec les attributs relatifs à
## la catégorie de personnes Personnels extérieurs.
#
#objectclass (  1.2.250.1.173.1.1.1.2.8
#  NAME 'ENTAuxPersExt'
#  DESC 'Complète la classe ENTPerson pour les personnes personnels extérieurs'
#  SUP top AUXILIARY
#  MAY  ENTAuxPersExtService
#  )
#
## classe ENTAuxTuteurStage
## La classe ENTAuxTuteurStage est une classe auxiliaire permettant
## de compléter la classe ENTPerson avec les attributs relatifs à
## la catégorie de personnes Tuteurs de stage et maîtres d’apprentissage.
#
#objectclass (  1.2.250.1.173.1.1.1.2.9
#  NAME 'ENTAuxTuteurStage'
#  DESC 'Complète la classe ENTPerson pour les personnes tuteurs de stage et maîtres d apprentissage'
#  SUP top AUXILIARY
#  MUST ( ENTAuxTuteurStageSociete
#	 ENTAuxTuteurStageEleves
#  ) )
#
## classe ENTAuxRespEntrp
## La classe ENTAuxRespEntrp est une classe auxiliaire permettant
## de compléter la classe ENTPerson avec les attributs relatifs à
## la catégorie de personnes Responsables des entreprises partenaires.
#
#objectclass (  1.2.250.1.173.1.1.1.2.10
#  NAME 'ENTAuxRespEntrp'
#  DESC 'Complète la classe ENTPerson pour les personnes responsables des entreprises partenaires'
#  SUP top AUXILIARY
#  MUST ENTAuxRespEntrpSociete
#  )
#
## classe ENTPersonRelation
## La classe ENTPersonRelation est une classe auxiliaire permettant
## de compléter la classe ENTPerson avec les attributs relatifs à
## la définition des opérations de réconciliation entre comptes utilisateurs.
#
#objectclass (  1.2.250.1.173.1.1.1.2.11
#  NAME 'ENTPersonRelation'
#  DESC 'Complète la classe ENTPerson pour les opérations de réconciliation entre comptes utilisateurs'
#  SUP top AUXILIARY
#  MAY  ( ENTPersonRelRapprochPrincipal
#	 ENTPersonRelRapprochSecondaire
#	 ENTPersonRelFusionPrincipal
#	 ENTPersonRelFusionSecondaire
#  ) )
#
## -----------------------------------------------------------------------------
##
## Structures
#


# Attributes for ENTStructure objectClass
# and upper objectClasses (organizationalUnit)

ENTStructure_must = """
ou
ENTStructureJointure
ENTStructureNomCourant
ENTStructureSIREN
"""

ENTStructure_may = """
l
telephoneNumber
postalCode
street
facsimileTelephoneNumber
postOfficeBox
ENTStructureTypeStruct
ENTStructureResponsable
ENTStructureEmail
ENTStructureSiteWeb
ENTStructureContactENT
ENTStructureUAI
"""

# Attributes for ENTEtablissement objectClass

ENTEtablissement_must = """
ENTEtablissementMinistereTutelle
ENTEtablissementContrat
"""

ENTEtablissement_may = """
ENTEtablissementStructRattachAdmin
ENTEtablissementStructRattachFctl
ENTEtablissementBassin
ENTStructureClasses
ENTStructureGroupes
"""

# Attributes for ENTServAc objectClass

ENTServAc_must = """
ENTServAcAcademie
"""

ENTServAc_may = ""

##
##
## Classe ENTCollLoc
## La classe ENTCollLoc complète la classe ENTStructure avec les attributs relatifs
## à la catégorie de structures Collectivité locale
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.25
#  NAME 'ENTCollLoc'
#  DESC 'Structure Services Académiques'
#  SUP  ENTStructure
#  MUST ( ENTCollLocLieuGeographique
#       )
#  )
#
##
##
## Classe ENTEntreprise
## La classe ENTEntrp complète la classe ENTStructure avec les attributs relatifs
## à la catégorie de structures Entreprises partenaires
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.26
#  NAME 'ENTEntreprise'
#  DESC 'Entreprises partenaires'
#  SUP  ENTStructure
#  MUST ( ENTEntrepriseEtabs
#       )
#  )
#
## -----------------------------------------------------------------------------
#
##
## Groupes
##
##
##
## Classe ENTClasse
## La classe ENTClasse hérite de la classe groupOfNames
## et ajoute les attributs relatifs aux classes des élèves
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.41
#  NAME 'ENTClasse'
#  DESC 'Classes d élèves'
#  SUP  groupOfNames
#  )
#

# Attributes for groupOfNames objectClass

groupOfNames_must = """
cn
member
"""

groupOfNames_may = """
owner
description
"""


# Attributes for ENTClasse objectClass
# and upper objectClasses (groupOfNames)

ENTClasse_must = groupOfNames_must

ENTClasse_may = groupOfNames_may

##
##
## Classe ENTGroupe
## La classe ENTGroupe hérite de la classe groupOfNames
## et ajoute les attributs relatifs aux groupes d'élèves
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.42
#  NAME 'ENTGroupe'
#  DESC 'Groupe d élèves'
#  SUP  groupOfNames
#  )
#

# Attributes for ENTGroupe objectClass
# and upper objectClasses (groupOfNames)

ENTGroupe_must = groupOfNames_must

ENTGroupe_may = groupOfNames_may

##
##
## Classe ENTGroupementEtabs
## La classe ENTGroupementEtabs hérite de la classe groupOfNames
## et ajoute les attributs relatifs aux groupements d'établissements
## (bassins de formation, cités scolaires, GRETA)
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.43
#  NAME 'ENTGroupementEtabs'
#  DESC 'Groupement d établissements'
#  SUP  groupOfNames
#  )
#
##
##
## Classe ENTProfil
## La classe ENTProfil  hérite de la classe groupOfNames
## et ajoute les attributs relatifs aux profils décrits
## dans le modèle de sécurité de l'annuaire ENT
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.44
#  NAME 'ENTProfil'
#  DESC 'Profils'
#  SUP  groupOfNames
#  MAY ( ENTProfilPeuplement
#       )
#  )
#
#
##
##
## Classe ENTRoleAppli
## La classe ENTRoleAppli hérite de la classe groupOfNames
## et ajoute les attributs relatifs aux rôles applicatifs
## décrits dans le modèle de sécurité de l'annuaire ENT
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.45
#  NAME 'ENTRoleAppli'
#  DESC 'Rôles Applicatifs'
#  SUP  groupOfNames
#  MAY ( ENTRoleAppliProfils
#       )
#  )
#
##
##
## Classe ENTRelEleve
## La classe ENTRelEleve  hérite de la classe groupOfNames
## et ajoute les attributs relatifs à une relation entre
## un Élève et une Personne en relation avec l'élève
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.46
#  NAME 'ENTRelEleve'
#  DESC 'Relation à l élève'
#  SUP  groupOfNames
#  )
#
## -----------------------------------------------------------------------------
#
##
## Applications
##
##
##
## Classe ENTApplication
## La classe ENTApplication hérite directement de la classe top
## et décrit les applications qui utilisent l'annuaire ENT.
## Ces applications peuvent reposer ou non sur le socle ENT
##
##
#objectclass (  1.2.250.1.173.1.1.1.2.60
#  NAME 'ENTApplication'
#  DESC 'Application'
#  SUP  top
#  MUST ( ENTApplicationId
#	 userPassword
#	 ENTApplicationNom
#	 ENTApplicationCatego
#       )
#  MAY  ( ENTApplicationDesc
#	 ENTAppliProprietaire
#	 ENTApplicationProfils
#	 ENTApplicationRolesAppli
#  ) )
