# -*- coding:utf-8 -*-
import sys
from configobj import ConfigObj

#loglevel = 'DEBUG'
loglevel = 'INFO'
conffile = "/etc/aaf.conf"
try:
    config = ConfigObj(conffile)
except Exception, e:
    print "ERROR: --- unable to load configuration file : {0} ---".format(conffile)
    sys.exit(1)

# XML paths
path_aaf_complet = config.get('path_aaf_complet', "/home/aaf-complet")
path_aaf_delta = config.get('path_aaf_delta', "/home/aaf-delta")
# LDIF paths
template_path = "/var/lib/eole/aaf"
ldif_path = config.get('ldif_path', '/home')

# name of the autoritary source
autoritary_source = config.get('autoritary_source', 'AC-ACAD')
# letter of the ENT project code
ent_letter = config.get('ent_letter', 'A')
# number of the ENT project code
ent_number = config.get('ent_number', '1')

# SQL configuration
dbname = config.get('dbname', 'eoleaaf')
dbuser = config.get('dbuser', 'eoleaaf')
dbpasswd = config.get('dbpasswd', 'eoleaaf')

# ldap configuration
basedn = config.get('basedn', 'o=gouv,c=fr')
rootdn = config.get('rootdn', "cn=admin,o=gouv,c=fr")
rootdnpasswd = config.get('rootdnpasswd', 'rootpwd')
usersdn = "ou=personnes,{0}".format(basedn)
structsdn = "ou=structures,{0}".format(basedn)
groupsdn = "ou=groupes,{0}".format(basedn)
appsdn = "ou=applications,{0}".format(basedn)

# ldap delta filenames
ldap_delta_create_filename = "delta_create.ldif"
ldap_delta_update_filename = "delta_update.ldif"
ldap_delta_delete_filename = "delta_delete.ldif"

# multi-values separator
multisep = "\n"

# types de structures à ventiler dans la catégorie "ENTServAc"
entservac_structures = ('RECTORAT',
                        'VICE RECTORAT TOM',
                        'DIRECTION SERVICES DEPARTEMENTAUX EN',
                        'SERVICE DE LA DSDEN')

