# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
import time
from random import SystemRandom
from config import dbtype, dbfilename

class DatabaseError(Exception):
    pass

if dbtype == "mysql":
    try:
        import MySQLdb
        import MySQLdb.cursors
    except:
        raise DatabaseError('cannot load the MySQL python bindings')
elif dbtype == "sqlite":
    try:
        import sqlite3
    except:
        raise DatabaseError('cannot load the SQLite3 python bindings')
elif dbtype == "mongodb":
    try:
        from pymongo import MongoClient, ASCENDING
    except:
        raise DatabaseError('cannot load the MongDB python bindings')
else:
    print("no database binding specified, switching to the sqlite bindings")
    try:
        import sqlite3
    except:
        raise DatabaseError('cannot load the SQLite3 python bindings')

from pyeole.log import init_logging
from pyeole.encode import normalize, remove_accents
from eoleaaf.config import loglevel, ent_letter, ent_number, multisep
# FIXME: utilisé dans des imports ?
from eoleaaf.config import dbname, dbuser, dbpasswd
from eoleaaf.config import aaf_exceptions_report_filename

random = SystemRandom()

# logging report utility
log = init_logging(level=loglevel)
# ____________________________________________________________


def log_error(tablename, modif_type, datestr, db, id_, msg):
    log.error(msg)
    update_journal(tablename, modif_type, datestr, db, id_, 'error')




# ____________________________________________________________
class SimpleConnectionWrapper:
    "mysqldb dbapi connector"
    db = dbname
    user = dbuser
    passwd = dbpasswd

    def connect(self, default_cursor=True):
        # wraps the original connection object
        if default_cursor:
            raise Exception("Default database cursor not implemented")

        if dbtype == 'mysql':
            self.conn = MySQLdb.connect(host="localhost", port=3306,
                                  user=self.user,
                                  passwd=self.passwd, db=self.db,
                                  cursorclass=MySQLdb.cursors.SSDictCursor)
            self.conn.autocommit(False)
        else:
            if dbtype == 'mysql':
                # eole-mysql's responsibility
                pass
            elif dbtype == 'sqlite':
                import sqlite3
                conn = sqlite3.connect(dbfilename)
                tables = conn.execute("SELECT name FROM sqlite_master WHERE type='table';")
                if len(list(tables)) == 0:
                    from os import system
                    system("/usr/bin/sqlite3 {} < /usr/share/eole/mysql/eole-aaf/gen/eoleaaf.sql".format(dbfilename))
                self.conn = sqlite3.connect(dbfilename)
                self.conn.row_factory = sqlite3.Row
            else:
                raise DatabaseError("unknown database type : {}".format(dbtype))

        self.cursor = self.conn.cursor()

    def execute(self, sql, values=None):
        try:
            if values is None:
                self.cursor.execute(sql)
            else:
                self.cursor.execute(sql, values)
        except Exception, e:
            raise DatabaseError("SQL error, " + str(e))

    def _row_to_dict(self, ret):
        newlist = []
        for row in ret:
            newdict = {}
            keys = row.keys()
            for idx, value in enumerate(row):
                newdict[keys[idx]] = value
            newlist.append(newdict)
        return newlist

    def fetchone(self, sql):
        "retrieves the first entry of a query"
        ### hack, fetchone disconnect from database
        if sql.endswith(';'):
            sql = sql[:-1]
        self.cursor.execute(sql + ' LIMIT 1;')
        ret = self.cursor.fetchall()
        if not isinstance(ret, tuple):
            ret = self._row_to_dict(ret)
        else:
            ret = list(ret)
        if ret == []:
            return ret
        return ret[0]

    def fetchall(self, tablename, condition=""):
        "retrieves all entries from the table: tablename"
        sql = "SELECT * FROM " + tablename + " " + condition
        self.cursor.execute(sql)
        ret = self.cursor.fetchall()
        if not isinstance(ret, tuple):
            ret = self._row_to_dict(ret)
        return ret

    def count(self, tablename, condition=""):
        "counts all entries from the table: tablename"
        sql = "SELECT COUNT(*) FROM " + tablename + " " + condition
        self.cursor.execute(sql)
        ret = self.cursor.fetchall()
        if dbtype == 'mysql':
            return ret[0]["COUNT(*)"]
        else:
            return ret[0][0]

    def fetchtable(self, tablename):
        """
        retrieves all entries from the table: tablename
        the same as fetchall without condition
        """
        return self.fetchall(tablename)

    def fetchtable_updated(self, tablename):
        """
        retrieves all entries from the table: tablename
        matching the condition FieldActionType = 'UPDATE'
        """
        return self.fetchall(tablename, "WHERE FieldActionType = 'UPDATE'")

    def close(self):
        self.cursor.close()
        self.conn.close()

    def commit(self, tablename):
        try:
            self.conn.commit()
        except Exception, e:
            log.error("Erreur au commit database")
            self.conn.rollback()
            raise DatabaseError("MySQL error, " + str(e))

    def reset(self):
        if dbtype == 'mysql':
            self.execute("SHOW TABLES")
            for tablename in self.cursor.fetchall():
                self.execute('TRUNCATE {0}'.format(tablename['Tables_in_eoleaaf']))
        else:
            self.execute("SELECT name FROM sqlite_master WHERE type='table';")
            for tablename in self.cursor.fetchall():
                self.execute('DELETE FROM {0}'.format(tablename[0]))
        self.commit(None)

class SimpleMongoConnectionWrapper(object):
    def __init__(self):
        self._datas = []

    def connect(self):
        # FIXME: gérer l'authentification !!!!
        self.client = MongoClient('mongodb://localhost:27017')
        self.db = self.client[dbname]
        self.collection_user = self.db.user
        if "ENTEleveGroupes" not in self.collection_user.index_information():
            self.collection_user.create_index('ENTEleveGroupes')

        if "ENTPersonLogin" not in self.collection_user.index_information():
            self.collection_user.create_index('ENTPersonLogin', unique=True)

        if "ENTPersonJointure" not in self.collection_user.index_information():
            self.collection_user.create_index('ENTPersonJointure', unique=True)

        if "UserType" not in self.collection_user.index_information():
            self.collection_user.create_index('UserType')

        if "uid" not in self.collection_user.index_information():
            self.collection_user.create_index('uid')

        if "ENTStructureJointure" not in self.db.etablissement.index_information():
            self.db.etablissement.create_index('ENTStructureJointure')

    def reset(self):
        #self.client.drop_database(dbname)
        self.collection_user.remove()
        self.db.etablissement.remove()
        self.db.subject.remove()
        self._datas = []

    def commit(self, tablename):
        if tablename is not None:
            #for data in self._datas:
            #    print data['ENTStructureJointure']
            #    self.db[tablename].insert(data)
            self.db[tablename].insert_many(self._datas)
        self._datas = []

    def close(self):
        self._datas = []
        self.client.close()

    def execute(self, data, values=None):
        self._datas.append(data)

    def fetchone(self, tablename, attr, value):
        return self.db[tablename].find_one({attr: value})

    def fetchall(self, tablename, attr=None, value=None):
        if attr is None:
            return self.db[tablename].find()
        else:
            return self.db[tablename].find({attr: value})


# ____________________________________________________________
# global (and unique) database connection
if not dbtype == "mongodb":
    db = SimpleConnectionWrapper()
    db.connect(default_cursor=False)
else:
    db = SimpleMongoConnectionWrapper()
    db.connect()
# ____________________________________________________________

def replace_cars(chaine, chars):
    """
    fonction qui exécute le remplacement des caractères spéciaux
    """
    if chaine is None:
        return ''
    if type(chaine) == unicode:
        chaine = chaine.encode('UTF-8')
    for old, new in chars.items():
        chaine = chaine.replace(old, new)
    return chaine

def replace_cars2(chaine):
    """
    fonction de suppression des caractères spéciaux les plus courants
    """
    if chaine is None:
        return ''
    if type(chaine) == unicode:
        chaine = chaine.encode('UTF-8')
    chars = {'¥' : 'Y', 'µ' : 'u', 'À' : 'A', 'Á' : 'A',
             'Â' : 'A', 'Ã' : 'A', 'Ä' : 'A', 'Å' : 'A',
             'Æ' : 'A', 'Ç' : 'C', 'È' : 'E', 'É' : 'E',
             'Ê' : 'E', 'Ë' : 'E', 'Ì' : 'I', 'Í' : 'I',
             'Î' : 'I', 'Ï' : 'I', 'Ð' : 'D', 'Ñ' : 'N',
             'Ò' : 'O', 'Ó' : 'O', 'Ô' : 'O', 'Õ' : 'O',
             'Ö' : 'O', 'Ø' : 'O', 'Ù' : 'U', 'Ú' : 'U',
             'Û' : 'U', 'Ü' : 'U', 'Ý' : 'Y', 'ß' : 's',
             'à' : 'a', 'á' : 'a', 'â' : 'a', 'ã' : 'a',
             'ä' : 'a', 'å' : 'a', 'æ' : 'a', 'ç' : 'c',
             'è' : 'e', 'é' : 'e', 'ê' : 'e', 'ë' : 'e',
             'ì' : 'i', 'í' : 'i', 'î' : 'i', 'ï' : 'i',
             'ð' : 'o', 'ñ' : 'n', 'ò' : 'o', 'ó' : 'o',
             'ô' : 'o', 'õ' : 'o', 'ö' : 'o', 'ø' : 'o',
             'ù' : 'u', 'ú' : 'u', 'û' : 'u', 'ü' : 'u',
             'ý' : 'y', 'ÿ' : 'y', '~B': 'e', '°' : '.', 'A©' : 'e',
             'Š' : '', 'þ': 'e', '²': '',
#             '&#176;': '', '&#194;':'', '&#352;':'', '&#233;':'e',
#             '&#226;': 'a', '&#233;': 'e', '&#232;': 'e',
#             '&0xc3;': '', '&#231;': 'c', '&apos;': " ", '&#254;': 'e',
#              '&amp;': '', '&#224;':'', '&#201;': 'E', '&quot;': '',
#              '&#226;': 'a', '&#235;': 'e', "'": "", 'A©':'e',
#              '&#195;': 'a', '&#139;': '',
            }
    for old, new in chars.items():
        chaine = chaine.replace(old, new)
    return chaine

def replace_dangerous_cars(chaine):
    """
    remplace uniquement les caractères dangereux pour
    les traitements numériques conformément
    aux préconisations du SDET 4.2
    """
    chars = {'(': '', ')': '',
            '&quot;': "'",
            '&lt;': '<', # Less than
            '&gt;': '>', # Greater than
            '&amp;': "&", # eperluette
            '&apos;': "'", # apostrophe
#             '&#176;': '', '&#194;':'', '&#352;':'', '&#233;':'e',
#             '&#226;': 'a', '&#233;': 'e', '&#232;': 'e',
#             '&0xc3;': '', '&#231;': 'c', '&apos;': " ", '&#254;': 'e',
#             '&amp;': '', '&#224;':'', '&#201;': 'E', '&quot;': '',
#             '&#226;': 'a', '&#235;': 'e', "'": "", 'A©':'e',
#             '&#195;': 'a', '&#139;': '',
            }
    return replace_cars(chaine, chars)

def replace_bad_cars(chaine):
    """
    remplace les caractères invalides
    """
    longchars = {
            '\xc3\x82\xc2\xb0':'O',
            '\xc3\x83\xc2\x82':'A',
            '\xc3\x83\xc2\x87':'C',
            '\xc3\x83\xc2\x88':'E',
            '\xc3\x83\xc2\x89':'E',
            '\xc3\x83\xc2\x8a':'E',
            '\xc3\x83\xc2\x8b':'A',
            '\xc3\x83\xc2\x91':'N',
            '\xc3\x83\xc2\x94':'O',
            }
    shortchars = {
            '\xc3\xa8' : 'E',
            '\xc3\xaf' : 'I',
            '\xc3\x82' : 'A',
            '\xc3\x83' : 'E',
            '\xc3\x87' : '?',
            '\xc3\x88' : 'E',
            '\xc3\x89' : 'E',
            '\xc3\x8b' : 'E', #was ê maj
            '\xc3\x8f' : 'A',
            # ---------------- #
            '\xc3\x8a' : 'e', #was è
            '\xc3\xa7' : 'c', #was ç
            '\xc3\xa9' : 'e', #was é
            '\xc3\xaa' : 'e', #was ê
            '\xc3\xab' : 'e', #was ë
            '\xc3\xbb' : 'u',
            }

#             '&#176;': '', '&#194;':'', '&#352;':'', '&#233;':'e',
#             '&#226;': 'a', '&#233;': 'e', '&#232;': 'e',
#             '&0xc3;': '', '&#231;': 'c', '&#254;': 'e',
#             '&#224;':'', '&#201;': 'E',
#             '&#226;': 'a', '&#235;': 'e',
#             '&#195;': 'a', '&#139;': '',
#             '\xc2\x88' : '',
#             '\xc2\x89' : '',
#             '\xc2\x8a' : 'I',
#             '\xc2\x8b' : '',
#             '\xc2\xb0': '',
#             '\xc3\x82' : 'O',
    return replace_cars(replace_cars(chaine, longchars), shortchars)

def clean_empty_keys(empty_keys_dict):
    "delete empty keys to prepare a clen sql insert"
    for key, value in empty_keys_dict.items():
        if value in ['', None]:
            del(empty_keys_dict[key])
    return empty_keys_dict
## ______________________________________________________________________
## Mongo Engine data base ORM
#
#class Group(Document):
#    description = StringField(required=True)
#
#class Student(Document):
#    id = StringField(primary_key=True, required=True)
#    uid = StringField()
#    userPassword = BinaryField()
#    ENTPersonLogin = StringField()
#    ENTEleveFiliere = StringField()
#    ENTEleveTransport = StringField()
#    ENTEleveEnseignements = StringField()
#    ENTEleveStructRattachId = StringField()
#    ENTEleveClasses = StringField()
#    ENTEleveMEF = StringField()
#    ENTPersonJointure = StringField()
#    ENTEleveNivFormation = StringField()
#    ENTEleveStatutEleve = StringField()
#    ENTEleveAutoriteParentale = StringField()
#    ENTElevePere = StringField()
#    ENTEleveQualitePersRelEleve2 = StringField()
#    ENTEleveQualitePersRelEleve1 = StringField()
#    ENTEleveMere = StringField()
#    ENTEleveGroupes = ListField(ReferenceField(Group))
#    ENTPersonDateNaissance = StringField()
#    ENTElevePersRelEleve2 = StringField()
#    ENTElevePersRelEleve1 = StringField()
#    ENTEleveParents = StringField()
#    ENTEleveBoursier = StringField()
#    ENTEleveLibelleMEF = StringField()
#    personalTitle = StringField()
#    ENTPersonNomPatro = StringField()
#    sn = StringField()
#    ENTPersonStructRattach = StringField()
#    ENTPersonAutresPrenoms = StringField()
#    givenName = StringField()
#    ENTEleveRegime = StringField()
#    ENTEleveCodeEnseignements = StringField()
#    ENTElevePersRelEleve = StringField()
#    FieldModifiedStatus = BooleanField()
#    FieldActionType = StringField()
#    FieldFromXMLImportActionDate = DateTimeField()
#    FieldToLDIFFExportActionDate = DateTimeField()


class MongoDBGenerator(object):

    def insert(self, insert, table, paramstyle=False):
        # typing the collection
        if table not in ['etablissement', 'subject']:
            insert['UserType'] = table
        return insert, None


class MinimalSQLGenerator:
    "minimal sql generation"
    def insert(self, insert, table, paramstyle=False):
        """
        sql insert statement

        :param insert: dictionnary of SQL inserts
        :param table: database table name

        insert({'nom': 'dupont', 'prenom':'marcel'}, 'responsable')
        INSERT into responsable (nom, prenom) VALUES ('dupont', 'marcel') ;
        ou bien
        INSERT into responsable (nom, prenom) VALUES (%s, %s) ;
        (si paramstyle == True)
        """
        clean_empty_keys(insert)
        sql_insert = ""
        begin_insert = "INSERT into %s (" % table
        insert_decls = begin_insert + ", ".join(insert.keys()) + ') '
        if paramstyle:
            values = insert.values()
            if dbtype == 'mysql':
                tmpl = '%s'
            else:
                tmpl = '?'
            insert_vals = [tmpl for val in values]
        else:
            insert_vals = ['"%s"' % val for val in insert.values()]
        commas = ', '.join(insert_vals)
        begin_vals = "VALUES ("
        sql_insert = insert_decls + begin_vals + commas + " ) ;"
        if paramstyle:
            return sql_insert, values
        else:
            return sql_insert

    def delete(self, id_name, id_value, table):
        """
        sql delete statement

        DELETE FROM table_name WHERE id=id_value;
        DELETE FROM eleve WHERE id='123456' ;

        :param table: database table name
        """
        return "DELETE FROM {0} WHERE {1} ;".format(table, self._where(id_name,
                                                        id_value))

    def update(self, update, primary_key, primary_value, table, paramstyle=False):
        """
        sql update statement

        :param update: dictionnary of update fields
        :param primary_key: field's identification name
        :param primary_value: primary key field's value
        :param table: database table name

        update({'nom': 'dupont', 'prenom':'marcel'}, 'id', '1164019', 'responsable')

        example::

           sqlgen.update({'toto':'titi', 'tutu':'tata'}, 'id', '123456',
           'eleve')

           'UPDATE eleve SET tutu=tata, toto=titi WHERE id=123456 ; '

            ou bien
           'UPDATE eleve SET tutu=%s, toto=%s WHERE id=123456 ; '
           (si paramstyle == True)
        """
        update = clean_empty_keys(update)
        sql_update = "UPDATE %s SET " % table
        if paramstyle:
            if dbtype == 'mysql':
                tmpl = '%s'
            else:
                tmpl = '?'
            values = update.values()
            where_clause = [self._where(key, tmpl, sep='') for key, value in update.items()]
        else:
            where_clause = [self._where(key, value, sep='"') for key, value in update.items()]
        setstatus = ", ".join(where_clause)
        sql_update += setstatus
        where = " WHERE " + self._where(primary_key, primary_value)
        sql_update += where + " ;"
        if paramstyle:
            return sql_update, values
        else:
            return sql_update

    def where(self, field, key, value) :
        """
        >>> sqlgen.where('uid', 'id', 'idresp')
        select uid where id=idresp
        """
        return "select {0} where {1} ;".format(field, self._where(key, value))

    def where_from(self, table, field, key, value):
        """use it is like a find, example:

            sqlgen.where_from('classe', 'ENTEleveClasses',
                             'ENTEleveClasses', '2668$6F')

        returns::

            select ENTEleveClasses where ENTEleveClasses=2668$6F from classe ;
            select id from eleve where id='1811362'
        """
        return "select {0} from {2} where {1} and `FieldActionType` != 'DELTADELETE_DONE';".format(field,
                                          self._where(key, value), table)

    def _where(self, key, value, sep="'") :
        # XXX concatener une serie de conditions sur les clefs
        return "{0}={2}{1}{2}".format(key, value, sep)

# ____________________________________________________________
def make_datetime():
    now = time.localtime(time.time())
    return time.strftime("%Y-%m-%d %H:%M:%S ", now)


def modif_fields(notify, sqlgen, modif_type="UPDATE",
                tablename="eleve", fromxml=True,
                db=None, id_column='id'):
    """
    adds entries like update/modified tag and datetime

    :notifiy: dict representing the field to be notified
    :modif_type: in ["UPDATE", "CREATE", "DELETE", "LDIFEXPORT"]
    :fromxml: True si la modif est une importation xml,
              False sinon (la modif est une exportation ldif)
    """
    notify['FieldModifiedStatus'] = 1
    notify['FieldActionType'] = modif_type
    datestr = make_datetime()
    if fromxml:
        notify['FieldFromXMLImportActionDate'] = datestr
    else:
        notify['FieldToLDIFFExportActionDate'] = datestr
    action_id = notify[id_column]
    paramstyle = False
    if modif_type in ('CREATE', 'DELTACREATE'):
        #FIXME à voir si on fait un update ou on modifie directement
        if fromxml:
            sql, values = sqlgen.insert(notify, tablename, paramstyle=True)
            paramstyle = True
        else:
            sql = sqlgen.update(notify, id_column, action_id, tablename)
    elif modif_type in ('UPDATE', 'LDIFEXPORT', 'DELTAUPDATE'):
        paramstyle = True
        sql, values = sqlgen.update(notify, id_column, action_id, tablename,
                                    paramstyle=True)
    elif modif_type == 'DELTADELETE':
        if fromxml:
            sql = sqlgen.update(notify, id_column, action_id, tablename)
        else:
            # suppression de l'entrée
            journal = dict()
            journal['ActionDate'] = datestr
            journal['ActionId'] = action_id
            journal['TableName'] = 'journal'
            journal['Level'] = 'info'
            journal['FieldActionType'] = modif_type
            journal['FieldDeletedContent'] = str(notify).replace('"', '')
            sql = sqlgen.insert(journal, 'journal')
            try:
                if paramstyle:
                    db.execute(sql, values)
                else:
                    db.execute(sql)
            except Exception, msg:
                log.info("Erreur au moment du storage du delete dans le journal : " + sql)
            sql = sqlgen.delete(id_column, action_id, tablename)
    else:
        # on est ici seulement pour modifier le champ "FieldActionType"
        # action de log pour mette un _DONE
        #XXX ne changer que le status FieldActionType UNIQUEMENT !!!!!!!!!!!
        paramstyle = True
        sql, values = sqlgen.update(notify, id_column, action_id, tablename,
                                    paramstyle=True)
    try:
        if paramstyle:
            db.execute(sql, values)
        else:
            db.execute(sql)
    except Exception, msg:
        if "Duplicate entry" in str(msg):
            log.info("Cette entrée est déjà présente dans la base de données au moment de {0} pour {1} avec ID {2}.".format(
                 modif_type, tablename, action_id.encode("utf-8")))
        else:
            log.warn("Erreur au moment de {0} pour {1} avec ID {2} : {3}".format(
                       modif_type, tablename, action_id.encode("utf-8"), str(msg)))
    update_journal(tablename, modif_type, datestr, db, action_id, 'info')

# ____________________________________________________________
def update_journal(tablename, modif_type, datestr, db, id_, level):
    """
    every action shall add en entry in the journalisation table,
    in order to trace the actions in case of a failure

    :tablename: the table where the modification has been made
    :actiontype: in ['CREATE', 'UPDATE', 'DELETE']
    """
    return
    notify = dict()
    notify['ActionDate'] = datestr
    notify['ActionId'] = id_
    notify['TableName'] = tablename
    notify['Level'] = level
    notify['FieldActionType'] = modif_type

    # ecriture dans la table journal
    sql = sqlgen.insert(notify, 'journal')
    db.execute(sql)

#____________________________________________________________
# random generators

def random_letter():
    "[A-Z]"
    return random.choice('abcdefghijklmnopqrstuvwxyz').upper()

def random_number():
    "[0-9]"
    return random.randint(0, 9)

def random_name(length=5):
    return "".join([random_letter() for i in range(length)])

def random_id(length=5):
    return "".join([str(random_number()) for i in range(length)])

def random_identifier(nblength=4, namelength=2):
    rndid = random_id(length=nblength)
    rndname = random_name(length=namelength)
    return rndname + "-" + rndid

#____________________________________________________________
# identifier shall be unique in the whole file
#ids_buffer = []
#def read_id_file(filename):
#    global ids_buffer
#    if not isfile(filename):
#        return
#    fh = open(filename, "r")
#    for line in fh.readlines():
#        strid = line.strip()
#        ids_buffer.append(strid)
#    fh.close()


#def write_id_file(filename, newid):
#    """
#    add the new id in id_file
#    """
#    global ids_buffer
#    fh = open(filename, 'a+')
#    fh.write(newid + '\n')
#    ids_buffer = []
#    fh.close()


#def make_unique_random_id():
#    global ids_buffer
#    read_id_file(filename)
#    rnd = random_identifier()
#    while rnd in ids_buffer:
#        rnd = random_identifier()
#    #ids_buffer.append(rnd)
#    write_id_file(filename, rnd)
#    return rnd.split("-")

def make_unique_random_id(rnd_buffer, sqlgen):
    """generates a unique id for the 'ENTPersons'
    it uses the primary key in the 'randomids' sql table
    while an id exists in the table, it is calculated again
    """
    rnd = random_identifier()
    rndfind = True
    idx = 0
    while rndfind:
        idx += 1
        try:
            if dbtype == "mongodb":
                if rnd in rnd_buffer or db.fetchone("user", "uid", rnd):
                    rnd = random_identifier()
                else:
                    rndfind = False
                    rnd_buffer.append(rnd)
            else:
                sql = sqlgen.insert({'id': rnd}, 'randomids')
                db.execute(sql)
                rndfind = False
        except DatabaseError:
            rnd = random_identifier()
        if idx == 10:
            raise Exception('cannot generate ID')

    return rnd.split("-")

#______________________________________________________________________________

def get_new_id(rnd_buffer, sqlgen):
    """
    Renvoie un identifiant unique
    de la forme "LxxCiiii" avec :
    o L et C : Lettre et chiffre du code projet ENT
    o xx et iiii : 2 lettres et 4 chiffres à générer pour chaque entrée
    """
    letters, numbers = make_unique_random_id(rnd_buffer, sqlgen)
    return "{0}{1}{2}{3}".format(ent_letter, letters, ent_number, numbers)

#______________________________________________________________________________

def gen_user_login(surname, givenname, uid, usertype, user_id, sqlgen, login_buffer):
    """
    génération du login
    le login est de type 'prenom.nomXX'
    """
    def gen_login_num(num):
        if result < 9:
            loginnum = "0" + str(num)
        else:
            loginnum = str(num)
        return loginnum

    givenname = normalize(givenname)
    surname = normalize(surname)
    # C'EST CONTRAIRE AU SDET - on cherche quand même a attribuer un login a l'utilisateur
    loginalpha = ""
    if surname is not None or surname != "":
        if (givenname is not None and givenname.strip() not in ['-', '_', '']
            and len(givenname + surname) <= 48):
            # Concatenation must be lower than 48 because we add 2 digits
            loginalpha = givenname.lower() + '.' + surname.lower()
        else:
            loginalpha = surname.lower()
        loginalpha = remove_accents(loginalpha).replace("'", "").replace(" ", "").replace("-", "").replace("_", "")

    if loginalpha == "":
        # C'EST CONTRAIRE AU SDET - on cherche quand même a attribuer un login a l'utilisateur
        # on lui attribut un login correspondant au user id au sens AAF (pas l'uid généré)
        loginalpha = user_id
        write_report = True
    else:
        write_report = False
    result = 0
    rndfind = True
    idx = 0
    while rndfind:
        try:
            idx += 1
            if idx == 101:
                raise Exception('cannot generate login')
            loginnum = gen_login_num(idx)
            login = loginalpha + loginnum
            if dbtype != "mongodb":
                sql = sqlgen.insert({'ENTPersonLoginAlpha': loginalpha,
                        'ENTPersonLoginNum': loginnum,
                        'DateCreation': make_datetime(),
                        'uid': uid,
                        'usertype': usertype}, 'personlogin')
                db.execute(sql)
            else:
                if login in login_buffer or db.fetchone("user", "ENTPersonLogin", login):
                    continue
                login_buffer.append(login)
            rndfind = False
        except DatabaseError:
            pass
        except Exception, msg:
            raise Exception('Impossible de créer le login pour {0} : {1}'.format(loginalpha, msg))
    if write_report:
        # on ecrit un rapport sur les cas exceptionnels dans un fichier texte
        fh = file(aaf_exceptions_report_filename, 'a+')
        fh.write("l'utilisateur avec l'id: {0} se voit affecter le login : {1}\n".format(user_id, login))
        fh.close()
    return login

def parse_multi(attr, update=False):
    """parse des balises XML qui sont possiblement multi
    (plusieurs balises VALUE)

    :param attr: noeud XML
    :param update: renvoie le contenu de l'attribut "operation" en supplément
    """
    balise = attr.attrib['name']
    vals = []
    for val in attr.findall('value'):
        val = replace_dangerous_cars(val.text)
        if not isinstance(val, unicode):
            val = val.decode('utf-8')
        vals.append(val)
    if dbtype == 'mongodb':
        if len(vals) == 1:
            vals = vals[0]
    else:
        vals = unicode(multisep.join(vals))
    if update:
        return balise, vals, attr.attrib['operation']
    else:
        return balise, vals

def pwgen():
    "convenient password generator"
    return random_name(8)
    #cmd = "pwgen -1 -c -n"
    #return commands.getoutput(cmd)
