# -*- coding:utf-8 -*-
import sys
from configobj import ConfigObj

class ConfigError(Exception):
    pass

#loglevel = 'DEBUG'
loglevel = 'INFO'
conffile = "/etc/aaf.conf"
try:
    config = ConfigObj(conffile)
except Exception, e:
    print "ERROR: --- unable to load configuration file : {0} ---".format(conffile)
    sys.exit(1)

# eole module name (shall be in ['openldap', 'samba4'])
aaf_type = config.get('aaf_type', 'openldap')

# XML paths
path_aaf_complet = config.get('path_aaf_complet', "/home/aaf-complet")
path_aaf_delta = config.get('path_aaf_delta', "/home/aaf-delta")
# LDIF paths
template_path = "/var/lib/eole/aaf"
ldif_path = config.get('ldif_path', '/home')

# reports filename
aaf_exceptions_report_filename = config.get('aaf_exceptions_report_filename', "/var/log/eole/aafexceptions.log")

# name of the autoritary source
autoritary_source = config.get('autoritary_source', 'AC-ACAD')
# letter of the ENT project code
ent_letter = config.get('ent_letter', 'A')
# number of the ENT project code
ent_number = config.get('ent_number', '1')

# SQL configuration
dbtype = config.get('dbtype', 'mysql') # 'mysql' by default on a THOT, 'sqlite' on a SETH
dbfilename = config.get('dbfilename', '/var/lib/sqlite/eoleaaf.sql')
dbname = config.get('dbname', 'eoleaaf')
dbuser = config.get('dbuser', 'eoleaaf')
dbpasswd = config.get('dbpasswd', 'eoleaaf')

# ldap configuration
basedn = config.get('basedn', 'o=gouv,c=fr')
rootdn = config.get('rootdn', "cn=admin,o=gouv,c=fr")
rootdnpasswd = config.get('rootdnpasswd', 'rootpwd')
if aaf_type == "openldap":
    usersdn = "ou=personnes,{0}".format(basedn)
elif aaf_type == "samba4":
    usersdn = "CN=Users,DC=ac-test,DC=fr"
else:
    raise ConfigError("wrong or unknown aaf_type configuration value: {}".format(aaf_type))
structsdn = "ou=structures,{0}".format(basedn)
groupsdn = "ou=groupes,{0}".format(basedn)
appsdn = "ou=applications,{0}".format(basedn)

# ldap delta filenames
ldap_delta_create_filename = "delta_create.ldif"
ldap_delta_update_filename = "delta_update.ldif"
ldap_delta_delete_filename = "delta_delete.ldif"

# multi-values separator
multisep = "\n"

# types de structures à ventiler dans la catégorie "ENTServAc"
entservac_structures = ('RECTORAT',
                        'VICE RECTORAT TOM',
                        'DIRECTION SERVICES DEPARTEMENTAUX EN',
                        'SERVICE DE LA DSDEN')

