# coding: utf-8
import datetime
import autopath
from os.path import join
import subprocess
from copy import copy
from bson.objectid import ObjectId

from eoleaaf.util import db
from eoleaaf.parseaaf import main


data = join(autopath.HERE, 'data')

responsable = {u"ENTPersonJointure": "994845",
               u"ENTPersonDateNaissance": '',
               u"ENTPersonNomPatro": "DELACOURT",
               u"sn": "DELACOURT",
               u"givenName": "Mathieu",
               u"personalTitle": "M",
               u"homePhone": "+33 0 00 11 22 33",
               u"telephoneNumber": '',
               u"ENTPersonAdresse": "2 ROUTE DE CHARTRES",
               u"ENTPersonCodePostal": "75000",
               u"ENTPersonVille": "PARIS",
               u"ENTPersonPays": "FRANCE",
#GENERATE
               u"ENTPersonLogin": "mathieu.delacourt01",
#ADDED
               u'FieldActionType': 'CREATE',
               u'FieldModifiedStatus': 1,
               u'UserType': "responsable",
}

eleve = {u"ENTPersonJointure": "14357",
         u"ENTEleveStructRattachId": "436201",
         u"ENTPersonDateNaissance": "28/11/1914",
         u"ENTPersonNomPatro": "DELACOURT",
         u"sn": "DELACOURT",
         u"ENTPersonLogin": "albertine.delacourt02",
         u'FieldActionType': 'CREATE',
         u'FieldModifiedStatus': 1,
         u'UserType': "eleve",
         u"givenName": "Albertine",
         u"ENTPersonAutresPrenoms": [u"Albertine", u"Pauline"],
         u"personalTitle": "Mme.",
#         u"ENTEleveParents": [u"994845", u"994846"],
#         u"ENTElevePere": "994845",
#         u"ENTEleveMere": "994846",
#         u"ENTEleveAutoriteParentale": [u"994845", u"994846"],
         u"ENTElevePersRelEleve1": '',
         u"ENTEleveQualitePersRelEleve1": '',
         u"ENTElevePersRelEleve2": '',
         u"ENTEleveQualitePersRelEleve2": '',
         #FIXME donnee brute utile a extraire ? => http://media.eduscol.education.fr/file/ENT/27/9/Documentation-solutionsENT-evolutionsAAF-SDETv4_238279.pdf
         u"ENTElevePersRelEleve": [u"994845$1$0$2$1$0", u"994846$2$1$1$1$0"],
         u"ENTEleveBoursier": "O",
         u"ENTEleveRegime": "EXTERNE LIBRE",
         u"ENTEleveTransport": "N",
         u"ENTEleveStatutEleve": "SCOLAIRE",
         u"ENTEleveMEF": "21220008110",
         u"ENTEleveLibelleMEF": "T-STL SC.PHYS.CHIM. EN LABORATOIRE",
         u"ENTEleveNivFormation": "TERMINALE GENERALE & TECHNO YC BT",
         u"ENTEleveFiliere": "TERMINALE TECHNOLOGIQUE",
         u"ENTEleveEnseignements": [u"PHILOSOPHIE", u"CHIMIE, BIOCHIMIE, SCIENCES DU VIVANT", u"ENSEIGNEMENT TECHNOLOGIQUE EN LV1", u"SCIENCES PHYSIQUES ET CHIMIQUES EN LABO.", u"VIE DE CLASSE", u"ACCOMPAGNEMENT PERSONNALISE", u"ANGLAIS LV1", u"EDUCATION PHYSIQUE ET SPORTIVE", u"ESPAGNOL LV2", u"MATHEMATIQUES", u"PHYSIQUE-CHIMIE"],
         u"ENTEleveCodeEnseignements": ["010300", u"308600"],
         #u"ENTPersonStructRattach": "2515",
         #u"ENTEleveClasses": "2515$T STL",
         u"ENTEleveGroupes": []}

eleve2 = copy(eleve)
#eleve2[u"ENTEleveParents"] = [u"994445", u"994446"]
#eleve2[u"ENTEleveAutoriteParentale"] = [u"994445", u"994446"]
eleve2[u"ENTElevePersRelEleve"] = [u"994445$1$0$2$1$0", u"994446$2$1$1$1$0"]
eleve2[u"ENTEleveMEF"] = u"21220008111"
#eleve2[u"ENTElevePere"] = u"994445"
#eleve2[u"ENTEleveMere"] = u"994446"
eleve2[u"ENTPersonLogin"] = u'albertine.delacourt03'
eleve2[u"ENTPersonJointure"] = u"14358"

eleve3 = copy(eleve)
#eleve3[u"ENTEleveParents"] = [u"994885", u"994886"]
#eleve3[u"ENTEleveAutoriteParentale"] = [u"994885", u"994886"]
eleve3[u"ENTElevePersRelEleve"] = [u"994885$1$0$2$1$0", u"994886$2$1$1$1$0"]
eleve3[u"ENTEleveMEF"] = u"21221118110"
#eleve3[u"ENTElevePere"] = u"994885"
#eleve3[u"ENTEleveMere"] = u"994886"
eleve3[u"ENTPersonLogin"] = u'albertine.delacourt04'
eleve3[u"ENTPersonJointure"] = u"14359"

eleves = {u'21220008110': eleve,
          u'21220008111': eleve2,
          u'21221118110': eleve3}

responsable2 = copy(responsable)
responsable2[u'ENTPersonJointure'] = u'994885'
responsable2[u'ENTPersonLogin'] = u'mathieu.delacourt02'
responsable2[u"givenName"] = "Mathieu"
responsable2[u'homePhone'] = u'+33 0 00 11 22 37'

responsable3 = copy(responsable)
responsable3[u'ENTPersonJointure'] = u'994846'
responsable3[u"personalTitle"] = "Mme"
responsable3[u"givenName"] = "Jeanne"
responsable3[u"ENTPersonLogin"] = "jeanne.delacourt01"
responsable3[u'homePhone'] = u'+33 0 00 11 22 34'

responsable4 = copy(responsable)
responsable4[u'ENTPersonJointure'] = u'994446'
responsable4[u"personalTitle"] = "Mme"
responsable4[u"givenName"] = "Lyse"
responsable4[u"ENTPersonLogin"] = "lyse.delacourt01"
responsable4[u'homePhone'] = u'+33 0 00 11 22 36'

responsable5 = copy(responsable)
responsable5[u'ENTPersonJointure'] = u'994445'
responsable5[u"givenName"] = "Philippe"
responsable5[u"ENTPersonLogin"] = "philippe.delacourt01"
responsable5[u'homePhone'] = u'+33 0 00 11 22 35'

responsable6 = copy(responsable)
responsable6[u'ENTPersonJointure'] = u'994886'
responsable6[u"personalTitle"] = "Mme"
responsable6[u"givenName"] = "Albertine"
responsable6[u"ENTPersonLogin"] = "albertine.delacourt01"
responsable6[u'homePhone'] = u'+33 0 00 11 22 38'

responsables = {u'994845': responsable,
                u'994885': responsable2,
                u'994846': responsable3,
                u'994446': responsable4,
                u'994445': responsable5,
                u'994886': responsable6,
}


prof = {
    u"ENTPersonJointure": "163",
    u"ENTPersonDateNaissance": "06/01/1918",
    u"ENTPersonNomPatro": "DELMARE",
    u"ENTPersonLogin": "ghislaine.delmare01",
    u'FieldActionType': 'CREATE',
    u'FieldModifiedStatus': 1,
    u'UserType': 'enseignant',
    u"sn": "DELMARE",
    u"givenName": "GHISLAINE",
    u"personalTitle": "Mme",
    u"mail": "ghislaine.delmare@ac-test.fr",
    #u"ENTPersonStructRattach": "2515",
    u"ENTAuxEnsCategoDiscipline": "LANGUES VIVANTES",
    u"ENTAuxEnsDisciplinesPoste": "ANGLAIS",
#    u"ENTAuxEnsMEF": ["2515$10210001110$4EME", "2515$10210001112$4EME SECTION EUROPEENNE", "2515$10110001110$5EME", "2515$10010012110$6EME"],
#    u"ENTAuxEnsMatiereEnseignEtab": "2515$ANGLAIS LV1",
#    u"ENTAuxEnsClasses": ["2515$4E3", "2515$5E2", "2515$5E3", "2515$5E4", "2515$6E1", "2515$6E2"],
    #u"ENTAuxEnsGroupes": '',
    #u"ENTAuxEnsClassesMatieres": ["2515$4E3$030201", "2515$5E2$030201", "2515$5E3$030201", "2515$5E4$030201", "2515$6E1$030201", "2515$6E2$030201"],
    #u"ENTAuxEnsGroupesMatieres": '',
    #u"ENTAuxEnsClassesPrincipal": '2515$4E3',
    #u"ENTPersonFonctions": "2515$ENS$ENSEIGNEMENT$L0422$ANGLAIS",
    u"PersEducNatPresenceDevantEleves": "O"
    }


administratif = {
    u"ENTPersonJointure": "34",
    u"ENTPersonDateNaissance": "04/09/1985",
    u"ENTPersonNomPatro": "THEODULE",
    u"ENTPersonLogin": "annie.dubled01",
    u'FieldActionType': 'CREATE',
    u'FieldModifiedStatus': 1,
    u'UserType': 'administratif',
    u"sn": "DUBLED",
    u"givenName": "ANNIE",
    u"personalTitle": "Mme",
    u"mail": "Annie.Dubled@ac-test.fr",
    u"ENTPersonStructRattach": '',
    u"ENTAuxEnsMEF": '',
    u"ENTAuxEnsMatiereEnseignEtab": '',
    u"ENTAuxEnsClasses": '',
    u"ENTAuxEnsClassesMatieres": '',
    #u"ENTPersonFonctions": "2515$ORI$ORIENTATION$O0040$ORIENTATION",
    u"PersEducNatPresenceDevantEleves": "N",
}

etablissement = {
    u"ENTStructureJointure": "2515",
    u"ENTStructureUAI": "0000000TW",
    u"ENTEtablissementUAI": "0000000TW",
    u"ENTStructureSIREN": "17450234560289",
    u"ENTStructureNomCourant": "D.E.E.E.-DU ac-test",
    u"ENTStructureTypeStruct": "INSPECTIONS ACADEMIQUES",
    u"ENTEtablissementMinistereTutelle": "MINISTERE DE L'EDUCATION NATIONALE",
    u"ENTEtablissementContrat": "PU",
    u'FieldActionType': 'CREATE',
    u'FieldModifiedStatus': 1,
    u"postOfficeBox": "608",
    u"street": "RUE CITE",
    u"postalCode": "18013",
    u"l": "DIJON CEDEX",
    u"telephoneNumber": "+33 211 25 687  00",
    u"facsimileTelephoneNumber": "+33 2 125899 20 01",
    u"ENTEtablissementStructRattachFctl": '',
    u"ENTEtablissementBassin": "BASSIN DU TEST",
    u"ENTServAcAcademie": "ac test",
    u"ENTStructureClasses": '',
    u"ENTStructureGroupes": [{'class': '4E3', 'group': '4E3_A'}, {'class': '4E3', 'group': '4E3_B'}],
}

subject = {
        u"ENTMatJointure": '308600',
        u"ENTLibelleMatiere": 'ANGLAIS',
        u'FieldActionType': 'CREATE',
        u'FieldModifiedStatus': 1
        }


def test_etablissement():
    keys = set(etablissement.keys()) | set([u"_id", u'FieldFromXMLImportActionDate', u'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('etablissement')
    for res in result:
        print "etablissement"
        assert keys == set(res.keys())
        for key in etablissement.keys():
            assert res[key] == etablissement[key], u"la valeur correspondant à : {} est différente".format(key)


def test_subject():
    keys = set(subject.keys()) | set([u"_id", u'FieldFromXMLImportActionDate', u'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('subject')
    for res in result:
        print "subject"
        assert keys == set(res.keys())
        for key in subject.keys():
            assert res[key] == subject[key], u"la valeur correspondant à : {} est différente".format(key)


def test_prof():
    objectid = 'ENTPersonStructRattach'
    relations = [(u'ENTAuxEnsMatiereEnseignEtab', ['ANGLAIS LV1']),
                 (u"ENTAuxEnsClasses", ["4E3", "5E2", "5E3", "5E4", "6E1", "6E2"]),
                 (u"ENTAuxEnsClassesPrincipal", ["4E3"]),
                 (u"ENTAuxEnsGroupes", ["4E3_A"]),
                 (u"ENTAuxEnsMEF", ["4EME", "4EME SECTION EUROPEENNE", "5EME", "6EME"]),
                 (u'ENTPersonFonctions', (['ENSEIGNEMENT'], ['ANGLAIS'])),
                 (u"ENTAuxEnsClassesMatieres", ["4E3", "5E2", "5E3", "5E4", "6E1", "6E2"]),
                 (u"ENTAuxEnsGroupesMatieres", ["4E3_A"]),
                 ]
    keys = set(prof.keys()) | set([u"userPassword", u"_id", u'uid', u'FieldFromXMLImportActionDate', u'id']) | set([objectid])
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'enseignant')
    for res in result:
        print "professeur"
        assert keys == set(res.keys())
        for key in prof.keys():
            assert res[key] == prof[key], u"la valeur correspondant à : {} est différente".format(key)
        etab = res[objectid]
        assert isinstance(etab, ObjectId), u"{} n'est pas une relation".format(objectid)

        for relation, values in relations:
            assert relation in res
            if relation == u"ENTAuxEnsClassesMatieres":
                for idx, rel in enumerate(res[relation]):
                    assert rel['class'] == values[idx]
                    assert isinstance(rel['subject'], ObjectId)
            elif relation == u"ENTAuxEnsGroupesMatieres":
                assert res[relation]['group'] == values[0]
                assert isinstance(res[relation]['subject'], ObjectId)
            else:
                if isinstance(res[relation], list):
                    for idx, rel in enumerate(res[relation]):
                        assert isinstance(rel['etablissement'], ObjectId)
                        assert rel['etablissement'] == etab
                        assert rel['name'] == values[idx]
                else:
                    assert isinstance(res[relation]['etablissement'], ObjectId)
                    assert res[relation]['etablissement'] == etab
                    if isinstance(values, tuple):
                        assert res[relation]['function'] == values[0][0]
                        assert res[relation]['discipline'] == values[1][0]
                    else:
                        assert res[relation]['name'] == values[0]

def test_administratif():
    relations = [(u'ENTPersonFonctions', (['ORIENTATION'], ['ORIENTATION']))
                 ]
    keys = set(administratif.keys()) | set([u"userPassword", u"_id", u'uid', u'FieldFromXMLImportActionDate', u'id'])
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'administratif')
    for res in result:
        print "administratif"
        assert keys == set(res.keys())
        for key in administratif.keys():
            assert res[key] == administratif[key], u"la valeur correspondant à : {} est différente".format(key)
        for relation, values in relations:
            assert relation in res
            assert isinstance(res[relation]['etablissement'], ObjectId)
            assert res[relation]['function'] == values[0][0]
            assert res[relation]['discipline'] == values[1][0]


def test_responsable():
    keys = set(responsable.keys()) | set([u"userPassword", u"_id", u'uid', u'FieldFromXMLImportActionDate', u'id'])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'responsable')
    for res in result:
        idx = res[u'ENTPersonJointure']
        print "responsable numero", idx
        assert keys == set(res.keys())
        for key in responsable.keys():
            assert res[key] == responsables[idx][key], u"la valeur correspondant à : {} est différente".format(key)


def test_eleves():
    objectids = ['ENTEleveParents', 'ENTElevePere', 'ENTEleveMere', 'ENTEleveAutoriteParentale', 'ENTPersonStructRattach']
    relations = [(u'ENTEleveClasses', ['T STL'])]
    keys = set(eleve.keys()) | set([u"userPassword", u"_id", u'uid', u'FieldFromXMLImportActionDate', u'id']) | set(objectids)
    for relation in relations:
        keys |= set([relation[0]])
    path_aaf_complet = join(data, '20170704')
    main(path_aaf_complet, reset_db=True, close=False)
    result = db.fetchall('user', 'UserType', 'eleve')
    for res in result:
        idx = res[u'ENTEleveMEF']
        print "eleve numero", idx
        assert keys == set(res.keys())
        for key in eleve.keys():
            if key != 'ENTEleveCodeEnseignements':
                assert res[key] == eleves[idx][key], u"la valeur correspondant à : {} est différente".format(key)
            else:
                assert res[key][0] == u'010300'
                assert isinstance(res[key][1], ObjectId)
        for objectid in objectids:
            values = res[objectid]
            if isinstance(values, list):
                for val in values:
                    assert isinstance(val, ObjectId), u"{} n'est pas une relation".format(objectid)
                    #FIXME bon parent ?
            else:
                assert isinstance(values, ObjectId), u"{} n'est pas une relation".format(objectid)

        for relation, values in relations:
            assert relation in res
            assert isinstance(res[relation]['etablissement'], ObjectId)
            assert res[relation]['etablissement'] == res['ENTPersonStructRattach']
            assert res[relation]['name'] == values[0]


