# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2013
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
miscellaneous utilities
"""
from eoleaaf.util import get_new_id, pwgen, modif_fields, log

#_______________________________________________________________________________
# XML parsing utilities

def parse_xml_files(aaftype, aaffunc, xml_files, lib):
    """
    Appel à la fonction de traitement du XML
    en fonction du type de fichier

    :param aaftypes: mapping nom de fichier/méthode à appeler
    :param xml_files: liste des fichiers à traiter
    :param lib: module aaf ou aafdelta
    """
    log.info("Traitement des fichiers {0}".format(aaftype))
    typed_xml_files = [ fname for fname in xml_files if aaftype in fname]
    for fname in typed_xml_files:
        log.info("\nLecture du fichier {0}".format(fname))
        getattr(lib, aaffunc)(fname)

def user_id(tdata):
    """finds the id in the XML and formates it

    :param tdate: xml etree object
    :returns: data dictionnary
    """
    tid = tdata.find('identifier/id').text
    return {'id':unicode(tid)}

#_______________________________________________________________________________
# filling missing fields in the database

#def eleve_uid_and_password(eleve):
#    """
#    new calculated uid and password
#
#    :param eleve: eleve dict
#    :returns: the eleve filled dict, and the new uid
#    """
#    uid = eleve['uid'] = get_new_id()
#    eleve['userPassword'] = pwgen()
#    return eleve, uid

def classes_for_one_eleve(eleve, classes_buffer, uid):
    """traitement des classes de l'élève

    :param eleve: le dico des eleves
    :param classes_buffer: pour savoir si la classe existe ou non
    :param uid: uid de l'eleve
    :returns: None. updates the classes_buffer, that's all
    """
    if 'ENTEleveClasses' in eleve:
        # classe (format AAF : "numero$classe")
        for grp in eleve['ENTEleveClasses'].split('\n'):
            if grp not in classes_buffer:
                classes_buffer[grp] = [uid]
            elif uid not in classes_buffer[grp]:
                classes_buffer[grp].append(uid)

def groupe_eleve(eleve, groupes_buffer, uid):
    """ajout de l'eleve au groupe

    :param eleve: eleve dict
    :param groupes_buffer: buffer courant pour memoriser les groupes
    :param uid: uid de l'eleve
    """
    if 'ENTEleveGroupes' in eleve:
        # traitement des groupes de l'élève
        # groupe (format AAF : "numero$groupe")
        for grp in eleve['ENTEleveGroupes'].split('\n'):
            if grp == u'':
                continue
            if grp not in groupes_buffer:
                groupes_buffer[grp] = [uid]
            elif uid not in groupes_buffer[grp]:
                groupes_buffer[grp].append(uid)

