#!/usr/bin/env python
# -*- coding: utf8 -*-
"""
template generation for the ldifs
"""
from sys import argv
from os import makedirs
from os.path import join, isdir
from eoleaaf.attribute import *
from eoleaaf.config import usersdn, structsdn, groupsdn, template_path

# récupérons le mode d'utilisation de gentemplate (complet ou delta ?)
mode = argv[1]
global delta
if mode == 'delta':
    delta = True
else:
    delta = False

common_template_name = 'common.tmpl'

# some attributes do not need to be updated
unupdated_struct_attrs = (
                    'ENTStructureUAI',
                    'ENTStructureJointure',
                    'ENTStructureSIREN',
                    )
unupdated_group_attrs = (
                    'cn',
                    'owner',
                    'description',
                    )
unupdated_user_attrs = (
                    'uid',
                    'ENTPersonJointure',
                    'userPassword',
                    'ENTPersonLogin',
                    )

def gen_object_class(objectclasses):
    if isinstance(objectclasses, str):
        objectclasses = [objectclasses]
    result = []
    for obj in objectclasses:
        result.append('objectClass: {0}'.format(obj))
    return result

def gen_dn(dn, branch):
    return "dn: {0}=%%{0},{1}".format(dn, branch)

def translate_ldif(terms, mandatory=True):
    """translates to a readable ldif format

    :terms: string that contains all the attributes
    :mandatory: if False, adds an "is_empty" clause in the cheetah template
    """
    result = []
    terms = terms.strip().split("\n")
    if mandatory:
        for term in terms:
            if term == '':
                continue
            result.append("""%for %%i in %%{0}.split("\\n")
%if %%i != ''
{0}: %%i
%end if
%end for""".format(term))
    else:
        for term in terms:
            if term == '':
                continue
            result.append("""%if %%varExists('{0}')
%for %%i in %%{0}.split("\\n")
%if %%i != ''
{0}: %%i
%end if
%end for
%end if""".format(term))
    return result

def translate_maj_ldif(terms, unupdated):
    """
    Génération de morceaux de template Cheetah
    Pour des opérations "replace" ldif sur les attributs

    :terms: string that contains all the attributes
    :unupdated: list of unupdated attributes
    """
    result = []
    terms = terms.strip().split("\n")
    for term in terms:
        if term == '' or term in unupdated:
            continue
        # TODO: replace for "member" ?
        result.append("""%if %%varExists('{0}')
replace: {0}
%for %%i in %%{0}.split("\\n")
%if %%i != ''
{0}: %%i
%end if
%end for
-
%end if""".format(term))
    return result

def gen_must_may(must, may):
    must = translate_ldif(must)
    may = translate_ldif(may, mandatory=False)
    return must + may

def gen_maj(attrs, unupdated):
    return translate_maj_ldif(attrs, unupdated)

def write_template(template_name, content):
    if not isdir(template_path):
        makedirs(template_path)
    fh = file(join(template_path, template_name), 'w')
    fh.write(content+'\n\n')
    fh.close()

def gen_template(template_name, must, may, objectclasses, dn, branch, unupdated):
    """
    Génération des modèles de ldif Cheetah
    * template_name : nom du fichier résultat
    """
    dn_tmpl = gen_dn(dn, branch)
    # template de "création"
    content = [dn_tmpl]
    content.extend(gen_object_class(objectclasses))
    if not delta:
        if isinstance(objectclasses, list):
            content.append('structuralObjectClass: {0}'.format(objectclasses[0]))
        else:
            content.append('structuralObjectClass: {0}'.format(objectclasses))
    content.extend(gen_must_may(must, may))
    print "Ecriture du template {0}".format(template_name)
    write_template(template_name, "\n".join(content))
    # template de mise à jour
    template_name = "maj_"+template_name
    content = [dn_tmpl]
    content.append('changetype: modify')
    content.extend(gen_maj(must+may, unupdated))
    print "Ecriture du template {0}".format(template_name)
    write_template(template_name, "\n".join(content))

gen_template('etablissement.ldif',
             ENTStructure_must+ENTEtablissement_must,
             ENTStructure_may+ENTEtablissement_may,
             'ENTEtablissement',
             'ENTStructureUAI', structsdn,
             unupdated_struct_attrs)

gen_template('servac.ldif',
             ENTStructure_must+ENTServAc_must,
             ENTStructure_may+ENTServAc_may,
             'ENTServAc',
             'ENTStructureSIREN', structsdn,
             unupdated_struct_attrs)

gen_template('groupe.ldif',
             ENTGroupe_must,
             ENTGroupe_may,
             'ENTGroupe',
             'cn', groupsdn,
             unupdated_group_attrs)

gen_template('classe.ldif',
             ENTClasse_must,
             ENTClasse_may,
             'ENTClasse',
             'cn', groupsdn,
             unupdated_group_attrs)

gen_template('eleve.ldif',
             ENTPerson_must+ENTEleve_must,
             ENTPerson_may+ENTEleve_may,
             'ENTEleve',
             'uid', usersdn,
             unupdated_user_attrs)

gen_template('responsable.ldif',
             ENTPerson_must+ENTAuxPersRelEleve_must,
             ENTPerson_may+ENTAuxPersRelEleve_may,
             ['ENTPerson', 'ENTAuxPersRelEleve'],
             'uid', usersdn,
             unupdated_user_attrs)

gen_template('enseignant.ldif',
             ENTPerson_must+ENTAuxEnseignant_must,
             ENTPerson_may+ENTAuxEnseignant_may,
             ['ENTPerson', 'ENTAuxEnseignant'],
             'uid', usersdn,
             unupdated_user_attrs)

gen_template('nonens-servac.ldif',
             ENTPerson_must+ENTAuxNonEnsServAc_must,
             ENTPerson_may+ENTAuxNonEnsServAc_may,
             ['ENTPerson', 'ENTAuxNonEnsServAc'],
             'uid', usersdn,
             unupdated_user_attrs)

gen_template('nonens-etab.ldif',
             ENTPerson_must+ENTAuxNonEnsEtab_must,
             ENTPerson_may+ENTAuxNonEnsEtab_may,
             ['ENTPerson', 'ENTAuxNonEnsEtab'],
             'uid', usersdn,
             unupdated_user_attrs)

