#!/usr/bin/env python
# coding: utf-8
from sys import exit
from optparse import OptionParser
from samba.samdb import SamDB
from samba.auth import system_session
from samba.dsdb import GTYPE_SECURITY_GLOBAL_GROUP
import samba.getopt as options
from eoleaaf.util import SimpleConnectionWrapper
from eoleaaf.ldiftranslator import LdifTranslator, gen_group_cn, gen_user_cn, gen_user_displayname

db = SimpleConnectionWrapper()
db.connect(default_cursor=False)
#samdb = SamDB(session_info=system_session(),
#              credentials=creds, lp=lp)
parse = OptionParser()
lp = options.SambaOptions(parse).get_loadparm()
creds = options.CredentialsOptions(parse).get_credentials(lp)
samdb = SamDB(session_info=system_session(), credentials=creds, lp=lp)
transaction_start = samdb.transaction_start
transaction_commit = samdb.transaction_commit
transaction_cancel = samdb.transaction_cancel

class SmbCancel(Exception):
    pass

def fake_start():
    pass

def fake_commit():
    pass

def fake_cancel():
    transaction_cancel()
    raise SmbCancel("transaction cancelled")

samdb.transaction_start = fake_start
samdb.transaction_commit = fake_commit
samdb.transaction_cancel = fake_cancel

translator = LdifTranslator()

siren = {}
uai = {}
for row in db.fetchtable('etablissement'):
    dico = translator.translate_one('etablissement', row)
    siren[dico['ENTStructureJointure_ori']] = dico['ENTStructureSIREN']
    uai[dico['ENTStructureJointure_ori']] = dico['ENTStructureUAI']

eleves = []
enseignants = []
administratifs = []
for typ in ('eleve', 'enseignant', 'administratif'):
    print 'ajout des {}s'.format(typ)
    try:
        transaction_start()
        for row in db.fetchtable(typ):
            dico = translator.translate_one(typ, row)
            # FIXME XXX HAAAACK pour autoriser le prénom vide alors qu'il
            # est supposé être obligatoire dans les préconisations du SDET.
            if dico['givenName'] is None:
                dico['givenName'] = "-"
            if dico['sn'] is None:
                dico['sn'] = "-"
            gecos = str(gen_user_displayname(dico['sn'].encode('utf-8'), dico['givenName'].encode('utf-8')))
            # FIXME : mot de passe en dur
            samdb.newuser(str(dico['ENTPersonLogin']), 'totokmlkOZOKo332$',
                          givenname=gecos, gecos=gecos, useusernameascn=True)
            if typ == 'eleve':
                eleves.append(translator.calc_eleves_dn(str(dico['ENTPersonLogin'])))
            elif typ == 'enseignant':
                #FIXME translator pour enseignant ?
                enseignants.append(translator.calc_eleves_dn(str(dico['ENTPersonLogin'])))
            elif typ == 'administratif':
                #FIXME translator pour administratif ?
                administratifs.append(translator.calc_eleves_dn(str(dico['ENTPersonLogin'])))
            #samdb.deleteuser(str(row['ENTPersonLogin']))
        transaction_commit()
    except SmbCancel:
        print "cannot complete the transaction"
        exit(1)

for typ in ['eleves', 'enseignants', 'administratifs']:
    if typ == 'eleves':
        members = eleves
    elif typ == 'enseignants':
        members = enseignants
    elif typ == 'administratifs':
        members = administratifs
    try:
        ldif = """dn: CN={},CN=Users,DC=ac-test,DC=fr
changetype: modify
add: member
""".format(typ)
        samdb.newgroup(typ, description=typ.capitalize())
        for member in members:
            ldif += "member: " + member.encode('utf-8') + '\n'
        samdb.modify_ldif(ldif)
    except SmbCancel:
        print "cannot complete the transaction for creating {}".format(typ)
        exit(1)

for typ in ('classe', 'groupe'):
    if typ == 'classe':
        continue
    try:
        transaction_start()
        for row in db.fetchtable(typ):
            dico = translator.translate_one('classe', row)
            group_name = str(gen_group_cn(dico['description_ori'], siren))
            samdb.newgroup(group_name, description=dico['description'])
            #samdb.deletegroup(group_name)
            ldif = """dn: CN={},CN=Users,DC=ac-test,DC=fr
changetype: modify
add: member
""".format(group_name)
            for member in dico['member'].split('\n'):
                ldif += "member: " + member.encode('utf-8') + '\n'
            samdb.modify_ldif(ldif)
        transaction_commit()
    except SmbCancel:
        print "cannot complete the transaction to creating {}".format(typ)
        exit(1)
#
#samdb.deleteuser(str(row['ENTPersonLogin']))
#samdb.newuser('toto1', 'toto')
#samdb.newuser(username, password, force_password_change_at_next_login_req=must_change_at_next_login,
#              useusernameascn=use_username_as_cn, userou=userou, surname=surname, givenname=given_name, initials=initials,
#              profilepath=profile_path, homedrive=home_drive, scriptpath=script_path, homedirectory=home_directory,
#              jobtitle=job_title, department=department, company=company, description=description,
#              mailaddress=mail_address, internetaddress=internet_address,
#              telephonenumber=telephone_number, physicaldeliveryoffice=physical_delivery_office,
#              nisdomain=nis_domain, unixhome=unix_home, uid=uid,
#              uidnumber=uid_number, gidnumber=gid_number,
#              gecos=gecos, loginshell=login_shell,
#              smartcard_required=smartcard_required)
