# -*- coding: utf-8 -*-
"""AAF parsing entry point
"""
import time, sys
from os.path import join
from glob import glob
from eoleaaf import aaf
from config import dbtype

from eoleaaf.ihm import print_time
from eoleaaf.miscutil import parse_xml_files
from eoleaaf.util import db

times = [time.time()]

def main(xml_path, reset_db, close=True):
    """parsing main entry point
    the parsing type depends on the name of the xml file
    """
    # REM: parsing order is very important for database integrity validation
    aaftypes = [{'pattern': "_EtabEducNat_", 'function': "parse_aaf_etab_educnat", 'type': 'etablissement'}]
    if dbtype == 'mongodb':
        aaftypes.extend([{'pattern': "_MatiereEducNat_", 'function': "parse_aaf_subjects", 'type': 'matiere'},
                         {'pattern': "_PersRelEleve_", 'function': "parse_aaf_responsables", 'type': 'responsable'},
                         {'pattern': "_Eleve_", 'function': "parse_aaf_eleves", 'type': 'élève'}])
    else:
        aaftypes.extend([{'pattern': "_Eleve_", 'function': "parse_aaf_eleves", 'type': 'élève'},
                         {'pattern': "_PersRelEleve_", 'function': "parse_aaf_responsables", 'type': 'responsable'}])
    aaftypes.append({'pattern': "_PersEducNat_", 'function': "parse_aaf_profs", 'type': 'administratif'})

    xml_files = glob(join(xml_path, "*.xml"))
    xml_files.sort()

    # parsing etab
    if reset_db:
        aaf.reset_db()
    else:
        aaf.maj_mode = True
    for xmlfile in aaftypes:
        parse_xml_files(xmlfile['pattern'], xmlfile['function'], xml_files, aaf)
        print_time(xmlfile['type'], times)
        if dbtype != 'mongodb' and xmlfile['pattern'] == '_Eleve_':
            # écriture des classes
            aaf.flush_classes_buffer()
            print_time('classes', times)
            # écriture des groupes
            aaf.flush_groupes_buffer()
            print_time('groupes', times)
    if close:
        db.close()

