#!/bin/bash
login=${1}
homebasedir=${2}
if [ -z "${login}" ]
then
    #echo "${login} : Démarrage machine!"
    exit 0
fi

if [[ "${login}" == *_ ]]
then
    #echo "${login} : Compte machine '_' !"
    exit 0
fi

if [[ "${login}" == *\$ ]]
then
    #echo "${login} : Compte machine '\$' !"
    exit 0
fi
#echo "${login} : Compte utilisateur !"

userdir="${homebasedir}/${login}"
if [ -d "${userdir}" ]
then
    # le répertoire existe déjà !
    exit 0
fi

# le répertoire n'existe pas, je le crée avec les bon droits/acl !
mkdir -p "${userdir}"
setfacl -Rbk "${userdir}"
chmod 700 "${userdir}"
setfacl -m u:${login}:rwx "${userdir}"
setfacl -dm u:${login}:rwx "${userdir}"
