#!/usr/bin/env python

import sys
import time
from datetime import datetime, timedelta
from scribe.eolegroup import Group
from scribe.eoleldap import LdapEntry
from scribe.eoleuser import User
from scribe.enseignants import Enseignant
from pyeole.process import system_code, system_out


sys.path.append('/usr/share')
from ead2.backend.actions.scribe.tool.userpurge import action_full_del

grouplist  = []
userlist = []

g = Group()
groups = g.get_groups()
for grp in groups:
    if 'invite-' in grp:
        grouplist.append(grp)
        entry = LdapEntry()
        members = entry.get_members(grp)
        for member in members :
            userlist.append(member)

delusers=[]
for user in userlist:
    u=User()
    shadowexpire = datetime.fromtimestamp(int(u.get_attr(user, 'shadowExpire')[0]))+timedelta(days=14)
    fornow = datetime.now().replace(hour=0, minute=0, second=0, microsecond=0)

    if shadowexpire <= fornow :
        delusers.append(user)

if delusers:
    ldapuser = Enseignant()
    action_full_del(delusers,ldapuser)
