#!/usr/bin/python3
"""Restauration du controleur ADDC"""
import sys
from os.path import isdir
from pyeole.process import system_code
from pyeole.service import manage_services
from pyeole.bareosrestore import exit_if_running_jobs, bareos_restore_several_paths

BACKUP_DIR = '/var/lib/lxc/addc/rootfs/'
MODE_SCRIBE = True
if not isdir(BACKUP_DIR):
    BACKUP_DIR = ''
    MODE_SCRIBE = False
BACKUP_DIR += '/home/backup/samba/'

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """ADDC helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)

def pre():
    print("pre ADDC")

def post():
    print("post ADDC")
    if not isdir(BACKUP_DIR):
        print("Il manque le repertoire {0}".format(BACKUP_DIR))
        sys.exit(1)
    cmd = ['/usr/bin/addc_restore']
    if MODE_SCRIBE:
        cmd = ['lxc-attach', '-n', 'addc', '--'] + cmd
    code = system_code(cmd)
    if code != 0:
        sys.exit(code)
    if MODE_SCRIBE:
        # reintegration au domaine
        code = system_code(['/usr/share/eole/postservice/05-eolead-join-and-sync-ldap'])
    sys.exit(code)

def job(jobid):
    print("Restauration des fichiers Samba")
    path_list = [BACKUP_DIR]
    if MODE_SCRIBE:
        path_list.append('/root/.eolead')
    bareos_restore_several_paths(path_list, jobid)

priority = 21
