#!/usr/bin/python3
"""Restauration du controleur ADDC"""
import sys
from os.path import isdir, isfile
from os import unlink
from creole.client import CreoleClient
from pyeole.process import system_code
from pyeole.service import manage_services
from pyeole.bareosrestore import exit_if_running_jobs, bareos_restore_several_paths

client = CreoleClient()
if client.get_creole('openldap_installed', 'oui') == 'oui':
    if isdir('/var/lib/lxc/addc/rootfs'):
        BACKUP_DIR = '/var/lib/lxc/addc/rootfs'
        SYSVOL_DIR = '/var/lib/lxc/addc/rootfs'
        MODE = 'scribe'
    else:
        # Seth pas education
        BACKUP_DIR = ''
        SYSVOL_DIR = ''
        MODE = 'seth'
elif client.get_creole('mode_conteneur_actif') == 'oui':
    BACKUP_DIR = ''
    SYSVOL_DIR = client.get_creole('container_path_domaine')
    MODE = 'amonecole'
else:
    # Seth education
    BACKUP_DIR = ''
    SYSVOL_DIR = ''
    MODE = 'seth'
BACKUP_DIR += '/home/backup/samba/'
SYSVOL_DIR = SYSVOL_DIR + '/home/sysvol'

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """ADDC helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)

def pre():
    print("pre ADDC")

def post():
    print("post ADDC")
    if not isdir(BACKUP_DIR):
        print("Il manque le repertoire {0}".format(BACKUP_DIR))
        sys.exit(1)
    old_style_backup = isfile(BACKUP_DIR + '/bareos/sysvol.tar.gz')
    if old_style_backup:
        cmd = ['/usr/bin/online_addc_restore']
    else:
        cmd = ['/usr/bin/addc_restore']
    if MODE == 'scribe':
        cmd = ['lxc-attach', '-n', 'addc', '--'] + cmd
    code = system_code(cmd, container='domaine')
    if code != 0:
        sys.exit(code)
    if MODE == 'scribe':
        # reintegration au domaine
        code = system_code(['/usr/share/eole/postservice/05-eolead-join-and-sync-ldap'])
    if MODE == 'amonecole':
        # reintegration au domaine
        system_code(['cp', client.get_creole('container_path_domaine') + '/etc/eole/private/eole-seth-education.password', client.get_creole('container_path_fichier') + '/etc/eole/private/eole-seth-education.password'])
        system_code(['cp', client.get_creole('container_path_domaine') + '/etc/eole/private/eole-seth-education.password', client.get_creole('container_path_web') + '/etc/eole/private/eole-seth-education.password'])
        unlink(client.get_creole('container_path_fichier') + '/var/lib/samba/.instance_ok')
        system_code(['/usr/share/eole/postservice/26-manage-samba-master', 'instance'])
        system_code(['/usr/share/eole/postservice/26-manage-samba-member', 'instance'])
        code = system_code(['/usr/share/eole/postservice/30-proxy', 'instance', 'restauration'])
    sys.exit(code)

def job(jobid):
    print("Restauration des fichiers Samba")
    path_list = [BACKUP_DIR, SYSVOL_DIR]
    if MODE == 'scribe':
        path_list.append('/root/.eolead')
    if MODE == 'amonecole':
        path_list.append(client.get_creole('container_path_domaine') + '/etc/eole/private/eole-seth-education.password')
    bareos_restore_several_paths(path_list, jobid)

priority = 21
