#!/usr/bin/perl -s -w

#====================================================================
# perl script computing AES crypted passwords and their SSHA hash,
# and pushing them to ldap directory
#
# INPUT : $1=user, $2=cleartext-password
# OUTPUT: 0 if everything is ok. (and computed crypted password is pushed to ldap directory)
#
#
# Copyright (C) 2013 David Coutadeur
# Copyright (C) 2013 LTB-project.org
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# GPL License: http://www.gnu.org/licenses/gpl.txt

use strict;
use warnings;

use vars qw/ $h /;
use MIME::Base64 qw( encode_base64 );
use Digest::SHA1 ("sha1");
use Net::LDAP;

#====================================================================
# Configuration
#====================================================================

# some ldap variables
my $ldapUrl = "ldap://scribe.domaine.lan:389/";
my $ldapAdmin = "cn=admin,o=gouv,c=fr";
my $ldapPassword = "aeceijeu";
my $ldapBase = "o=gouv,c=fr";

# ldapFilter: USER is replaced by appropriate input
my $ldapFilter = '(&(objectClass=inetOrgPerson)(objectClass=posixAccount)(uid=USER))';

# attribute used to store SSHA user password
my $userPasswordAttr = 'userPassword';

#====================================================================
# Functions
#====================================================================


sub send_to_directory {
    my ( $user, $userPassword ) = @_;
    my $ldap = Net::LDAP->new("$ldapUrl");

    # bind to a directory with dn and password
    my $result = $ldap->bind( "$ldapAdmin", password => "$ldapPassword" );

    $ldapFilter =~ s/USER/$user/;
    $result = $ldap->search(
        base   => "$ldapBase",
        scope  => 'sub',
        filter => "$ldapFilter",
    );
    my @entries = $result->entries;

    # if entry is duplicated in directory, quits with error
    die( "More than one entry found for " . $user ) if scalar @entries > 1;

    # if entry is not found in directory, gently quits
    exit 0 if scalar @entries == 0;

    my $dn = $entries[0]->dn;

    # do the job : modify userPasswords
    $result = $ldap->modify(
        $dn,
        replace => {
            "$userPasswordAttr"          => "$userPassword",
        }
    );

    $result = $ldap->unbind;    # take down session

}

sub make_salt {
    my $length = 32;
    $length = $_[0] if exists( $_[0] );
    my @tab = ( '.', '/', 0 .. 9, 'A' .. 'Z', 'a' .. 'z' );
    return join "", @tab[ map { rand 64 } ( 1 .. $length ) ];
}

sub password_hash {
    my $password = $_[0];
    my $hash;
    my $salt = make_salt(4);
    $hash = "{SSHA}" . encode_base64( sha1( $password . $salt ) . $salt, '' );

    return $hash;
}

sub usage() {
    print "USAGE:\n";
    print "./passwordhk.pl [-h] uid password\n\n";
}

#====================================================================
# Entry point
#====================================================================

if ($h) {
    usage();
    exit(0);
}
if ( ( scalar @ARGV ) < 2 ) {
    print "Missing or incorrect argument\n";
    usage();
    exit(1);
}

# getting the input parameters
my $uid          = $ARGV[0];
my $userPassword = $ARGV[1];

# compute SSHA password
my $hashed = password_hash("$userPassword");

# apply the two previous passwords to the specified $uid user in ldap directory
send_to_directory( "$uid", "$hashed" );

exit 0;
