<?php
/*
 * Copyright 2007-2011 Charles du Jeu <contact (at) cdujeu.me>
 * This file is part of AjaXplorer.
 *
 * AjaXplorer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * AjaXplorer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with AjaXplorer.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <http://www.ajaxplorer.info/>.
 *
 */
defined('AJXP_EXEC') or die( 'Access not allowed');

/**
 * @package info.ajaxplorer.plugins
 * AJXP_Plugin to access a remote server using the File Transfer Protocol
 */
class ftpCasAccessDriver extends fsAccessDriver {

    /*public function init($repository){
        $this->repository = $repository;
        AJXP_Logger::debug("REPO", $repository->getOption('FTP_HOST'));
}*/
    /*public function init($repository)
    {
        $this->repository = $repository;
        AJXP_Logger::debug($this->repository);
    }*/

    public function loadManifest(){

		parent::loadManifest();
		// BACKWARD COMPATIBILITY!
		$res = $this->xPath->query('//param[@name="USER"] | //param[@name="PASS"] | //user_param[@name="USER"] | //user_param[@name="PASS"]');
		foreach($res as $node){
			if($node->getAttribute("name") == "USER"){
				$node->setAttribute("name", "FTP_USER");
			}else if($node->getAttribute("name") == "PASS"){
				$node->setAttribute("name", "FTP_PASS");
			}
		}
		$this->reloadXPath();
	}

	/**
	 * Parse
	 * @param DOMNode $contribNode
	 */
	protected function parseSpecificContributions(&$contribNode){
		parent::parseSpecificContributions($contribNode);
		if($contribNode->nodeName != "actions") return ;
		// ENVOLE : Activation du téléchargement d'archives
		//$this->disableArchiveBrowsingContributions($contribNode);
        $this->redirectActionsToMethod($contribNode, array("upload", "next_to_remote", "trigger_remote_copy"), "uploadActions");
	}

	function initRepository(){
		if(is_array($this->pluginConf)){
			$this->driverConf = $this->pluginConf;
		}else{
			$this->driverConf = array();
		}
        AJXP_Logger::debug('repo', $this->repository->getOption('FTP_HOST'));
		$create = $this->repository->getOption("CREATE");
		$wrapperData = $this->detectStreamWrapper(true);
		$this->wrapperClassName = $wrapperData["classname"];
		$this->urlBase = $wrapperData["protocol"]."://".$this->repository->getId();
		$recycle = $this->repository->getOption("RECYCLE_BIN");
		if($recycle != ""){
			RecycleBinManager::init($this->urlBase, "/".$recycle);
		}
	}

	function uploadActions($action, $httpVars, $filesVars){
		switch ($action){
			case "trigger_remote_copy":
				if(!$this->hasFilesToCopy()) break;
				$toCopy = $this->getFileNameToCopy();
				AJXP_XMLWriter::header();
				AJXP_XMLWriter::triggerBgAction("next_to_remote", array(), "Copying file ".$toCopy." to ftp server");
				AJXP_XMLWriter::close();
				exit(1);
			break;
			case "next_to_remote":
				if(!$this->hasFilesToCopy()) break;
				$fData = $this->getNextFileToCopy();
				$nextFile = '';
				if($this->hasFilesToCopy()){
					$nextFile = $this->getFileNameToCopy();
				}
				AJXP_Logger::debug("Base64 : ", array("from"=>$fData["destination"], "to"=>base64_decode($fData['destination'])));
				$destPath = $this->urlBase.base64_decode($fData['destination'])."/".$fData['name'];
				//$destPath = AJXP_Utils::decodeSecureMagic($destPath);
				// DO NOT "SANITIZE", THE URL IS ALREADY IN THE FORM ajxp.ftp://repoId/filename
				$destPath = SystemTextEncoding::fromPostedFileName($destPath);
				AJXP_Logger::debug("Copying file to server", array("from"=>$fData["tmp_name"], "to"=>$destPath, "name"=>$fData["name"]));
				try {
					$fp = fopen($destPath, "w");
					$fSource = fopen($fData["tmp_name"], "r");
					while(!feof($fSource)){
						fwrite($fp, fread($fSource, 4096));
					}
					fclose($fSource);
					AJXP_Logger::debug("Closing target : begin ftp copy");
					// Make sur the script does not time out!
					@set_time_limit(240);
					fclose($fp);
					AJXP_Logger::debug("FTP Upload : end of ftp copy");
					@unlink($fData["tmp_name"]);
				}catch (Exception $e){
					$user->saveTemporaryData("tmpUpload",array());
					AJXP_Logger::debug("Error during ftp copy", array($e->getMessage(), $e->getTrace()));
				}
				AJXP_Logger::debug("FTP Upload : shoud trigger next or reload nextFile=$nextFile");
				AJXP_XMLWriter::header();
				if($nextFile!=''){
					AJXP_XMLWriter::triggerBgAction("next_to_remote", array(), "Copying file ".SystemTextEncoding::toUTF8($nextFile)." to remote server");
				}else{
					AJXP_XMLWriter::triggerBgAction("reload_node", array(), "Upload done, reloading client.");
				}
				AJXP_XMLWriter::close();
				exit(1);
			break;
			case "upload":
				$rep_source = AJXP_Utils::securePath("/".$httpVars['dir']);
				AJXP_Logger::debug("Upload : rep_source ", array($rep_source));
				$logMessage = "";
				foreach ($filesVars as $boxName => $boxData)
				{
					if(substr($boxName, 0, 9) != "userfile_")     continue;
					AJXP_Logger::debug("Upload : rep_source ", array($rep_source));
					$err = AJXP_Utils::parseFileDataErrors($boxData);
					if($err != null)
					{
						$errorCode = $err[0];
						$errorMessage = $err[1];
						break;
					}
                    if(isSet($httpVars["auto_rename"])){
                        $destination = $this->urlBase.$rep_source;
                        $boxData["name"] = fsAccessDriver::autoRenameForDest($destination, $boxData["name"]);
                    }
					$boxData["destination"] = base64_encode($rep_source);
					$destCopy = AJXP_XMLWriter::replaceAjxpXmlKeywords($this->repository->getOption("TMP_UPLOAD"));
					AJXP_Logger::debug("Upload : tmp upload folder", array($destCopy));
					if(!is_dir($destCopy)){
						if(! @mkdir($destCopy)){
							AJXP_Logger::debug("Upload error : cannot create temporary folder", array($destCopy));
							$errorCode = 413;
							$errorMessage = "Warning, cannot create folder for temporary copy.";
							break;
						}
					}
					if(!$this->isWriteable($destCopy)){
						AJXP_Logger::debug("Upload error: cannot write into temporary folder");
						$errorCode = 414;
						$errorMessage = "Warning, cannot write into temporary folder.";
						break;
					}
					AJXP_Logger::debug("Upload : tmp upload folder", array($destCopy));
					if(isSet($boxData["input_upload"])){
						try{
							$destName = tempnam($destCopy, "");
							AJXP_Logger::debug("Begining reading INPUT stream");
							$input = fopen("php://input", "r");
							$output = fopen($destName, "w");
							$sizeRead = 0;
							while($sizeRead < intval($boxData["size"])){
								$chunk = fread($input, 4096);
								$sizeRead += strlen($chunk);
								fwrite($output, $chunk, strlen($chunk));
							}
							fclose($input);
							fclose($output);
							$boxData["tmp_name"] = $destName;
							$this->storeFileToCopy($boxData);
							AJXP_Logger::debug("End reading INPUT stream");
						}catch (Exception $e){
							$user->saveTemporaryData("tmpUpload",array());
							$errorCode=411;
							$errorMessage = $e->getMessage();
							break;
						}
					}else{
						$destName = $destCopy."/".basename($boxData["tmp_name"]);
						if ($destName == $boxData["tmp_name"]) $destName .= "1";
						if(move_uploaded_file($boxData["tmp_name"], $destName)){
							$boxData["tmp_name"] = $destName;
							$this->storeFileToCopy($boxData);
						}else{
							$mess = ConfService::getMessages();
							$errorCode = 411;
							$errorMessage="$mess[33] ".$boxData["name"];
							break;
						}
					}
				}
				if(isSet($errorMessage)){
					AJXP_Logger::debug("Return error $errorCode $errorMessage");
					return array("ERROR" => array("CODE" => $errorCode, "MESSAGE" => $errorMessage));
				}else{
					AJXP_Logger::debug("Return success");
					return array("SUCCESS" => true);
				}

			break;
			default:
			break;
		}
		session_write_close();
		exit;

	}

	public function isWriteable($path, $type="dir"){
		// We consider that every user connected has the right to write a folder he can browse
		return true;

	}

	function deldir($location)
	{
		if(is_dir($location))
		{
			$dirsToRecurse = array();
			$all=opendir($location);
			while ($file=readdir($all))
			{
				if (is_dir("$location/$file") && $file !=".." && $file!=".")
				{
					$dirsToRecurse[] = "$location/$file";
				}
				elseif (!is_dir("$location/$file"))
				{
					if(file_exists("$location/$file")){
						unlink("$location/$file");
					}
					unset($file);
				}
			}
			closedir($all);
			foreach ($dirsToRecurse as $recurse){
				$this->deldir($recurse);
			}
			rmdir($location);
		}
		else
		{
            if(file_exists("$location")) {
                AJXP_Logger::debug('Location : ', $location);
				$test = unlink($location);
				if(!$test) throw new Exception("Cannot delete file ".$location);
			}
		}
		if(basename(dirname($location)) == $this->repository->getOption("RECYCLE_BIN"))
		{
			// DELETING FROM RECYCLE
			RecycleBinManager::deleteFromRecycle($location);
		}
	}


    function storeFileToCopy($fileData){
            $user = AuthService::getLoggedUser();
            $files = $user->getTemporaryData("tmp_upload");
            AJXP_Logger::debug("Saving user temporary data", array($fileData));
            $files[] = $fileData;
            $user->saveTemporaryData("tmp_upload", $files);
    }

    function getFileNameToCopy(){
            $user = AuthService::getLoggedUser();
            $files = $user->getTemporaryData("tmp_upload");
            return $files[0]["name"];
    }

    function getNextFileToCopy(){
            if(!$this->hasFilesToCopy()) return "";
            $user = AuthService::getLoggedUser();
            $files = $user->getTemporaryData("tmp_upload");
            $fData = $files[0];
            array_shift($files);
            $user->saveTemporaryData("tmp_upload", $files);
            return $fData;
    }

    function hasFilesToCopy(){
            $user = AuthService::getLoggedUser();
            $files = $user->getTemporaryData("tmp_upload");
            return (count($files)?true:false);
    }


    function filterNodeName($nodePath, $nodeName, &$isLeaf, $lsOptions){
        $isLeaf = false;
            if(is_file($nodePath."/".$nodeName."/") || AJXP_Utils::isBrowsableArchive($nodeName)){
                // We check if the node isn't a link
                if(is_link($nodePath."/".$nodeName."/")){
                    $link = readlink($nodePath."/".$nodeName);
                }
                $isLeaf = true;
            }
            if(AJXP_Utils::isHidden($nodeName) && !$this->driverConf["SHOW_HIDDEN_FILES"]){
                return false;
            }
            $nodeType = "d";
            if($isLeaf){
            if(AJXP_Utils::isBrowsableArchive($nodeName)) $nodeType = "z";
                else $nodeType = "f";
            }
            if(!$lsOptions[$nodeType]) return false;
            if($nodeType == "d"){
                if(RecycleBinManager::recycleEnabled() && $nodePath."/".$nodeName == RecycleBinManager::getRecyclePath()){
                    return false;
                    }
                return !$this->filterFolder($nodeName);
            }else{
                if($nodeName == "." || $nodeName == "..") return false;
                if(RecycleBinManager::recycleEnabled() && $nodePath == RecycleBinManager::getRecyclePath() && $nodeName == RecycleBinManager::getCacheFileName()){
                    return false;
                }
                return !$this->filterFile($nodeName);
            }
    }

    function dircopy($srcdir, $dstdir, &$errors, &$success, $verbose = false, $convertSrcFile = true)
    // FIXME: Anomalie #6628 (http://dev-eole.ac-dijon.fr/issues/6628)
    {
        $num = 0;
        //$verbose = true;
        if($verbose)
            AJXP_Logger::debug("dircopy de ... vers ...", array($srcdir, $dstdir));
        $recurse = array();
        if(!is_dir($dstdir)) mkdir($dstdir);
        if($curdir = opendir($srcdir))
        {
            while($file = readdir($curdir))
            {
                if($file != '.' && $file != '..')
                {
                    $srcfile = $srcdir . "/" . $file;
                    $dstfile = $dstdir . "/" . $file;
                    if(is_file($srcfile))
                    {
                        if(is_file($dstfile)) $ow = filemtime($srcfile) - filemtime($dstfile); else $ow = 1;
                        if($ow > 0)
                        {
                            try {
                                if($convertSrcFile) $tmpPath = call_user_func(array($this->wrapperClassName, "getRealFSReference"), $srcfile);
                                else $tmpPath = $srcfile;
                                if($verbose)
                                    AJXP_Logger::debug("Copie de ... vers ...", array($tmpPath, $dstfile));
                                copy($tmpPath, $dstfile);
                                $success[] = $srcfile;
                                $num ++;
                                $this->changeMode($dstfile);
                            }catch (Exception $e){
                                $errors[] = $srcfile;
                            }
                        }
                    }
                    else{
                        $recurse[] = array("src" => $srcfile, "dest"=> $dstfile);
                    }
                }
            }
            closedir($curdir);
            foreach($recurse as $rec){
                if($verbose)
                    AJXP_Logger::debug("Dircopy", $srcfile);
                $num += $this->dircopy($rec["src"], $rec["dest"], $errors, $success, $verbose, $convertSrcFile);
            }
        }
        return $num;
    }

   function makeZip ($src, $dest, $basedir)
    // FIXME: Anomalie #6628 (http://dev-eole.ac-dijon.fr/issues/6628)
    {
        @set_time_limit(0);
        // Création d'un répertoire temporaire local
        $loggedUser = AuthService::getLoggedUser();
        $tmp_zip_dir = AJXP_Utils::getAjxpTmpDir()."/".($loggedUser?$loggedUser->getId():"shared")."_".time()."_tmpZipDir";
        mkdir($tmp_zip_dir);

        require_once(AJXP_BIN_FOLDER."/pclzip.lib.php");
        $filePaths = array();
        foreach ($src as $item){
            // Copy des éléments à zipper dans le répertorie temporaire
            $realFile = $this->urlBase.$item;
            //AJXP_Logger::debug('class.ftpCasAccessDriver.php/makeZip $realFile $item', array($realFile, $item)); // PR
            if (is_file($realFile))
                copy($realFile, $tmp_zip_dir."/".basename($item));
            else
                $nb_dircopy = $this->dircopy($realFile, $tmp_zip_dir."/".basename($item), $errors, $success);

            $filePaths[] = array(PCLZIP_ATT_FILE_NAME => $tmp_zip_dir."/".basename($item),
                                 PCLZIP_ATT_FILE_NEW_SHORT_NAME => basename($item));
        }

        $basedir = $tmp_zip_dir;

        AJXP_Logger::debug("Pathes", $filePaths);
        AJXP_Logger::debug("Basedir", array($basedir));
        self::$filteringDriverInstance = $this;
        $archive = new PclZip($dest);
        $vList = $archive->create($filePaths, PCLZIP_OPT_REMOVE_PATH, $basedir, PCLZIP_OPT_NO_COMPRESSION, PCLZIP_OPT_ADD_TEMP_FILE_ON, PCLZIP_CB_PRE_ADD, 'zipPreAddCallback');
        $this->deldir($tmp_zip_dir); // Suppression du répertoire temporaire

        if(!$vList){
            throw new Exception("Zip creation error : ($dest) ".$archive->errorInfo(true));
        }
        self::$filteringDriverInstance = null;
        return $vList;
    }

}
?>
