#!/usr/bin/env python
"""Restaure un fichier ou un repertoire passe en argument"""
from pyeole.bacularestore import bacula_restore_one_file, exit_if_running_jobs
import sys

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """file helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
        else:
            if test_jobs:
                exit_if_running_jobs()
            job(option, jobid)

    else:
        print "Il faut specifier le fichier ou repertoire a restaurer"
        sys.exit(1)

def pre():
    print "pre file"

def post():
    print "post file"

def job(filename, jobid):
    print "Restauration de {0}".format(filename)
    bacula_restore_one_file(filename, jobid)


priority=0
