
-- add missing foreign keys in Bareos tables
ALTER TABLE File ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE File ADD FOREIGN KEY (PathId) REFERENCES Path(PathId);
ALTER TABLE File ADD FOREIGN KEY (FilenameId) REFERENCES Filename(FilenameId);
ALTER TABLE RestoreObject ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE Device ADD FOREIGN KEY (MediaTypeId) REFERENCES MediaType(MediaTypeId);
ALTER TABLE Device ADD FOREIGN KEY (StorageId) REFERENCES Storage(StorageId);
ALTER TABLE Job ADD FOREIGN KEY (ClientId) REFERENCES Client(ClientId);
ALTER TABLE Job ADD FOREIGN KEY (PoolId) REFERENCES Pool(PoolId);
ALTER TABLE Job ADD FOREIGN KEY (FileSetId) REFERENCES FileSet(FileSetId);
ALTER TABLE Job ADD FOREIGN KEY (PriorJobId) REFERENCES Job(JobId);
ALTER TABLE LocationLog ADD FOREIGN KEY (MediaId) REFERENCES Media(MediaId);
ALTER TABLE LocationLog ADD FOREIGN KEY (LocationId) REFERENCES Location(LocationId);
ALTER TABLE JobMedia ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE JobMedia ADD FOREIGN KEY (MediaId) REFERENCES Media(MediaId);
ALTER TABLE Media ADD FOREIGN KEY (PoolId) REFERENCES Pool(PoolId);
ALTER TABLE Media ADD FOREIGN KEY (MediaTypeId) REFERENCES MediaType(MediaTypeId);
ALTER TABLE Media ADD FOREIGN KEY (StorageId) REFERENCES Storage(StorageId);
ALTER TABLE Media ADD FOREIGN KEY (DeviceId) REFERENCES Device(DeviceId);
ALTER TABLE Media ADD FOREIGN KEY (LocationId) REFERENCES Location(LocationId);
ALTER TABLE Media ADD FOREIGN KEY (ScratchPoolId) REFERENCES Pool(PoolId);
ALTER TABLE Media ADD FOREIGN KEY (RecyclePoolId) REFERENCES Pool(PoolId);
ALTER TABLE Pool ADD FOREIGN KEY (ScratchPoolId) REFERENCES Pool(PoolId);
ALTER TABLE Pool ADD FOREIGN KEY (RecyclePoolId) REFERENCES Pool(PoolId);
ALTER TABLE Pool ADD FOREIGN KEY (NextPoolId) REFERENCES Pool(PoolId);
ALTER TABLE Log ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE BaseFiles ADD FOREIGN KEY (BaseJobId) REFERENCES Job(JobId);
ALTER TABLE BaseFiles ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE BaseFiles ADD FOREIGN KEY (FileId) REFERENCES File(FileId);
ALTER TABLE UnsavedFiles ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE UnsavedFiles ADD FOREIGN KEY (PathId) REFERENCES Path(PathId);
ALTER TABLE UnsavedFiles ADD FOREIGN KEY (FilenameId) REFERENCES Filename(FilenameId);
ALTER TABLE NDMPLevelMap ADD FOREIGN KEY (ClientId) REFERENCES Client(ClientId);
ALTER TABLE NDMPLevelMap ADD FOREIGN KEY (FileSetId) REFERENCES FileSet(FileSetId);
ALTER TABLE NDMPJobEnvironment ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE DeviceStats ADD FOREIGN KEY (DeviceId) REFERENCES Device(DeviceId);
ALTER TABLE DeviceStats ADD FOREIGN KEY (MediaId) REFERENCES Media(MediaId);
ALTER TABLE JobStats ADD FOREIGN KEY (DeviceId) REFERENCES Device(DeviceId);
ALTER TABLE JobStats ADD FOREIGN KEY (JobId) REFERENCES Job(JobId);
ALTER TABLE TapeAlerts ADD FOREIGN KEY (DeviceId) REFERENCES Device(DeviceId);
