#!/usr/bin/python3
# -*- coding: utf-8 -*-

import re
from pyeole.process import system_out
from pickle import dump, load
from datetime import datetime

BCONSOLE_CONF = '/etc/bareos/bconsole.conf'
BAREOS_RAPPORT_FSL = '/var/lib/eole/reports/resultat-bareos-freespace'

def sizeof_fmt(num, suffix='B'):
    for unit in ['','Ki','Mi','Gi','Ti','Pi','Ei','Zi']:
        if abs(num) < 1024.0:
            return "%3.1f%s%s" % (num, unit, suffix)
        num /= 1024.0
    return "%.1f%s%s" % (num, 'Yi', suffix)

def run_bareos_cmd(stdin):
    cmd = ['bconsole', '-c', BCONSOLE_CONF]
    return system_out(cmd, stdin=stdin)


def test_space_left():
    for line in run_bareos_cmd('estimate Job=JobSauvegarde')[1].split('\n'):
        estimate_output = re.search(r'^2000 OK.*bytes=(?P<size>[0-9]{1,3}(,[0-9]{3})*)', line)
        if estimate_output:
            size = estimate_output.group('size')
            break
    else:
        size = 'None'
    with open(BAREOS_RAPPORT_FSL, "w") as fh:
        fh.write(size)
        fh.write(" : ")
        fh.write(str(datetime.now()))
        fh.close()

test_space_left()
