#!/bin/bash


mode_conteneur_actif=$(CreoleGet mode_conteneur_actif)
container_path_postgresql=$(CreoleGet container_path_postgresql)
activer_bareos_dir=$(CreoleGet activer_bareos_dir)


function run_as()
{
    local user="$1"
    shift

    if [ "$mode_conteneur_actif" = "oui" ]; then
        CreoleRun "su - ${user} -c \"$@\"" postgresql
    else
        su - ${user} -c "$@"
    fi
    return $?
}

function db_exists()
{
    local DB_NAME="$1"
    run_as postgres "psql ${DB_NAME} -c '\q'" 2>&1
    return ${?}
}

function start_db()
{
    CreoleService postgresql@14-main start
    return $?
}

function stop_db()
{
    CreoleService postgresql@14-main stop
    return $?
}

function update_db_user_pass()
{
    user=$1
    pass=$2
    req="ALTER USER ${user} WITH PASSWORD \'${pass}\' \;"
    run_as postgres "echo ${req} | psql"
    return ${?}
}

#if database is already exists and noquestion set, do nothing
if [ ! -z $1 ]; then
    noquestion=1
    if [ "$1" = "noquestion" ]; then
        restart_database=1
    else
        extract_file=$1
    fi
fi

if [ "$noquestion" = "1" -o "$activer_bareos_dir" = "oui" ]; then
    . /usr/lib/eole/ihm.sh
    #(re)generation du catalog
    rep=0

    start_db

    res=$(db_exists bareos)
    if [ ${?} -eq 0 ]; then
        allready_generate=1
    fi

    if [ ! -z $allready_generate ]; then
        if [ "$noquestion" = "1" ]; then
            if [ ! -z $extract_file ]; then
                rep=0
            else
                rep=1
            fi
        else
            Question_ouinon "La régénération du catalogue de la sauvegarde va écraser l'ancienne base, confirmez-vous ?" "$interactive" 'non' 'warn'
            rep=$?
        fi
    fi
    if [ "$rep" = "0" ]; then
        echo
        echo "## Régénération du catalogue Bareos##"
        if [ -z $restart_database ]; then
            CreoleService bareos-director stop
            CreoleService bareos-storage stop
        fi

        [ ! -z $allready_generate ] && run_as postgres /usr/lib/bareos/scripts/drop_bareos_database
        run_as postgres "/usr/lib/bareos/scripts/create_bareos_database $options"
        run_as postgres "/usr/lib/bareos/scripts/make_bareos_tables $options"
        run_as postgres "/usr/lib/bareos/scripts/grant_bareos_privileges $options"

        if [ ! -z $extract_file ]; then
            if [ "$mode_conteneur_actif" = "oui" ]; then
                extract_filename=$(basename $extract_file)
                cp -a $extract_file $container_path_postgresql/home/$extract_filename
                CreoleRun "chgrp postgres /home/$extract_filename" postgresql
                run_as postgres "psql $options bareos < /home/$extract_filename"
                rm -f $container_path_postgresql/home/$extract_filename
            else
                chgrp postgres $extract_file
                run_as postgres "psql $options bareos < $extract_file"
                chgrp root $extract_file
            fi
        fi
        regen_user_bdd=1
        need_startstop=1

        stop_db
    else
        if [ -z $restart_database ]; then
            exit 0
        fi
        #regarde s'il y a un mot de passe à l'utilisateur bareos
        if [ ! -z $restart_database ]; then
            start_db
        fi
        echo "exit" | run_as postgres "psql -U bareos bareos" &> /dev/null
        [ $? -eq 0 ] && regen_user_bdd=1
        need_startstop=1
        stop_db
    fi
fi


# Update the DB schema
script_path=/usr/lib/bareos/scripts/update_bareos_tables
if [ "$activer_bareos_dir" = "oui" ] && [ -x $script_path ]
then
    need_startstop=1
    start_db
    echo "Mise à jour de la base de donnée Bareos... "
    run_as postgres $script_path
fi

# Update database user password

update_db_user_pass bareos $(CreoleGet bareos_db_password)

if [ "$need_startstop" = "1" ]; then
    echo "Régénération du catalogue terminée"
    echo "Suppression des anciens rapports d'état"
    sleep 5
    rm -f /var/lib/bareos/*.state
    if [ -z $restart_database ]; then
        CreoleService bareos-director start
        CreoleService bareos-storage start
    else
	stop_db
    fi
fi
