#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Description=Prparation stations intgration domaine EOLE/Scribe
#AutoIt3Wrapper_Res_Fileversion=0.1.1.6
#AutoIt3Wrapper_Res_Field=ProductName|Preparation (Rectorat de Besanon / DSI)
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=P
#AutoIt3Wrapper_Res_Language=1036
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#cs -----------------------------------------------------------------------------------------------------------------------------------

AutoIt Version....: v3.3.4.0
Auteur	..........: Valry Georges juin 2011
Fonction..........: Tester et de pr-configurer n'importe quelle station windows XP, Vista, Seven
					en vue de l'intgrer  un domaine scribe en un minimum de clic.

#ce ------------------------------------------------------------------------------------------------------------------------------------
#Include <String.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <Date.au3>
#include <File.au3>
#include <Constants.au3>
#include <Array.au3>
#include <WinAPI.au3>

;---------------------------------------------------------------------------------------------------------------------------------------
; Dfinition des variables globales
;---------------------------------------------------------------------------------------------------------------------------------------
Global $Version = FileGetVersion(@ScriptFullPath)
;Mode debug (0 = les infos DEBUG ne sont pas journalises, 1=toutes les infos sont journalises)
Global $Debug_Level=1
;Mot de passe d'encryptage des mots de passe
Global $Mp_Encrypt="seven2scribe2012"
;Chemin du fichier journal
Global $Log_File = @ScriptDir & "\Preparation_"&@ComputerName&".log"
;Chemin du fichier des paramtres modifiables
Global $Ini_File
;Chemin du fichier des paramtres utilis par IntegrDom
Global $Txt_File=@ScriptDir&"\ParamIntegr.txt"

;Tableau des paramtres
;structure = "Description","nom_paramtres","valeur_defaut","Cryptage"
Dim $Ini_Data_Defaut[8][4] = [["", ""], _
	["Nom du serveur","serveur", "","NO_ENCRYPT"], _
	["Adresse IP","adresse_ip", "","NO_ENCRYPT"], _
	["Nom du domaine","domaine", "","NO_ENCRYPT"], _
	["Administrateur du domaine", "Ud_admin_dom","admin","NO_ENCRYPT"], _
	["Mot de passe", "Mp_admin_dom","","ENCRYPT"], _
	["Administrateur local","Ud_admin_local", "administrateur","NO_ENCRYPT"], _
	["Mot de passe Administrateur local", "Mp_admin_local","","ENCRYPT"]]
Global $Ini_Data_New[8][2]
;Liste des utilisateurs autoriss  rejoindre le domaine
Global $Liste_User_Auth[2]=["ADMIN","RAIP"]
;Liste des cls de registre Vista Seven  prconfigurer
Global $Reg_Key_V7[8][5]=[["Compatibilit Samba","HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\LanManWorkstation\Parameters","DomainCompatibilityMode","REG_DWORD","00000001"], _
	["Compatibilit Samba","HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\LanManWorkstation\Parameters","DNSNameResolutionRequired","REG_DWORD","00000000"], _
	["Dsactivation de l'UAC","HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System","EnableLUA","REG_DWORD","00000000"], _
	["Dsactivation de l'UAC","HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System","ConsentPromptBehaviorAdmin","REG_DWORD","00000000"], _
	["Dsactivation de l'UAC","HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System","PromptOnSecureDesktop","REG_DWORD","00000000"], _
	["Dsactivation de l'UAC","HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System","dontdisplaylastusername","REG_DWORD","00000001"], _
	["Compatibilit NTLM","HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Lsa","LmCompatibilityLevel","REG_DWORD","00000001"], _
	["Dlais d'attente du profil","HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\System","WaitForNetwork","REG_DWORD","00000001"]]
;Visibilit de la GUI (1= visible ; 0 = mode unattended)
Global $Gui_Visible

;---------------------------------------------------------------------------------------------------------------------------------------
; Dfinition de la GUI
;---------------------------------------------------------------------------------------------------------------------------------------
Opt("GUIOnEventMode", 0)
$Gui_Principale = GUICreate("Prparation station scribe v"&$Version, 319, 199, 293, 115)

$Lb_Nom = GUICtrlCreateLabel("Nom de la station", 86, 0, 149, 28)
	GUICtrlSetFont($Lb_Nom, 14, 400, 0, "MS Sans Serif")
$In_nom_station = GUICtrlCreateInput(@ComputerName, 72, 48, 177, 28, BitOR($ES_CENTER,$ES_UPPERCASE,$ES_AUTOHSCROLL))
    GUICtrlSetLimit($In_nom_station, 13)
	GUICtrlSetFont($In_nom_station, 12, 400, 0, "MS Sans Serif")
$Bt_Appliquer = GUICtrlCreateButton("Appliquer", 80, 144, 161, 41, 0)
	GUICtrlSetFont($Bt_Appliquer, 10, 800, 0, "MS Sans Serif")
$Bt_Parametres = GUICtrlCreateButton("Paramtres", 80, 90, 161, 41, 0)
	GUICtrlSetFont($Bt_Parametres, 10, 800, 0, "MS Sans Serif")
$Lb_exemple = GUICtrlCreateLabel("Pensez  normaliser le nom de cette machine !", 10, 24, 283, 17,$ES_CENTER)

;---------------------------------------------------------------------------------------------------------------------------------------
; INITIALISATIONS
;---------------------------------------------------------------------------------------------------------------------------------------
_Init_Journal($Log_File)
_Test_droits()
_Initialisation()


;---------------------------------------------------------------------------------------------------------------------------------------
; Visibilit de la GUI
; La GUI n'est pas visible si un paramtre existe en ligne de commande
; ET si ce paramtre correspond  un fichier INI existant et valide.
;---------------------------------------------------------------------------------------------------------------------------------------
If $Gui_Visible=1 then
	_Wlog("add","[Initialisation] : INFO : Affichage de la GUI principale")
	GUISetState(@SW_SHOW)
Else
	_Wlog("add","[Initialisation] : INFO : Pas de GUI, on lance la prparation directement (mode unattended)")
	$Ini_Data_New=_Array_Encrypt(0,_Lire_parametres_ini($Ini_File))
	_Preparation($Ini_Data_New)
EndIf

;---------------------------------------------------------------------------------------------------------------------------------------
; Boucle d'attente des venements de la GUI
;---------------------------------------------------------------------------------------------------------------------------------------
_Wlog("add+","[Boucle d'attente] : INFO : Attente clic bouton Paramtres, Appliquer ou Quitter")
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $Bt_Parametres
			_Wlog("add","[Boucle d'attente] : INFO : L'utilisateur clic sur le bouton #Paramtres#")
			If not FileExists($Ini_File) then
				_Wlog("add","[Boucle d'attente] : INFO : Mise  jour des paramtres par dfaut avec les valeurs de paramIntegr.txt")
				_Recup_param($Txt_File)
				_Wlog("add","[Boucle d'attente] : INFO : Cration d'un fichier de paramtres  partir des valeurs par dfaut : "&$Ini_File)
				$Ini_Data_New=_Array_transpose($Ini_Data_Defaut)
				_Wlog("add","[Boucle d'attente] : INFO : Rcupration des paramtres saisis en clair")
				$Ini_Data_New=_Saisir_parametres($Ini_File,$Ini_Data_New)
				_Wlog("add","[Boucle d'attente] : INFO : Encryptage et enregistrement des paramtres saisis")
				_Enregistrer_parametres($Ini_File,_Array_Encrypt(1,$Ini_Data_New))
				GUICtrlSetState($Bt_Appliquer,$GUI_ENABLE)
			Else
				_Wlog("add","[Boucle d'attente] : INFO : Modification des paramtres existants")
				_Wlog("add","[Boucle d'attente] : INFO : Lecture du fichier de paramtres existants")
				$Ini_Data_New=_Array_Encrypt(0,_Lire_parametres_ini($Ini_File))
				_Wlog("add","[Boucle d'attente] : INFO : Rcupration des paramtres saisis en clair (en cas de modification)")
				$Ini_Data_New=_Saisir_parametres($Ini_File,$Ini_Data_New)
				_Wlog("add","[Boucle d'attente] : DEBUG : Encryptage et enregistrement des paramtres saisis")
				_Enregistrer_parametres($Ini_File,_Array_Encrypt(1,$Ini_Data_New))
				GUICtrlSetState($Bt_Appliquer,$GUI_ENABLE)
			EndIf
		Case $msg=$Bt_Appliquer
			_Wlog("add","[Boucle d'attente] : INFO : L'utilisateur clic sur le bouton #Appliquer#")
			$Ini_Data_New=_Array_Encrypt(0,_Lire_parametres_ini($Ini_File))
			_Preparation($Ini_Data_New)
		Case $msg=$GUI_EVENT_CLOSE
			_Wlog("add","[Boucle d'attente] : INFO : L'utilisateur clic sur le bouton #Quitter#")
			_Finir()
	EndSelect
WEnd
;---------------------------------------------------------------------------------------------------------------------------------------
;---------------------------------------------------------------------------------------------------------------------------------------

;*********************
;*********************
;** Les Fonctions   **
;*********************
;*********************
;---------------------------------------------------------------------------------------------------------------------------------------
; _Init_Journal :
; Initialisation du journal
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Init_Journal($fichier)
	If _Wlog("init",@ScriptName&" : Initialisation du journal",$fichier) Then
		Return
	Else
		MsgBox(0,"Erreur (_Init)","Impossible de crer le fichier journal."&@CRLF&"Droits insuffisants ou chemin introuvable",10)
		Exit(1)
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Wlog($fichier)
;  Initialise ou ajoute des commentaires dans un fichier journal
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Wlog($commande,$texte,$fichier=$Log_File)
	Switch $commande
		case "init"
			Local $currentDate = _DateTimeFormat(_NowCalc(), 2)
			Local $currentTime = _DateTimeFormat(_NowCalc(), 5)
			Local $f_log = FileOpen($fichier, 2)
			if @error then Return 0
			FileWriteLine($f_log,"")
			FileWriteLine($f_log," ___________________")
			FileWriteLine($f_log,"|                   |")
			FileWriteLine($f_log,"|     JOURNAL       |")
			FileWriteLine($f_log,"|___________________|")
			FileWriteLine($f_log,"")
			FileWriteLine($f_log,"Informations de dboggage du script : "&$texte)
			FileWriteLine($f_log,"------------------------")
			FileWriteLine($f_log,"-> Dernier lancement le " & $currentDate & "  " & $currentTime)
			FileClose($f_log)
			Return 1
		case "add"
			If $Debug_Level=0 and StringInStr($texte,"DEBUG")<>0 then Return 1
			Local $f_log = FileOpen($fichier, 1)
			FileWriteLine($f_log, $texte)
			FileClose($f_log)
			Return 1
		case "add+"
			Local $f_log = FileOpen($fichier, 1)
			FileWriteLine($f_log, @CRLF)
			FileWriteLine($f_log, $texte)
			FileClose($f_log)
			Return 1
	EndSwitch
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Message($id_erreur_ou_message_clair,$action,$tempo)
;  Affiche un message d'erreur en clair ou selon un numro durant $tempo secondes
;  Se termine par une sortie de programme ou un return
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Message($id_message,$action="Return",$tempo=1000)

	;Dfinition des variables locales
	Local $texte

	;Conversion de l'Id d'erreur en message clair, si Id est inconnu il est affich tel quel
	Switch $id_message
		Case "100"
			$texte="[ERREUR] Architecture du systme d'exploitation incompatible : "&@CRLF&_OS_Type()&" Architecture : "&@OSArch
		Case "110"
			$texte="[ERREUR] Systme d'exploitation incompatible : "&@CRLF&_OS_Type()&" Architecture : "&@OSArch
		Case "120"
			$texte="[ERREUR] Le nom de l'ordinateur est trop long (14 caractres maxi)"
		Case "130"
			$texte="[ERREUR] Le nom de l'ordinateur contient un ou plusieurs caractre(s) interdit(s)"
		Case "140"
			$texte="[ERREUR] Le serveur n'est pas joignable"&@CRLF&"Vrifier le cblage et l'tat du serveur DHCP"
		case "150"
			$texte="[ERREUR] Fichier de paramtres : Nom de paramtres incorrect, ou valeurs manquantes"
		case "151"
			$texte="[ERREUR] Fichier de paramtres : Fichier introuvable"
		case "152"
			$texte="[ERREUR] Fichier de paramtres : Impossible d'enregistrer le fichier (droits insuffisants)"
		case "153"
			$texte="[ERREUR] Initialisation : Vous devez excuter ce programme en tant qu'administrateur (bouton droit)"
		case "160"
			$texte="[ERREUR] L'utilisateur qui lance ce script doit faire partie d'un groupe autoris"
		case "170"
			$texte="[ERREUR] Impossible de trouver le dossier d'installation"
		case "180"
			$texte="[ERREUR] Impossible de copier les fichiers netdom dans le dossier systme de windows"
		case "190"
			$texte="[ERREUR] Impossible d'ajouter ou de modifier la cl de registre"
		case "200"
			$texte="[ERREUR] Script lanc avec paramtre code_phase inconnu"
		case "210"
			$texte="[ERREUR] Impossible de renommer l'ordinateur"
		case "220"
			$texte="[ERREUR] Impossible de configurer l'autologon"
		case "230"
			$texte="[ERREUR] Impossible de monter la station sur le domaine"
		case "240"
			$texte="[ERREUR] Impossible de redescendre la station en Workgroup"
		case "250"
			$texte="[ERREUR] La station fait dj partie d'un domaine"
		case "260"
			$texte="[ERREUR] Fichier de paramtres : ParamIntegr.txt illisible ou introuvable"
		Case Else
			Return
	EndSwitch

	;Affichage des message d'erreur qui peuvent provoquer la sortie du programme
	_Splash("off","Opration","[ERREUR]"&@LF)
	MsgBox(64,"Erreur (_Message)",$texte,10)

	;Si l'argument contient "exit" le programme s'arrte
	If $action="Exit" then
		_Wlog("add+","[_Message] : INFO : "&$texte&", (action=close)")
		_Erreur("Contexte d'excution incompatible")
	Else
		_Wlog("add+","[_Message] : INFO : "&$texte&", (action=return)")
		Return
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Splash($action,$titre,$texte)
;  Affiche un message en splash selon $action
;  $titre = titre de la fentre splash
;  on : ouvre une fentre splash et affiche le messsage
;  add : ajoute un message dans le splash existant
;  off : Ferme le splash
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Splash($action,$titre,$texte)
	Select
		Case $action="on"
			;Ouverture d'une fentre splash
			_Wlog("add","[_Splash] : DEBUG : Ouverture d'un splash : "&$texte)
			SplashTextOn($titre,$texte,-1, -1, -1, -1, 4, "Courier New")
			sleep(1000)
		Case $action="add"
			;Ajout d'une ligne dans le splash
			_Wlog("add","[_Splash] : DEBUG : Ajout dans le splash : "&$titre)
			ControlSetText($titre, "", "Static1", ControlGetText($titre, "", "Static1")&$texte)
			sleep(500)
		Case $action="off"
			_Wlog("add","[_Splash] : DEBUG : Fermeture du splash : "&$texte)
			ControlSetText($titre, "", "Static1", ControlGetText($titre, "", "Static1")&$texte)
			sleep(1500)
			SplashOff()
		case Else
			_Wlog("add","[_Splash] : ERREUR : Mauvais paramtre lors de l'appel de la fonction splash")
	EndSelect
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_droits()
;  Test si l'utilisateur possde des droits d'administrateur rls
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_droits()

	_Wlog("add+","[_Test_droits] : INFO : Est-ce que les droits sont suffisants ?")

	If not IsAdmin() Then
		_Wlog("add","[_Test_droits] : ERREUR : Droits insuffissant, return=exit")
		_Message(153,"Exit")
	Else
		_Wlog("add","[_Test_droits] : INFO : Les droits de l'utilisateur sont suffisants, on continue...")
	EndIf

EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Recup_Param($fichier)
;  Test la prsence du fichier de paramtres et renseigne le tableau des paramtres par dfaut
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Recup_param($fichier)

	_Wlog("add+","[_Recup_param] : INFO : Rcupration des valeurs du fichier de paramtres IntegrDom")

	Local $array[1]

	;Si paramintegr n'existe pas...
	_Wlog("add","[_Recup_param] : DEBUG : Test de l'existence du fichier paramintegr.txt")
	If not FileExists($fichier) Then
		_Wlog("add","[_Recup_param] : ERREUR : Le fichier de paramtre d'integrDom est introuvable, sortie=Exit")
		_Message(260,"Exit")
	EndIf

	;Ouverture du fichier paramintegr en mode lecture
	_Wlog("add","[_Recup_param] : DEBUG : Tentative d'ouverture du fichier en lecture")
	$fic=FileOpen($fichier,0)
	If @error=-1 Then
		_Wlog("add","[_Recup_param] : ERREUR : Le fichier de paramtre d'integrDom n'est pas lisible, sortie=Exit")
		_Message(260,"Exit")
	EndIf

	;Lecture des valeurs et stockage dans $array et fermeture du fichier
	_Wlog("add","[_Recup_param] : DEBUG : Lecture des paramtres")
	While 1
		$param = FileReadLine($fic)
		If @error = -1 Then ExitLoop
		_Wlog("add","[_Recup_param] : DEBUG : Ajout de "&$param&" dans le tableau")
		_ArrayAdd($array,$param)
	Wend
	_Wlog("add","[_Recup_param] : DEBUG : Femeture du fichier")
	FileClose($fic)
	;_ArrayDisplay($array)

	_Wlog("add","[_Recup_param] : DEBUG : Insertion des valeurs dans le tableau de paramtres par dfaut")
	For $i=1 to UBound($array)-2
		$Ini_Data_Defaut[$i][2]=$array[$i]
	Next
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Initialisation()
;  Analyse la ligne de commande
;  Vrifie la prsence et la structure du fichier de paramtre
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Initialisation()

	Local $ini_ok,$param_ok

	_Wlog("add+","[Initialisation] : INFO : Paramtres en ligne de commande ?")
	If $CmdLine[0]<>0 Then
		_Wlog("add","[Initialisation] : INFO : Excution en mode unattended (pas de GUI)")
		_Wlog("add","[Initialisation] : INFO : Dtermination du fichier de paramtres")
		$Ini_File=_Get_IniFileName()
		_Wlog("add","[Initialisation] : DEBUG : Fichier de paramtres = "&$Ini_File)
		If not FileExists($Ini_File) then _Message(151,"Exit")
		If not _Is_Ini_OK($Ini_File) then _Message(150,"Exit")
		If not _Is_Parametres_OK($Ini_File) Then _Message(150,"Exit")
		_Wlog("add","[Initialisation] : INFO : OK, fichier de paramtres corrects, on continue...")
		$Gui_Visible=0
	Else
		_Wlog("add","[Initialisation] : INFO : Excution en mode GUI")
		$Ini_File=@ScriptDir & "\config.ini"
		_Wlog("add","[Initialisation] : DEBUG : Fichier de paramtres ="&$Ini_File)
		$Gui_Visible=1
		If FileExists($Ini_File) Then
			_Wlog("add","[Initialisation] : DEBUG : Le fichier "&$Ini_File&" existe")
			;Tests sur le fichier de paramtres...
			$ini_ok=_Is_Ini_OK($Ini_File)
			$param_ok=_Is_Parametres_OK($Ini_File)
			If $ini_ok and $param_ok Then
				_Wlog("add","[Initialisation] : DEBUG : OK, fichier de paramtres correct, on continue...")
				_Wlog("add","[Initialisation] : DEBUG : Bouton Appliquer = ACTIVE")
				GUICtrlSetState($Bt_Appliquer,$GUI_ENABLE)
			Else
				if not $ini_ok then
					_Wlog("add","[Initialisation] : ERREUR : Structure du fichier de paramtre incorrecte ou valeur manquante, sortie=exit")
					GUICtrlSetState($Bt_Appliquer,$GUI_DISABLE)
					_Message(150,"Exit")
				EndIf

				if not $param_ok Then
					_Wlog("add","[Initialisation] : ERREUR : Nom de Paramtre incorrect ou valeur manquante dans le fichier de paramtres, sortie=exit")
					GUICtrlSetState($Bt_Appliquer,$GUI_DISABLE)
					_Message(150,"Exit")
				EndIf
			EndIf
		Else
			_Wlog("add","[Initialisation] : ERREUR : Le fichier de paramtres "&$Ini_File&" n'existe pas, il faut renseigner les paramtres")
			_Wlog("add","[Initialisation] : DEBUG : Bouton Appliquer = DESACTIVE")
			GUICtrlSetState($Bt_Appliquer,$GUI_DISABLE)
		EndIf
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Get_IniFile()
;  Renvoie le nom du fichier de paramtre indiqu en ligne de commande
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Get_IniFileName()
	Local $array, $type,$argument1
 	_Wlog("add+","[_Get_IniFileName] : INFO : Dtermination du nom et du chemin du fichier de paramtres")

	$argument1=$CmdLine[1]
	_Wlog("add","[_Get_IniFileName] : DEBUG : Au moins un argument dtect dans la ligne de commande")
	$type=_Type_Argument_1($argument1)
	Select
		case $type="Fichier"
			_Wlog("add","[_Get_IniFileName] : DEBUG : return="&@ScriptDir & "\"&$argument1)
			Return @ScriptDir & "\"&$argument1
		case $type="Chemin"
			_Wlog("add","[_Get_IniFileName] : DEBUG : return="&$argument1)
			Return $argument1
		case $type="Autre"
			_Wlog("add","[_Get_IniFileName] : INFO : On continue avec le nom de fichier ini par dfaut="&@ScriptDir & "\config.ini")
			Return @ScriptDir & "\config.ini"
	EndSelect
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Type_Argument_1()
;  Renvoie "Fichier" si le premier argument est un nom de fichier
;  Renvoie "Chemin" si le premier argument est un chemin de fichier
;  Renvoie "Erreur" si ce n'est ni l'un ni l'autre
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Type_Argument_1($argument1)

	Local $array
	_Wlog("add","[_Type_Argument1] : INFO : Traitement de l'argument 1 : "&$argument1)

	;Est-ce que l'argument contient bien un nom de fichier ini ?
	$array=StringSplit($argument1,".",1)
	If IsArray($array) Then
		;Est-ce que l'argument contient aussi un chemin ?
		$array=StringSplit($argument1,"\",1)
		If IsArray($array) Then
			;c'est un chemin
			_Wlog("add","[_Type_Argument1] : DEBUG : L'argument 1 contient aussi un chemin, return=Chemin")
			Return "Chemin"
		Else
			;c'est juste un nom de fichier ini
			_Wlog("add","[_Type_Argument1] : DEBUG : L'argument 1 ne contient qu'un nom de fichier ini, return=Fichier")
			Return "Fichier"
		EndIf
	Else
		;Erreur, ce n'est ni un chemin, ni un nom de fichier ini
		_Wlog("add","[_Type_Argument1] : DEBUG : L'argument 1 est indtermin, return=Autre")
		Return "Autre"
	EndIf

EndFunc


;---------------------------------------------------------------------------------------------------------------------------------------
; _Is_Ini_OK($filename)
;  Renvoie "1" si le fichier Ini existe et s'il possde une structure de type ini
;  Renvoie "0" si le fichier Ini n'existe pas ou si il est incorrect
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Is_Ini_OK($filename)

	local $section

	_Wlog("add","[_Is_Ini_OK] : INFO : Test si le fichier ini possde une structure reconnue")
	$section=IniReadSection($filename,"PARAMETRES")
	if @error Then
		_Wlog("add","[_Is_Ini_OK] : ERREUR : Le fichier ini ne possde pas la bonne structure")
		Return 0
	Else
		_Wlog("add","[_Is_Ini_OK] : INFO : OK, le fichier ini est correct, mais a ne garantit pas la validit des paramtres")
		Return 1
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Is_Parametres_OK($filename)
;  Renvoie "1" si tous les paramtres possdent une valeur non vide
;  Renvoie "0" si l'un des paramtres contient une valeur vide
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Is_Parametres_OK($filename)

	local $array,$nok=0

	_Wlog("add","[_Is_Parametres_OK] : INFO : Test des paramtres du fichier ini")
	$array=IniReadSection($filename,"PARAMETRES")

	;_ArrayDisplay($array)
	;_ArrayDisplay($Ini_Data_Defaut)

	;Contrle des paramtres et des valeurs
	for $i=1 to UBound($array)-1
		;Si valeur nulle...
		If $array[$i][1]="" then
			$nok=1
			_Wlog("add","[_Is_Parametres_OK] : ERREUR : La valeur du paramtre "&StringUpper($array[$i][0])&" n'est pas renseigne")
		EndIf
		;Si paramtre inconnu...
		If StringUpper($array[$i][0])<>StringUpper($Ini_Data_Defaut[$i][1]) then
			$nok=1
			_Wlog("add","[_Is_Parametres_OK] : ERREUR : Paramtre "&StringUpper($array[$i][0])&" non conforme")
		EndIf
	Next
	;Traitement des erreurs rencontres
	if $nok=1 Then
		Return 0
	Else
		Return 1
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Lire_parametres_ini($fic)
;  Lit les paramtres du fichier ini et les renvoie dans un tableau encrypt
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Lire_parametres_ini($fichier_ini)

	local $array

	_Wlog("add","[_Lire_parametres_ini] : INFO : Lecture du fichier ini")
	$array = IniReadSection($fichier_ini, "PARAMETRES")

	If IsArray($array) Then
		_Wlog("add","[_Lire_parametres_ini] : DEBUG : Retourne les paramtres encrypts lus, (action, return $tableau)")
		Return ($array)
	Else
		_Wlog("add","[_Lire_parametres_ini] : ERREUR : Fichier de paramtres incorrect, (action=message)")
		_Message(150,"Exit")
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Saisir_parametres()
;  Affiche une fentre de saisie des paramtres et enregistrement crypt des valeurs
;  La fonction est appel si clic bouton paramtres
;  Remarque : $array est un tableau dj encrypt
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Saisir_parametres($fichier_ini,$array)

	_Wlog("add+","[_Saisir_parametres] : INFO : Calculs de la fentre de saisie des paramtres")
	Local $nb_item=UBound($array)
	Local $largeur = 300, $hauteur_item=20, $offset_item=0, $top_item=8,$msg,$param,$nok
 	Local $hauteur = $nb_item*(2*$hauteur_item+$top_item+$offset_item)
	Dim $label[$nb_item],$items[$nb_item]

	_Wlog("add","[_Saisir_parametres] : INFO : Construction de la fentre")
	Global $Gui_Parametres = GUICreate("Paramtres", 300, $hauteur, -1, -1, -1, -1, $Gui_Principale)
	$Bt_Param_OK = GUICtrlCreateButton("Sauvegarder", 4, $hauteur-35, $largeur-4, 33, 0,$SS_CENTER)

	_Wlog("add","[_Saisir_parametres] : INFO : Affichage des items et des champs de saisie")
	For $i=1 to $nb_item-1
		$label[$i]= GUICtrlCreateLabel($Ini_Data_Defaut[$i][0]&" :", 20, $top_item+($i-1)*(2*$hauteur_item+$offset_item+$top_item), $largeur-40, $hauteur_item)
		GUICtrlSetFont(-1, 10, 800, 0, "MS Sans Serif")
 		If $Ini_Data_Defaut[$i][3]="ENCRYPT" then
 			$style=BitOR($SS_CENTER,$ES_PASSWORD)
 		Else
 			$style=$SS_CENTER
 		EndIf
		$items[$i]= GUICtrlCreateInput($array[$i][1], 20, $top_item+($i-1)*(2*$hauteur_item+$offset_item+$top_item)+$hauteur_item, $largeur-40, $hauteur_item,$style)
		GUICtrlSetFont(-1, 9, 800, 0, "MS Sans Serif")
	Next

	GUISetState(@SW_SHOW)

	_Wlog("add","[_Saisir_parametres] : INFO : Attente clic Bouton Sauvegarde ou Quitter")
	While 1
		$nok=0
		$msg = GUIGetMsg()
		Select
			Case $msg = $Bt_Param_OK or $msg=$GUI_EVENT_CLOSE
				_Wlog("add","[_Saisir_parametres] : INFO : L'utilisateur a cliqu sur #CROIX# ou sur #SAUVEGARDER#")
				_Wlog("add","[_Saisir_parametres] : INFO : Lecture des nouveaux paramtres saisis en clair")
				for $i=1 to $nb_item-1
					$array[$i][1]=GUICtrlRead($items[$i])
					if $array[$i][1]="" then $nok=1
				Next

				if $nok=1 Then
					_Wlog("add","[_Saisir_parametres] : ERREUR : Tous les champs n'ont pas t renseigns")
					MsgBox(0,"Erreur","Tous les champs n'ont pas t renseigns")
				Else
					_Wlog("add","[_Saisir_parametres] : INFO : Destruction de la fentre fille")
					GUIDelete($Gui_Parametres)
					ExitLoop
				EndIf
		EndSelect
	WEnd
	_Wlog("add","[_Saisir_parametres] : DEBUG : Sortie de la fonction,action=return")
	Return $array
EndFunc   ;==>Parametres

;---------------------------------------------------------------------------------------------------------------------------------------
; _Enregistrer_parametres($fichier_ini,$array)
;  Enregistre les paramtres saisis dans le fichier INI en encryptant les champs tagus pour l'tre.
;  Remarque : $array est un tableau dj encrypt
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Enregistrer_parametres($fichier_ini,$array)
	If not IsArray($array) then _Message("[_Enregistrer_parametres] : Erreur : paramtre $tableau incorrect","Exit")
	_Wlog("add","[Enregistrer_parametres] : INFO : Ecriture des paramtres encrypts dans le fichier ini : "&$fichier_ini)
	IniWriteSection($fichier_ini, "PARAMETRES", $array, 1)
	;If @error=0 then _Message(152,"Exit")
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Array_transpose($array)
;  Transpose les valeurs de _array_defaut dans la structure du tableau renvoy
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Array_transpose($array)

	Local $array_new[UBound($array)][2]

	_Wlog("add","[_Array_transpose] : INFO : Transposition du tableau fourni en paramtre")

	If not IsArray($array) then
		_Wlog("add+","[_Array_transpose] : ERREUR : array n'est pas un tableau")
		_Message("Erreur de transcription de tableau","Exit")
	EndIf

	For $i=1 to UBound($array)-1
		$array_new[$i][0]=$array[$i][1]
		$array_new[$i][1]=$array[$i][2]
	Next

	_Wlog("add","[_Array_transpose] : DEBUG : Retourne le tableau transpos, action=return")

	Return $array_new

EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Array_Encrypt($action,$array)
;  $action = 0 (dcrypte) 1 (encrypte)
;  $array = tableau 2D  encrypter |variable|valeur|
;  $Ini_Data_Defaut = tableau contenant la structure de rfrence |description|variable|valeur|encryptage|
;  Retourne un tableau 2D dcrypt
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Array_Encrypt($action, $array2enc)

	local $array=$array2enc

	For $i=1 to UBound($array2enc)-1
		;si le champ est cryptable et que sa valeur n'est pas vide...
		if $Ini_Data_Defaut[$i][3]="ENCRYPT" and $array2enc[$i][1]<>"" then $array[$i][1]=_StringEncrypt($action,$array2enc[$i][1],$Mp_Encrypt,2)
	Next

	Return $array
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Finir()
;  Quitter avec clic sur la croix suprieure
;  ou en cas d'erreur (_Erreur)
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Finir()
	_Wlog("add+","[_Finir] : FIN : cause=clic sur bouton quitter, (action = exit code erreur 0)")
	Exit(0)
EndFunc
; fermeture en cas d'erreur
Func _Erreur($texte)
	SplashOff()
	_Wlog("add+","[_Erreur] : ERREUR : "&$texte& ", (action = exit code erreur=1)")
	Exit(1)
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Lancer_Phase()
;  Lance les oprations en fonction du numro de phase
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Preparation($array)

	_Wlog("add+","[_Preparation] : INFO : Tests et prparation de la station")
	_Splash("on","Opration","1- TESTS DU CONTEXTE :"&@LF)

	;Dsactivation des boutons
	GUICtrlSetState($Bt_Appliquer,$GUI_DISABLE)
	GUICtrlSetState($Bt_Parametres,$GUI_DISABLE)

	;Rcupration des paramtres provenant du .ini
	Local $serveur=$array[1][1]
	Local $adresse_ip=$array[2][1]
	Local $domaine=$array[3][1]
	Local $ud_admin_dom=$array[4][1]
	Local $mp_admin_dom=$array[5][1]
	Local $ud_admin_local=$array[6][1]
	Local $mp_admin_local=$array[7][1]
	Local $os_station

	;Test de l'OS
	_Splash("add","Opration",">> Compatiblit de Windows :.........")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Test_OS")
	$os_station=_Test_OS()
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Test_OS")
	_Splash("add","Opration","[OK]"&@LF)

	;Test validit du nom netbios
	_Splash("add","Opration",">> Nom de l'ordinateur :.............")
	_Wlog("add","[_Preparation] : DEBUG : Lecture du nom de la station dans le champ de saisie")
	$nom_station_futur=GUICtrlRead($In_nom_station)
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Test_Nom_Netbios("&$nom_station_futur&")")
	_Test_Nom_Netbios($nom_station_futur)
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Test_Nom_Netbios")
	_Splash("add","Opration","[OK]"&@LF)

	;Test de l'utilisateur courant
	_Splash("add","Opration",">> Droits de l'utilisateur :.........")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Test_User("&@UserName&",$Liste_User_Auth)")
	_Test_User(@UserName,$Liste_User_Auth)
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Test_User")
	_Splash("add","Opration","[OK]"&@LF)

	;Test visibilit serveur
	_Splash("add","Opration",">> Visibilit du serveur scribe :....")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Test_Presence_Serveur")
	_Test_Presence_Serveur($serveur)
	_Test_Presence_Serveur($adresse_ip)
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Test_Presence_Serveur")
	_Splash("add","Opration","[OK]"&@LF)

	;Test d'appartenance de la station  un domaine et decente en workgroup si ncessaire
	_Splash("add","Opration",">> Station dj dans un domaine ?....")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Test_Membre_Domaine("&@ComputerName&")")
	_Test_Membre_Domaine(@ComputerName)
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Test_Membre_Domaine")
	_Splash("add","Opration","[NON]"&@LF&@LF)

	;Configuration de la station
	_Splash("add","Opration","2- PREPARATION DE LA STATION :"&@LF)
	_Splash("add","Opration",">> Modification de la configuration..")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Configurer_Station("&$os_station&","&$domaine&","&$ud_admin_local&", mot de passe,"&$serveur&")")
	_Configurer_Station($os_station,$domaine,$ud_admin_local,$mp_admin_local,$serveur)
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Configurer_Station")
	_Splash("add","Opration","[OK]"&@LF)

	;Lance le renommage de la station
	_Splash("add","Opration",">> Renommage de la station...........")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Renommer_Station("&$nom_station_futur&","&$ud_admin_dom&", mot de passe)")
	_Renommer_Station($nom_station_futur,"test","test")
	_Wlog("add","[_Preparation] : DEBUG : Retour de la fonction _Renommer_Station")
	_Splash("add","Opration","[OK]"&@LF)

	_Splash("add","Opration",">> Redmarrage de la station.........")
	_Wlog("add","[_Preparation] : DEBUG : Appel de la fonction _Redemarrer_Station")
	_Redemarrer_Station()
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_Presence_Serveur()
;  Test si le scribe est joignable par ping
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_Presence_Serveur($serveur)
	_Wlog("add+","[_Test_Presence_Serveur] : INFO : Test la prsence du serveur "&$serveur)
	;Si le ping ne rpond pas
	If not Ping($serveur) then
		_Wlog("add","[_Test_Presence_Serveur] : ERREUR : Le ping ne rpond pas, (action=message)")
		_Message(140,"Exit")
	Else
		_Wlog("add","[_Test_Presence_Serveur] : DEBUG : Le ping a rpondu, (action=message, return(1)")
		Return (1)
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_OS()
;  Renvoie XP si OS=XP 32 bits OU V7 si OS=Seven32 ou Vista32 et gre l'affichage de la version.
;  Renvoie "incompatible" si OS non support et gre l'affiche du message d'incompatibilit
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_OS()
	_Wlog("add+","[_Test_OS] : INFO : Test de compatibilit du systme d'exploitation")

	;Dfinition des variables locales
	Local $os_nom
	Local $os_type=_Os_Type()
	Local $os_archi=@OSArch

	_Wlog("add","[_Test_OS] : INFO : OS dtect = "&$os_type&" "&$os_archi)

	;Filtre 1 : Pas de 64 bits !
	;If StringInStr($os_archi(),"64") Then
	;	_Wlog("add","[_Test_OS] : ERREUR : Version 64 bits, (action=message)")
	;	_Message(100,"Exit")
	;EndIf

	;Filtre 2 : Que du pro !
	If not StringInStr($os_type,"Professionnel") Then
		_Wlog("add","[_Test_OS] : ERREUR : Version non professionnelle, (action=message)")
		_Message(110,"Exit")
	EndIf

	;Filtre 3 : Vista, XP, ou Seven ?
	Switch @OSVersion
		Case "WIN_7"
			$os_nom="V7"
		case "WIN_XP"
			$os="XP"
		case "WIN_VISTA"
			$os_nom="V7"
		case Else
			;OS incompatibles
			_Wlog("add","[_Test_OS] : INFO : L'OS n'est pas Seven ou Vista, (action=message)")
			_Message(110,"Exit")
	EndSwitch

	;Si OS compatible
	_Wlog("add","[_Test_OS] : DEBUG : OS seven ou vista, (action=return("&$os_nom&"))")
	Return ($os_nom)
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Os_Type()
;  Renvoie Pro ou Home selon la version de l'OS
;---------------------------------------------------------------------------------------------------------------------------------------
Func _OS_Type()

	_Wlog("add","[_OS_type] : INFO : Dtermination du nom de l'OS")

	;Dfinition des variables locales
    Local $objWMIService = ObjGet("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
    Local $colSettings = $objWMIService.ExecQuery("Select * from Win32_OperatingSystem")

	For $objOperatingSystem In $colSettings
        _Wlog("add","[_OS_type] : DEBUG : lit le nom de l'os (action=return("&$objOperatingSystem.Caption&"))")
		Return $objOperatingSystem.Caption
    Next
EndFunc


;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_Nom_Netbios($nom_station)
;  Contrle la validit du nom de la station
;  Pas d'espace, ni de caractre spciaux, plus de 4 caractres pas plus de 13
;  Renvoie 1 si OK. Sinon message d'erreur et quitte
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_Nom_Netbios($computername)
	_Wlog("add+","[_Test_Nom_Netbios] : INFO : Validation du nom Netbios : "&$computername)

	;Dfinition des variables locales
	Local $l_chaine=StringLen($computername)

	;test de la longueur
	If ($l_chaine<5) OR ($l_chaine>13) then
		_Wlog("add","[_Test_Nom_Netbios] : ERREUR : Le nom : "&$computername&" fait moins de 5 lettres ou plus de 13 lettres, (action=message)")
		_Message(120,"Exit")
	EndIf

	_Wlog("add","[_Test_Nom_Netbios] : DEBUG : Test de la prsence de caractres interdits")
	If StringRegExp($computername,"[& \\\{\}\[\]\|_'`~""=+*%!:;.?,<>$/@]",0) then
		_Wlog("add","[_Test_Nom_Netbios] : ERREUR : Le nom Netbios : "&$computername&" contient un ou plusieurs caractres non autoriss, (action=message)")
		_Message(130,"Exit")
	EndIf

	;le nom est valide
	_Wlog("add","[_Test_Nom_Netbios] : DEBUG : Nom Netbios valid, (action=message, return(1))")
	Return (1)
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_user()
;  Arrte le script si l'utilisateur n'est pas administrateur, raip, ou admin
;  La fonction isAdmin() n'est pas assez slective
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_User($user,$list_user)

	_Wlog("add+","[_Test_User] : INFO : Teste si l'utilisateur "&$user&" est un utilisateur autoris")

	;Est-ce que l'utilisateur fait partie de la liste des utilisateurs autoriss ?
	If _ArraySearch($list_user,$user,0)>0 Then
		_Wlog("add","[_Test_User] : DEBUG : "&$user&" fait partie de la liste prdfinie des utilisateurs autoriss, (action=return(1))")
		Return 1
	Else
		;Est-ce que l'utilisateur fait partie des administrateurs locaux
		If _IsLocalAdmins($user) then
			_Wlog("add","[_Test_User] : DEBUG : "&$user&" fait partie du groupe local autoris, (action=message, return(1))")
			Return 1
		Else
			_Wlog("add","[_Test_User] : ERREUR : "&$user&" ne fait partie d'aucun groupe autoris, (action=message)")
			_Message(160,"Exit")
		EndIf
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _IsLocalAdmins($user,$host)
;  Renvoie 1 si l'utilisateur fait partie du groupe administrateur et 0 sinon
;---------------------------------------------------------------------------------------------------------------------------------------
Func _IsLocalAdmins($user,$host = @ComputerName)

	_Wlog("add","[_IsLocalAdmins] : INFO : Interroge les groupes utilisateurs locaux  la recherche de l'utilisateur "&$user)
	;Dfinition des variables locales
	Dim $filter[1] = ["group"]
	Local $colGroups = ObjGet("WinNT://" & $host & "")

	If Not IsObj($colGroups) Then
		_Wlog("add","[_IsLocalAdmins] : ERREUR : Aucun groupe Local n'a t trouv sur cette machine, (action=return(0))")
		Return 0
	EndIf

	$colGroups.Filter = $filter

	For $objGroup In $colGroups
        If $objGroup.name = "Administrateurs" Then
            For $objUser In $objGroup.Members
                _Wlog("add","[_IsLocalAdmins] : DEBUG : Comparaison avec l'utilisateur "&$objUser.name)
				if $objUser.name=$user then
					_Wlog("add","[_IsLocalAdmins] : DEBUG : Utilisateur "&$user&" trouv, (action=return(1))")
					Return (1)
				EndIf
            Next
        EndIf
    Next
	_Wlog("add","[_IsLocalAdmins] : ERREUR : Aucun utilisateur "&$user&" n'a t trouv, (action=return(0))")
	Return (0)
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Test_Membre_Domaine($nom_station)
;  Test si la station est dj membre d'un domaine et questionne l'utilisateur
;  pour savoir si on doit continuer
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Test_Membre_Domaine($nom_station)

	_Wlog("add+","[_Test_Membre_Domaine] : INFO : Test si la station "&$nom_station&" fait dj partie d'un domaine")

	;Dfinition des variables locales
	Local $domaine=EnvGet("USERDOMAIN")
	Local $result

	;Si le nom de domaine est celui de la station alors c'est qu'on est en workgroup
	If $domaine=$nom_station Then
		_Wlog("add","[_Test_Membre_Domaine] : DEBUG : La station ne fait pas partie d'un domaine, (action=message, return(0))")
		Return (0)
	Else
		_Wlog("add","[_Test_Membre_Domaine] : ERREUR : La station fait dj partie d'un domaine, (action=message)")
		_Message(250,"Exit")

		;Evolution en remplacement des 2 lignes prcdentes
		;Ncessite de savoir redescendre la station en workgroup

		;_Wlog("add","[_Test_Membre_Domaine] : ERREUR : La station fait dj partie d'un domaine, pose la question  l'utilisateur")
		;SplashOff()
		;$result=MsgBox(68,"Question","La station fait dj partie du domaine "&$domaine&@CRLF&"Souhaitez-vous la rintgrer  nouveau ?"&@CRLF&"(OUI = Continuer NON = Quitter)")
		;If $result=7 Then
		;	_Wlog("add","[_Test_Membre_Domaine] : STOP : L'utilisateur abandonne, (action=message)")
		;	_Message("[ABANDON] La station reste dans le domaine "&$domaine,"Exit")
		;Else
		;	_Wlog("add","[_Test_Membre_Domaine] : INFO : L'utilisateur veut continuer, (action=Message)")
		;	_Message("La station va tenter de quitter le domaine "&$domaine)
		;	_JoinWorkgroup("WORKGROUP")
		;	Return (1)
		;EndIf
	EndIf
EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _JoinWorkgroup($sWorkgroup)
;  Replace la station en workgroup (CETTE METHODE NE FONCTIONNE PAS SUR SEVEN)
;---------------------------------------------------------------------------------------------------------------------------------------
Func _JoinWorkgroup($sWorkgroup)
    _Wlog("add","[_JoinWorkgroup] : INFO : La station tente de redescendre dans le groupe de travail : "&$sWorkgroup)

	;Dfinition des variables locales
	Local $domaine=EnvGet("USERDOMAIN")
	Local $computerObj    = ObjGet("winmgmts:{impersonationLevel=Impersonate}!\\" & _
             @ComputerName & "\root\cimv2:Win32_ComputerSystem.Name='" & _
              @ComputerName & "'")

	;Quitte le domaine courant
    $joinDomainResultNumber = $computerObj.JoinDomainOrWorkGroup("scriberaipng","Pezyron","scriberaipng\raip","NULL",4)

	;Rsultat
    If $joinDomainResultNumber  = 0 Then
		_Wlog("add","[_JoinWorkgroup] : DEBUG : La station a rejoint le groupe de travail "&$sWorkgroup&" (action=message, return)")
		_Message("La station a quitt le domaine "&$domaine)
		Return
	Else
		_Wlog("add","[_JoinWorkgroup] : ERREUR : Impossible de revenir en Workgroup, erreur="&$joinDomainResultNumber&", (action=message)")
		_Message(240,"Exit")
	EndIf
EndFunc


;---------------------------------------------------------------------------------------------------------------------------------------
; _Configurer_Station($OS,$ud,$pd)
;  Applique la prconfiguration du registre ncessaire selon l'OS
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Configurer_Station($os,$dom,$ud,$pd,$serveur)

	_Wlog("add+","[_Configurer_Station] : INFO : Mise en place de la configuration initiale de la station")

	;Dfinition des variables locales
	Local $ok,$i
	Local $comspec=@ComSpec & " /c "
	;Tableau des commandes  lancer
	Local $commandes[5]= [ _
	"net users "& $ud&" /add", _
	"net localgroup Administrateurs "& $ud&" /add", _
	"net users "& $ud&" /active:yes", _
	"net users "& $ud&" "&$pd, _
	"net time /set /yes \\"& $serveur]

	_Wlog("add","[_Configurer_Station] : INFO : Ractivation du compte administrateur local")
	For $i=0 to UBound($commandes)-1
		_Wlog("add","[_Configurer_Station] : DEBUG : commande = "&$comspec & stringleft($commandes[$i],15)&"...")
		$erreur=RunWait($comspec & '"'&$commandes[$i]&'"',"",@SW_HIDE)
		If ($erreur=0 and @error<>0) then
			_Wlog("add","[_Configurer_Station] : DEBUG : Code erreur Run = "&$erreur &"; Code erreur commande ="&@error)
			_Wlog("add","[_Configurer_Station] : DEBUG : ERREUR la commande ne s'est pas termine correctement")
		Else
			_Wlog("add","[_Configurer_Station] : DEBUG : Code erreur Run = "&$erreur &"; Code erreur commande ="&@error)
			_Wlog("add","[_Configurer_Station] : DEBUG : La commande s'est termine correctement")
		EndIf
	Next

	_Wlog("add","[_Configurer_Station] : INFO : Application des cls de registres")
	switch $os
		Case "XP"
			;Wlog("add","[_Configurer_Station] : INFO : Pas de configuration de registre pour XP")
			;rien de spcifique pour l'instant
		Case "V7"
			_Wlog("add","[_Configurer_Station] : INFO : Configuration du registre V7")
			For $i=0 to UBound($Reg_Key_V7)-1
				_Wlog("add","[_Configurer_Station] : DEBUG : Cl : "&$i&" "&$Reg_Key_V7[$i][0]&" "&$Reg_Key_V7[$i][2]&"="&$Reg_Key_V7[$i][4])
				$ok=RegWrite($Reg_Key_V7[$i][1],$Reg_Key_V7[$i][2],$Reg_Key_V7[$i][3],$Reg_Key_V7[$i][4])
				if not $ok then
					_Wlog("add","[_Configurer_Station] : ERREUR : Configuration du registre V7, (action=message)")
					_Message(190,"Exit")
				EndIf
			Next
	EndSwitch
	_Wlog("add","[_Configurer_Station] : DEBUG : Configuration termine, (action=return(1))")
	Return (1)

EndFunc

;---------------------------------------------------------------------------------------------------------------------------------------
; _Renommer_Station($iCompName, $iUserName = "", $iPassword = "")
;  Renomme la station
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Renommer_Station($iCompName, $iUserName = "", $iPassword = "")
	_Wlog("add+","[_Renommer_Station] : INFO : Renommage de la station en "&$iCompName)
	$objWMIService = ObjGet("winmgmts:\root\cimv2")

	If @error Then
		_Wlog("add","[_Renommer_Station] : ERREUR : WMI error="&@error&", (action=message)")
		_Message(210,"Exit")
	EndIf

    For $objComputer In $objWMIService.InstancesOf("Win32_ComputerSystem")
        $oReturn = $objComputer.rename($iCompName,$iPassword,$iUserName)
		If $oReturn <> 0 Then
			_Wlog("add","[_Renommer_Station] : ERREUR : la commande de renommage retourne une erreur, (action=message)")
			_Message(210,"Exit")
		EndIf
	Next

	_Wlog("add","[_Renommer_Station] : DEBUG : Station renomme, (action=message, return)")

EndFunc


;---------------------------------------------------------------------------------------------------------------------------------------
; _Redemarrer_Station()
;  Redmarre la station
;---------------------------------------------------------------------------------------------------------------------------------------
Func _Redemarrer_Station()
	_Wlog("add+","[_Redemarrer_Station] : INFO : Redmarrage de la station, (action=message, redmarrage)")
	_Splash("add","Opration","[OK]")
	Sleep(1000)
	Shutdown(6)
EndFunc