; Fichier InnoSetup de cration de l'installeur du Client Scribe
; clieole-setup.exe doit tre accompagn d'un fichier "install.ini"
; plac dans le mme rpertoire.
;
; Ce fichier contient :
; [global]
; ip_scribe = %adresse_ip_eth0
; nom_scribe = %smb_netbios_name
; nom_domaine = %smb_workgroup
; port_scribe = 8789
; port_scribe_update = 8790
; port_client = 8788
; port_utilisateur = 8791
; version = 1 # sert  dclencher ou non la MAJ par updater.exe
;
;
; utilisation de "QuickStart Pack" http://www.jrsoftware.org/isdl.php#qsp
; installation de Inno Setup, ISTools, ISPP
;
; ce fichier ncessite :
; - la prsence de :
; * C:\WINDOWS\Eole_inst\updater\
;

#define InstPath "{app}"

#define IpScribe "{ini:{src}\install.ini,global,ip_scribe|0.0.0.0}"
#define IpAccessList "['{ini:{src}\install.ini,global,ip_scribe|1.1.1.1}']"
#define PortClient "{ini:{src}\install.ini,global,port_client|8788}"
#define PortScribe "{ini:{src}\install.ini,global,port_scribe|8789}"
#define PortScribeUpdate "{ini:{src}\install.ini,global,port_scribe_update|8790}"
#define PortUtilisateur "{ini:{src}\install.ini,global,port_utilisateur|8791}"
#define NomScribe "{ini:{src}\install.ini,global,nom_scribe|scribe}"
#define NomDomaine "{ini:{src}\install.ini,global,nom_domaine|workgroup}"
#define DebugLogon "{ini:{src}\install.ini,global,debug_logon|1}"
#define LogLevel "{ini:{src}\install.ini,global,log_level|debug}"

;#define InnoSources "U:\sources"
#define InnoSources "C:\controle-vnc\sources"
#define UpdaterInnoSources InnoSources + "\all\dists\updater"
#define ImagesDir InnoSources + "\all\images"
#define UpdaterOutputDir InnoSources
;#define UpdaterOutputDir "C:"

#define AppVersion GetFileVersion(AddBackslash(UpdaterInnoSources) + "servupdate.exe")


[Setup]
AppName=Client Eole - Service de MAJ - 2.3/2.4
; AppId sert  reconnaitre l'application
AppId=CliEole-updater
AppVerName=Client Eole - Service de MAJ - 2.3/2.4 ({#AppVersion})
AppPublisher=quipe Eole
AppPublisherURL=http://eole.orion.education.fr/
AppSupportURL=http://eole.orion.education.fr/
AppUpdatesURL=http://eole.orion.education.fr/
AppVersion={#AppVersion}
VersionInfoVersion={#AppVersion}
VersionInfoCompany=Eole
VersionInfoDescription=Client Eole
VersionInfoCopyright=Eole
AppCopyright=Eole
DefaultDirName={win}\Eole
; interdit la modification du chemin d'installation
DisableDirPage=true
; interdit la modification du chemin de copie des icnes
DisableProgramGroupPage=true
OutputDir={#UpdaterOutputDir}
OutputBaseFilename=clieole-updater-setup
PrivilegesRequired=admin
AllowCancelDuringInstall=false
SetupIconFile={#ImagesDir}\eole.ico
UninstallDisplayIcon={app}\updater\servupdate.exe
;WizardImageFile=eole.bmp
WizardImageFile={#ImagesDir}\logo-eole.bmp
WizardSmallImageFile={#ImagesDir}\eole.bmp
AlwaysRestart=false
ArchitecturesInstallIn64BitMode=x64 ia64


[Languages]
Name: french; MessagesFile: compiler:Languages\French.isl

[Files]
Source: {#UpdaterInnoSources}\*; DestDir: {app}\updater; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete

[Registry]
; client Scribe
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: ip_scribe; ValueData: {#IpScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: ip_access_list; ValueData: {#IpAccessList}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: inst_path; ValueData: {app}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_client; ValueData: {#PortClient}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_scribe; ValueData: {#PortScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_scribe_update; ValueData: {#PortScribeUpdate}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_utilisateur; ValueData: {#PortUtilisateur}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: nom_scribe; ValueData: {#NomScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: nom_domaine; ValueData: {#NomDomaine}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: debug_logon; ValueData: {#DebugLogon}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: log_level; ValueData: {#LogLevel}

[Run]
; Desactivation du parefeu XP-sp2
Filename: {sys}\netsh.exe; Parameters: firewall set opmode mode=disable profile=ALL; Flags: runhidden; MinVersion: 0,5.01.2600sp2; OnlyBelowVersion: 0,5.01.2600sp9
; installation du service (XP seulement)
Filename: {app}\updater\servupdate.exe; Parameters: -install -auto -interactive; Flags: runhidden; MinVersion: 0,4.0.1381
; ajout d'une entre dans le parefeu Vista
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleMAJService program={app}\updater\servupdate.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0

[UninstallRun]
; XP

Filename: {sys}\net.exe; Parameters: stop servupdate; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\sc.exe; Parameters: delete servupdate; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleMAJService; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0

[Code]
procedure CurStepChanged(CurStep: TSetupStep);
var
  orig, dest: String;
begin
  if CurStep = ssDone then begin
    orig:=ExpandConstant('{src}\install.ini');
    dest:=ExpandConstant('{app}\install.ini');
    if (FileExists(orig)) then
      FileCopy(orig, dest, False);
  end;
end;
[UninstallDelete]
Name: {app}\tmp\*; Type: filesandordirs
Name: {app}\tmp; Type: filesandordirs
