# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import dict4ini
from ConfigParser import ConfigParser


def set_option(fich, sect, var, value, typ):
    """renseigne l'option var de la section sect de type typ (BOOLEAN/STRING)
    avec la valeur value dans le fichier fich
    """
    d = dict4ini.DictIni(fich)
    if value == 'SUPPR' or value == 'SUPPRALL': del(d[sect][var])
    else:
        if typ == 'BOOLEAN':
            try: value = int(value)
            except: pass
        d[sect][var] = value
    d.save()

def get_option(fich, sect, var):
    """Renvoie la valeur de l'option var de la section sect
    du fichier fich
    """
    d = dict4ini.DictIni(fich)
    if d.has_key(sect) and d[sect].has_key(var): return d[sect][var]
    return None

def has_option(fich, section, var):
    c = ConfigParser()
    c.read(fich)
    return c.has_option(section, var)

