# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python


import win32netcon, win32file, win32con, win32wnet
import os
#win32wnet.WNetAddConnection2(1,'l:',r'\\bolwerk\partage')

def connect(drive, unc, username=None, password=None, persistent=False):
    """Monte un lecteur
    """
    dliste = ['d:','e:','f:','g:','h:','i:','j:','k:','l:','m:','n:','o:','p:','q:','r:','s:','t:','u:','v:','w:','x:','y:','z:']
    if persistent: flags = win32netcon.CONNECT_UPDATE_PROFILE
    else: flags = 0
##    print drive, win32file.GetDriveType(drive)
    if is_netdrive(drive): # si lecteur rseau dj prsent, dconnexion
        win32wnet.WNetCancelConnection2(drive, win32netcon.CONNECT_UPDATE_PROFILE, 1)
    elif win32file.GetDriveType(drive) != win32con.DRIVE_NO_ROOT_DIR: # si autre type de lecteur, chercher une lettre dispo
        for i in dliste:
            if win32file.GetDriveType(i) == win32con.DRIVE_NO_ROOT_DIR:
                drive = i
                break
    try:
        win32wnet.WNetAddConnection2(
            win32netcon.RESOURCETYPE_DISK,
            drive,
            unc,
            None,
            username,
            password,
            flags
            )
        return True, drive
    except Exception, e:
        return False, '%s %s : %s'%(drive, unc, e)


def disconnect(drive):
    """Dmonte le lecteur "drive"
    """
    if not os.path.exists(drive): return True
    if win32file.GetDriveType(drive) == win32con.DRIVE_REMOTE: # si lecteur rseau dj prsent, dconnexion
        win32wnet.WNetCancelConnection2(drive, 0, 1)
        return True
    return False

def gen_dict():
    """Renvoie un dictionnaire {lettre : valeur}
    {'a': 1, 'c': 4, 'b': 2, 'e': 16, 'd': 8, 'g': 64, 'f': 32, 'i': 256, 'h': 128 ...
    ... 'x': 8388608, 'z': 33554432}
    """
    nb=1
    dic={}
    for i in range(97, 123):
        dic[chr(i)] = nb
        nb = nb*2
    return dic

def get_drive(nb):
    """Renvoie la lettre de lecteur la plus "haute" contenue dans "nb"
    """
    a=gen_dict()
    for i in range(122, 96, -1):
        if a[chr(i)] <= nb:
            return chr(i)

def get_drives(nb):
    """Renvoie la liste des lettres de lecteur reprsentes par "nb"
    """
    a = gen_dict()
    liste = []
    while nb > 0:
        d = get_drive(nb)
        liste.append(d)
        nb = nb - a[d]
    return liste

def add_eole_drives(nb):
    """Renvoie le nombre correspondant au maskage des lettres dj caches "nb"
    plus les lettres S, T, U
    """
    orig_lects = get_drives(nb)
    md = dict(s=262144, t=524288, u=1048576)
    for lect in md.keys():
        if lect not in orig_lects:
            nb += md[lect]
    return nb
    
def gen_inv_nb(lects):
    """Gnre le nombre correspondant aux lecteurs NON contenus dans la liste "lects"
    """
    lects  = list(set(lects)) # dgage les doublons
    az = [ chr(i) for i in range(97,123) ]
    nb = sum([ 2**az.index(i) for i in list(set(az) - set(lects)) ])
    return nb
    
def gen_nb(lects):
    """Gnre le nombre correspondant aux lecteurs contenus dans la liste "lects"
    """
    lects  = list(set(lects)) # dgage les doublons
    az = [ chr(i) for i in range(97,123) ]
    nb = sum([ 2**az.index(i) for i in lects ])
    return nb


def is_netdrive(drive):
    if not drive.endswith(':'): drive+=':'
    res_type = [1, 4] # [RESOURCE_CONNECTED, RESOURCE_REMEMBERED]
    for i in res_type:
        handle = win32wnet.WNetOpenEnum(i, 1, 0, None)
        items = win32wnet.WNetEnumResource(handle, 0)
        for item in items:
    		if item.dwDisplayType == win32netcon.RESOURCEDISPLAYTYPE_SHARE:
    		    if drive.lower() == item.lpLocalName.lower(): return True
