#define _GLIBCXX_USE_WCHAR_T 1

#include <windows.h>
#include <winwlx.h>
#include <string.h>
#include <sstream>

//Entrance function for the DLL
BOOL WINAPI LibMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
    switch (dwReason)
    {
        case DLL_PROCESS_ATTACH:
        {
         DisableThreadLibraryCalls (hInstance);     
        }
        break;
    }
    return TRUE;
}


PROCESS_INFORMATION g_pi;

int ReadReg(char *mavar, char *dest, int dest_size)
{
    long Res;
    DWORD size = dest_size;
    HKEY hKey;
    std::ostringstream message;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
        "Software\\Eole\\cliscribe",
        0, KEY_READ, &hKey) != ERROR_SUCCESS)
        {
            MessageBox(0, "Impossible d'ouvrir la BDR", "Eole", MB_OK);
            return 1;
        }
    Res = RegQueryValueEx(hKey, mavar, NULL, NULL, (unsigned char *)dest, &size);
    if ( Res != ERROR_SUCCESS)
        {
            message << "Impossible de lire la BDR : " << mavar;
            MessageBox(0, (char*)message.str().c_str(), "Eole exe", MB_OK);
            return 1;
        }
    RegCloseKey(hKey);
    return 0;
}   

char *WideCharToCharP(WCHAR *input)
{
     char *output;
     int size;
     size = WideCharToMultiByte(CP_ACP, 0, input, -1, output, 0, NULL, NULL);
     output = (char *)malloc(size);
     WideCharToMultiByte(CP_ACP, 0, input, -1, output, size, NULL, NULL);     
     return output;
}

void Main (PWLX_NOTIFICATION_INFO pInfo, char *eventtype){
    DWORD dSize = MAX_PATH;
    char logExe[MAX_PATH];
    char logExe_user[MAX_PATH];
    char debug[10];
    char *reg_sys, *reg_user;
    std::ostringstream cmd;
    
    if (strcmp(eventtype, "logon") == 0){
        reg_sys = "logon_exe";
        reg_user = "logon_exe_user";
    }
    else if (strcmp(eventtype, "logoff") == 0){
        reg_sys = "logoff_exe";
        reg_user = "logoff_exe_user";
    }
    if (ReadReg(reg_sys, logExe, sizeof(logExe)) 
    || ReadReg(reg_user, logExe_user, sizeof(logExe_user)))
    {
       return;
    }
    
    if (ReadReg("debug", debug, sizeof(debug)))
    {
         strcpy(debug, "0");
    }
    
    STARTUPINFO si;
    si.cb = sizeof(STARTUPINFO);
    si.lpReserved = NULL;
    si.lpTitle = NULL;
    si.lpDesktop = TEXT("WinSta0\\Default");
    si.dwX = si.dwY = si.dwXSize = si.dwYSize = 0L;
    si.dwFlags = 0;;
    si.wShowWindow = SW_SHOW;
    si.lpReserved2 = NULL;
    si.cbReserved2 = 0;
    
    char *username = WideCharToCharP(pInfo->UserName);
    char *domain = WideCharToCharP(pInfo->Domain);

    if (strlen(logExe) != 0){
        // ajout du nom d'utilisateur et du nom de domaine aux arguments des .exe
        cmd << logExe << ' ' <<  username << ' ' << domain;
        if (strcmp(debug, "1") == 0){
           MessageBox (0, (char*)cmd.str().c_str(), "Eole_exe", MB_OK);
           }
        CreateProcess(NULL, (char*)cmd.str().c_str(), 0, 0, FALSE,
                         CREATE_DEFAULT_ERROR_MODE, 0, 0,
                         &si, &g_pi);
        WaitForSingleObject( g_pi.hProcess, INFINITE );
    }
    // Wait until child process exits.

    cmd.str("");
    if (strlen(logExe_user) != 0){
        cmd << logExe_user << ' ' <<  username << ' ' << domain;
        if (strcmp(debug, "1") == 0){
            MessageBox (0, (char*)cmd.str().c_str(), "Eole_exe_user", MB_OK);
            }
        CreateProcessAsUser(pInfo->hToken, NULL, (char*)cmd.str().c_str(), 0, 0, FALSE,
                     CREATE_DEFAULT_ERROR_MODE, 0, 0,
                     &si, &g_pi);
        WaitForSingleObject( g_pi.hProcess, INFINITE );
    }
    // Wait until child process exits.

    free(username);
    free(domain);
}

//Event handler for the Winlogon Logon event
extern "C" VOID __declspec(dllexport) APIENTRY ELogon (PWLX_NOTIFICATION_INFO pInfo)
{
    Main(pInfo, "logon");
//    WaitForSingleObject(procinfo.hProcess, INFINITE);
//    CloseHandle(procinfo.hThread);
//    CloseHandle(procinfo.hProcess);
}


//Event handler for the Winlogon Logoff event.
extern "C" VOID __declspec(dllexport) APIENTRY ELogoff (PWLX_NOTIFICATION_INFO pInfo)
{
    Main(pInfo, "logoff");
}

