#!/usr/bin/env python
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# cliscribe.py
#
# Librairie contenant les méthodes d'appel distant aux clients windows
#
###########################################################################

# imports twisted perspective broker
from twisted.spread import pb
from twisted.internet import reactor
# timeout
#from twisted.protocols import policies
from twisted.python import log
#from twisted.python import util
import re
import sys
import time
import socket
sys.path.append('/usr/share/eole/client')

from twisted.python import failure


# constantes #
port = 8788
##############


class TimeoutError(Exception):
    pass

#def timeout(deferred):
#    print 'coucou'
#    return deferred.errback(failure.Failure(TimeoutError("Callback timed out")))
#
#def setmytimeout(deferred, seconds, timeoutfunc=timeout, *args, **kw):
#    deferred.mytimeout = reactor.callLater(seconds, lambda: deferred.called or timeoutfunc(deferred, *args, **kw))
#    return deferred

class Cliscribe:#(policies.TimeoutMixin):
    def __init__(self, ip, tmout=15, disconnect=True):
        self.port = port
        self.ip = ip
        self.disconnect = disconnect
        self.factory = pb.PBClientFactory()
        reactor.connectTCP(self.ip, self.port, self.factory, timeout=15)
        self.d = self.factory.getRootObject()
        # gestion du timeout
        self.setmytimeout(tmout)

    def test_port(self):
        # appel de la mthode remote_logon avec type_os en argument
        # attente que utilisateur.exe se lance
        log.msg('test_port %s:%s'%(self.ip, self.port))
        nb = 0
        while True:
            try:
                s = socket.socket()
                s.settimeout(2)
                s.connect((self.ip, self.port))
                s.close()
                break
            except socket.timeout:
                pass
            except Exception, e:
                time.sleep(2)
            try: s.close()
            except: continue
            if nb >= 15 :
                raise Exception('Le service sur la station "%s" n\'a pas repondu au bout de 30 secondes'%self.ip)
            nb += 1
            pass
        return True

    def appel(self, ret=None):
        self.d.addCallback(lambda object: object.callRemote('bonjour'))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def logon(self, ret=None, logon_dict=None):
        # appel de la remote_fonction
        self.test_port()
        self.d.addCallback(lambda object: object.callRemote('logon', logon_dict))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def vnc(self, ret=None, action=None, value=None, conf=None, restart=True):
        # appel de la remote_fonction
        self.d.addCallback(lambda object: object.callRemote('winvnc', action, value, conf, restart))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def winreg(self, ret=None, reg_dict=None):
        self.d.addCallback(lambda object: object.callRemote('regedit', reg_dict))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def execute(self, ret=None, cmd=None, hide=False, nowait=True, waitinput=False, user=False):
        self.d.addCallback(lambda object: object.callRemote('execute', cmd, hide, nowait, waitinput, user))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def fw(self, ret=None, cmd=None):
        self.d.addCallback(lambda object: object.callRemote('fw', cmd))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def killproc(self, ret=None, progname=None):
        self.d.addCallback(lambda object: object.callRemote('killproc', progname))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def shutdown(self, ret=None, reboot=False, force=True):
        """reboot=0 => halt, reboot=1 => reboot, reboot=2 => close session
        """
        self.d.addCallback(lambda object: object.callRemote('shutdown', reboot, force))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    def bloc(self, ret=None, partmod=None, sid=None, logon=False):
        """Ne bloque que les partages, le blocage réseau est appliqué via
        execute(cmd='wipfw drop etc...') voir blocage.py
        """
        self.d.addCallback(lambda object: object.callRemote('bloc', partmod, sid, logon))
        self.d.addErrback(self.err)
        return self.do_disconnect()

    # Fonctions de callback, errback, timeout #
    def do_disconnect(self):
        """gestion de la déconnexion
        """
        if self.disconnect:
#            log.msg('Deconnexion')
            self.d.addCallback(self.ret)
            self.d.addErrback(self.err)
        return self.d

    def ret(self, val=None):
#        log.msg('ret %s'%val)
        self.factory.disconnect()
        return val

    def err(self, val):
        try: msg = 'Erreur , %s'%val.getBriefTraceback()
        except: msg = 'Erreur, %s'%val
        log.err(msg)
        self.factory.disconnect()
        return val

    def setmytimeout(self, secds):
        """Deferred.setTimeout est deprecated et "it seems to work but it actually doesn't" (exarkun)
        si self.d.called != False => return self.d.called sinon exécute la fonction self.timeout
        """
        self.d.mytimeout = reactor.callLater(secds, lambda: self.d.called or self.timeout())
        return self.d.mytimeout

    def timeout(self):
        """ "fire" le deferred self.d pour passer au callback suivant (pour avoir au moins un retour dans l'appli
        """
        log.msg('Timeout %s'%self.ip)
        self.d.errback(failure.Failure(TimeoutError("Callback timed out")))


def valid_ip(ip):
    pattern = r"\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b"
    if re.match(pattern, ip):
       return True
    else:
       return False

def rprint(resultat):
    """
       fonction qui se contente d'afficher le résultat
       retourné par la fonction distante
    """
    print resultat
    log.msg('%s'%resultat)
    reactor.stop()

# appel à reserver aux tests uniquement :)
if __name__ == '__main__':
    try:
        ip = sys.argv[1]
    except:
        ip = raw_input("adresse IP du poste client : ")
    if not valid_ip(ip):
        print 'IP "%s" non valide'%ip
        sys.exit(1)
    if '-killproc' in sys.argv:
        prog = sys.argv[sys.argv.index('-killproc')+1]
        print prog
        d = Cliscribe(ip, disconnect=False).killproc(progname=prog)
        d.addCallback(lambda ret: reactor.stop())
    elif '-shutdown' in sys.argv:
        try:
            mode = sys.argv[sys.argv.index('-shutdown')+1]
        except:
            mode = '0'
        print mode
        d = Cliscribe(ip, disconnect=False).shutdown(reboot=mode)
        d.addCallback(lambda ret: reactor.stop())
    elif '-executeuser' in sys.argv:
        prog = sys.argv[sys.argv.index('-executeuser')+1]
        print prog
        d = Cliscribe(ip, disconnect=False).execute(cmd=prog, user=True)
        d.addCallback(lambda ret: reactor.stop())
    elif '-execute' in sys.argv:
        prog = sys.argv[sys.argv.index('-execute')+1]
        print prog
        d = Cliscribe(ip, disconnect=False).execute(cmd=prog)
        d.addCallback(lambda ret: reactor.stop())
    elif '-vnc' in sys.argv:
        dst = sys.argv[sys.argv.index('-vnc')+1]
        d = Cliscribe(ip, disconnect=False).vnc(action='setinputs', value=True)
        d.addCallback(lambda _: Cliscribe(ip, disconnect=False).vnc(action='connect', value=dst))
        d.addCallback(lambda _: reactor.stop())
    else:
        d = Cliscribe(ip, disconnect=False).appel()
        #d.addCallback(lambda ret: reactor.stop())
        d.addCallback(rprint)
    d.addErrback(rprint)
    reactor.run()




