# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

from distutils.core import setup
import py2exe
import os, shutil, sys, glob

from eole import versioneole

# pour l'import de win32com.shell
try:
    import modulefinder
    import win32com
    for p in win32com.__path__[1:]:
        modulefinder.AddPackagePath("win32com", p)
    for extra in ["win32com.shell"]: #,"win32com.mapi"
        __import__(extra)
        m = sys.modules[extra]
        for p in m.__path__[1:]:
            modulefinder.AddPackagePath(extra, p)
except ImportError:
    # no build path setup, no worries.
    raise ImportError
# #############

dist_dir = "dists\\cliscribe"
if os.path.exists(dist_dir):
    shutil.rmtree(dist_dir)

if os.path.exists("build"):
    shutil.rmtree("build")

# # recuperation des chemins contenant les DLLs
dll1 = os.path.join(os.path.abspath('.'), 'dlls')
# # Ajout de ces chemins au %PATH%
os.environ['path']=';'.join([os.environ['path'], dll1])
# # Ajout des DLLS aux 'data_files'
dlls = glob.glob(r"dlls\*.*")
data_files = [("", dlls),
              ("", ["images\\eole.ico"]),
              ]

opts = {"py2exe": {
                   "dist_dir": dist_dir,
                   "packages":["encodings",],
                   "optimize":1,
                   # "bundle_files": 1,
                   # "compressed":True,
                   "includes": "win32serviceutil",
}}

setup(name = "Client Eole",
        options = opts,
        version = versioneole.CLISCRIBE_VERSION,
        description = "Client Eole",
        author = "Eole",
        author_email = "eole@ac-dijon.fr",
        url = "http://eole.orion.education.fr/",
        service = [{'modules': 'servscribe',
                  'icon_resources': [(1, 'images\\eole.ico')]
                }],
        windows = [{'script': 'logon.py',
                  'icon_resources': [(1, 'images\\eole.ico')]
                 },
                 {'script': 'utilisateur.py',
                  'icon_resources': [(1, 'images\\eole.ico')]
                }],
        console = [{'script': 'confservscribe.py',
                  'icon_resources': [(1, 'images\\eole.ico')]
                 }],
        data_files=data_files
      )

