#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_

from distutils.core import setup
import py2exe
import os, shutil, glob

from eole import versioneole

dist_dir = "dists\\updater"
if os.path.exists(dist_dir):
    shutil.rmtree(dist_dir)

if os.path.exists("build"):
    shutil.rmtree("build")

# recuperation des chemins contenant les DLLs
dll1 = os.path.join(os.path.abspath('.'), 'dlls')
# Ajout de ces chemins au %PATH%
os.environ['path']=';'.join([os.environ['path'], dll1])
# Ajout des DLLS aux 'data_files'
dlls = glob.glob(r"dlls\*.*")
data_files = [("", dlls),
              ("images", ["images\\eole.ico"]),
              ]

opts = {"py2exe": {
                   "dist_dir": dist_dir,
                   "packages":["encodings",],
                   "optimize":1,
                   "includes": "win32serviceutil",
}}

setup(name = 'Client Eole Updater',
      version = versioneole.CLISCRIBE_VERSION,
      description = 'Utilitaire de mise  jour du client Eole',
      author = 'Eole',
      author_email = 'eole@ac-dijon.fr',
      options=opts,
      url = 'http://eole.orion.education.fr/diffusion',
      service = [{'modules': 'servupdate',
                  'icon_resources': [(1, 'images/eole.ico')]
                }],
      data_files=data_files
)
