# _*_ coding: iso-8859-1 _*_

if __name__ == '__main__':
    from twisted.internet import wxreactor
    wxreactor.install()

from twisted.internet import threads
from twisted.internet import reactor

import wx
import os
import time
import shutil
import logging
import urllib2, md5

import win32api as wa

from logging.handlers import RotatingFileHandler

from eole.ini import get_option
from eole.os_type import type_os
from eole.perms import AdjustPrivilege
from eole.lance_cmd import lancecmd
from eole import option, reg
from eole.log import SERVICEMAJ_LOG, FORMATTER

[wxID_FRAME1, wxID_FRAME1BUTTON1, wxID_FRAME1PANEL1, wxID_FRAME1STATICTEXT1, wxID_FRAME1STATICTEXT2,
] = [wx.NewId() for _init_ctrls in range(5)]

class UpdaterFrame(wx.Frame):
    def __init__(self):
        style=wx.TAB_TRAVERSAL | wx.SYSTEM_MENU | wx.CAPTION | wx.CLIP_CHILDREN #| wx.CLOSE_BOX
        wx.Frame.__init__(self, style=style, name='', parent=None, title='Mise  jour Eole', pos=wx.Point(-1, -1),
                          id=wxID_FRAME1, size=wx.Size(320, 120))
        self.Center(wx.BOTH)
        self.SetIcon(wx.Icon(u'images\\eole.ico', wx.BITMAP_TYPE_ICO))

        self.panel1 = wx.Panel(id=wxID_FRAME1PANEL1, name='panel1', parent=self,
                               pos=wx.Point(0, 0), size=wx.Size(-1, -1), style=wx.TAB_TRAVERSAL)
        self.panel1.SetBackgroundColour(wx.Colour(255, 255, 209))
        self.panel1.Center(wx.BOTH)

        self.button1 = wx.Button(id=wxID_FRAME1BUTTON1, name='button1', parent=self.panel1, label="Close", pos=(133, 55), size=(50,22))
        self.Bind(wx.EVT_BUTTON,  self.OnButton1, self.button1)

        msg="""Mise  jour en cours,
le systme va redmarrer automatiquement"""
        self.staticText1 = wx.StaticText(id=wxID_FRAME1STATICTEXT1,
              label=msg, name='staticText1', parent=self.panel1,
              pos=wx.Point(10, 0), size=wx.Size(-1, -1),
              style=wx.ALIGN_CENTRE)
        self.staticText1.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False, u'Tahoma'))

        self.staticText2 = wx.StaticText(id=wxID_FRAME1STATICTEXT2,
              label='', name='staticText2', parent=self.panel1,
              pos=wx.Point(8, 36), size=wx.Size(-1, -1),
              style=wx.SUNKEN_BORDER|wx.ALIGN_CENTRE)
        self.staticText2.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False, u'Tahoma'))

        # Dsactiver Alt+F4
        self.panel1.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.button1.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.staticText1.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
        self.Bind(wx.EVT_CLOSE, self.OnClose)
        self.altf4 = False
        self.button1.Hide()
        # Dmarrage de la mise  jour
        self.update()

    def update(self):
        updt = upDater(affichage=self.staticText2)
        d = threads.deferToThread(updt.update)
        d.addCallback(ret_update)
        d.addErrback(ret_update)

    def OnKeyDown(self, event):
        """On a appuy sur une touche ?"""
        # si Alt+F4
        self.altf4 = False
        if event.AltDown() and event.GetKeyCode() == wx.WXK_F4:
            self.altf4 = True

    def OnButton1(self, event):
        self.Close()
        reactor.stop()

    def OnClose(self, event):
        if self.altf4 == False: reactor.stop()

class upDater:
    def __init__(self, restart=True, affichage=None):
        """
        fichier de configuration "install.ini" (contient la version du client)
        setup  tlcharger "clieole-setup.exe"
        self.inst_path: chemin d'installation des applications (%WINDIR%\Eole)
        self.tmpdir: rpertoire de tlchargement/dcompactage (%WINDIR%\Eole\tmp)
        """
        # redmarrer auto en fin d'install ?
        self.restart = restart
        # pour afficher les informations
        self.affichage = affichage
        # cration du logger
        self.set_logger()
        # type de l'OS
        self.type_os = type_os
        # nom du fichier  tlcharger
        self.setup = 'clieole-setup.exe'
        # le rpertoire temporaire pour le tlchargement
        self.inst_path = option.get_inst_path()
        self.tmpdir = os.path.join(self.inst_path, 'tmp')
        # fichier de configuration
        self.conf_f_name = 'install.ini'
        self.conf_f = os.path.join(self.inst_path, self.conf_f_name)
        # adresse ip scribe et port du serveur de fichiers
        self.serveur = option.get_ip_scribe()
        self.port = int(option.get_port_scribe_update())

    def affiche(self, label, color='green'):
        if self.affichage:
            if color == 'green': self.affichage.SetForegroundColour(wx.Colour(0, 221, 0))
            elif color == 'red': self.affichage.SetForegroundColour(wx.Colour(255, 0, 0))
            elif color == 'orange': self.affichage.SetForegroundColour(wx.Colour(255, 164, 0))
            try: self.affichage.SetLabel(label)
            except: pass

    def set_logger(self):
        # on log sur 2 fichiers de 100ko
        handler = RotatingFileHandler(SERVICEMAJ_LOG, 'a', 100000, 2)
        handler.setFormatter(FORMATTER)
        self.log = logging.getLogger(SERVICEMAJ_LOG)
        self.log.addHandler(handler)
        self.log.setLevel(option.get_log_level())

    #################
    ## Mise  jour ##
    #################
    def update(self):
        """tlcharge self.setup (inclue comparatif checksum)
        dsinstalle l'ancienne version
        installe la nouvelle
        """
        # Une ligne blanche pour mieux voir
        self.log.info('')
        # Faut-il mettre a jour ?
        ret = self.test_update()
        if not ret: return True
        elif ret == 'wait': return False
        # Oui
        self.log.info(u'Mise a jour declenchee')
        msg_err = """
Veuillez consulter le fichier "%WINDIR%\cliscribe_updater.log"."""
        if self.restart:
            self.affiche("Une mise  jour est en cours, le systme va redmarrer...", 'orange')
        # options eventuelles d'installation
        inst_args = get_option(self.tmp_conf_f, 'global', 'inst_args')
        # tlchargement et vrification de l'archive
        if not self.download(self.setup):
            self.affiche("Le tlchargement a chou. Abandon de la mise  jour.%s"%msg_err, 'red')
            return False
        # dsinstallation
        unin = self.uninstall_old()
        if not unin:
            self.affiche("La dsinstallation de l'ancienne version a chou. Abandon de la mise  jour.%s"%msg_err, 'red')
            return False
        elif unin == 'reboot':
            return True
        # installation de la nouvelle version
        self.log.info('Installation de la version %s'%self.new_ver)
        cmd = '%s %s'%(os.path.join(self.tmpdir, self.setup), inst_args)
        self.log.debug(u'%s'%cmd)
        self.affiche(u'%s'%cmd)
        ret = lancecmd(cmd)
        if ret != 0:
            self.log.error(u'Installation echouee (code retour : %s)'%ret)
            return False
        self.log.info(u'Mise a jour terminee')
        self.affiche(u'Mise a jour termine')
        os.remove(self.conf_f)
        shutil.copy(self.tmp_conf_f, self.conf_f)
        self.clean_tmp()
        self.reboot()

    def test_update(self):
        """compare le numro de version local et distant (tlchargement de self.serveur/install.ini)
        si local infrieur  distant, lance la mise  jour
        """
        # version du client actuellement install
        if not os.path.isfile(self.conf_f):
            self.affiche("Fichier %s introuvable"%self.conf_f, 'red')
            self.log.error("Fichier %s introuvable"%self.conf_f)
            return False
        self.cur_ver = int(get_option(self.conf_f, 'global', 'version'))
        # version = 0 sur la station permet de dsactiver la MAJ du client Scribe
        if self.cur_ver == 0:
            self.affiche("Mise a jour desactivee sur cette machine (Version locale = 0)", 'orange')
            self.log.warning("Mise a jour desactivee sur cette machine (Version locale = 0)")
            return 'wait'
        # tlchargement de http://<scribe>/install.ini
        self.tmp_conf_f = self.download(self.conf_f_name)
        if not self.tmp_conf_f: return False
        # rcupration du numro de version distant
        self.new_ver = int(get_option(self.tmp_conf_f, 'global', 'version'))
        self.log.info('Test de version => current : %s, new : %s'%(self.cur_ver, self.new_ver))
        self.old_ver = self.cur_ver
        # version = 0 sur le serveur permet de dsactiver la MAJ du client Scribe sur toutes les stations
        if self.new_ver == 0:
            self.affiche('Mise a jour du client desactivee (version serveur = 0)', 'orange')
            self.log.warning('Mise a jour du client desactivee (version serveur = 0)')
            self.clean_tmp()
            return 'wait'
        # numro de version suprieur ou gal  celui du serveur et client dj install
        if self.cur_ver >= self.new_ver:
            key = r'Software\Microsoft\Windows\CurrentVersion\Uninstall\CliEole_is1'
            if not reg.get_option(key, 'UninstallString'):
                self.log.info('Cl "%s" non trouve'%key)
                return True
            self.affiche('Rien a faire ...', 'green')
            self.log.info('Rien a faire ...')
            return False
        return True

    def uninstall_old(self):
        """dsinstallation de l'ancien paquet
        - par uninstall si le prcdent tait clieole-setup.exe (mode silencieux "/verysilent")
        - par l'ancienne mthode pour cliscribe V1
        """
        old = reg.get_option(r'Software\Microsoft\Windows\CurrentVersion\Uninstall\CliScribe_is1', 'UninstallString')
        # cas InnoSetup
        if not old:
            self.log.info('Rien a desinstaller')
            return True
        self.affiche(u'Dsinstallation de la version %s'%self.old_ver, 'orange')
        self.log.info(u'Desinstallation de la version %s'%self.old_ver)
        # Tester si a redmarre tout seul si ncessaire.
        # options eventuelles d'installation
        try: uninst_args = get_option(self.tmp_conf_f, 'global', 'uninst_args')
        except: uninst_args = ''
        cmd = '%s %s'%(eval(old), uninst_args)
        self.log.debug(cmd)
        ret = lancecmd(cmd)
        if ret != 0:
            self.log.error(u'Desinstallation echouee (code retour : %s)'%ret)
            return False
        # l'installeur InnoSetup n'arrive pas  redmarrer quand il est lanc par le service
        self.reboot()
        return 'reboot'

    def clean_tmp(self):
        """purge du rpertoire temporaire
        """
        try: shutil.rmtree(self.tmpdir)
        except: pass
        return True

    ####################
    ## tlchargement ##
    ####################
    def download(self, fich):
        """supprime le rpertoire self.tmpdir et le recre
        tlcharge "fich" et "fich.MD5SUM" et compare les checksums
        """
        self.affiche('Tlchargement de %s'%fich, 'orange')
        try:
            if not os.path.exists(self.tmpdir):
                os.makedirs(self.tmpdir)
            return self.get_file(fich)
        except Exception, e:
            self.log.error(e)
            return False

    def get_file(self, fich):
        """tlcharge "fich" et "fich.MD5SUM" sur self.serveur
        calcul le checksum de fich et le compare  celui contenu dans "fich.MD5SUM"
        """
        dest = os.path.join(self.tmpdir, fich)
        dest5 = '%s.MD5SUM'%dest
        for i in [dest, dest5]:
            if os.path.exists(i):
                os.remove(i)
        url = 'http://%s:%s/%s'%(self.serveur, self.port, fich)
        url5 = '%s.MD5SUM'%url
        self.log.debug(u'Telechargement de %s'%url)
        for i in range(5): # 5 essais pour tlcharger
            try:
                fc = urllib2.urlopen(url).read()
                break
            except Exception, e:
                self.log.error(e)
                if i == 4: return
                time.sleep(2) # attendre
        file(dest, 'wb').write(fc)
        # le md5sum
        self.log.debug(u'Telechargement de %s'%url5)
        for i in range(5): # 5 essais pour tlcharger
            try:
                fc5 = urllib2.urlopen(url5).read()
                break
            except Exception, e:
                self.log.error(e)
                if i == 4: return
                time.sleep(2) # attendre
        file(dest5, 'wb').write(fc5)
        if not self.check_sum(dest, dest5): return False
        return dest

    def check_sum(self, fich, sumfich):
        """rcupre le checksum contenu dans sumfich,
        calcule le checksum de fich
        et compare les deux
        """
        orig_sum = file(sumfich, 'r').readlines()[0].strip().split()[0].strip()
        dest_sum = md5.md5(file(fich, 'rb').read()).hexdigest().strip()
        if orig_sum == dest_sum:
            self.log.debug('checksum OK %s'%orig_sum)
            return True
        else:
            self.log.error('checksum ERROR : %s=%s, %s=%s'%(sumfich, orig_sum, fich, dest_sum))
            return False

    #################
    ## redmarrage ##
    #################
    def reboot(self): #, message="", timeout=0, bForce=0, bReboot=1):
        """Sur XP < SP2 le redmarrage lors de la MAJ plantouille, il faut ouvrir une session
        aussitt le systme redmarre. Pas de pb apparent avec SP2 (et vista)
        """
        if not self.restart: return
        self.log.info('Redemarrage')
        time.sleep(2)
        if self.type_os in ['WinXP', 'Win2K', 'Vista']:
            AdjustPrivilege('SeShutdownPrivilege')
            while True:
##                wa.WinExec('shutdown -r -t 0 -f', 0)
                # Diffrentes mthode pour redmarrer mais la suivante semble tre la plus officielle
                try:
                    wa.InitiateSystemShutdown(None, '', 0, True, 1) #message, timeout, bForce, bReboot)
                    break
                except Exception, e:
                    continue
##                    self.log.debug('%s'%e)
##                try:
##                    wa.ExitWindowsEx(wc.EWX_REBOOT|wc.EWX_FORCE, 0)
##                    break
##                except Exception, e:
##                    self.log.debug('%s'%e)
##                try:
##                    wts.WTSShutdownSystem(wts.WTS_CURRENT_SERVER_HANDLE, wts.WTS_WSD_REBOOT)
##                    break
##                except Exception, e:
##                    self.log.debug('%s'%e)
                time.sleep(2)
        elif self.type_os in ['Win95']:
            cmd = os.path.join(os.environ['WINDIR'], r'system\runonce.exe -q')
            wa.WinExec(cmd)
        reactor.stop()

def ret_update(ret=True):
    if not ret and option.get_log_level() <= logging.DEBUG:
##    if option.get_log_level() <= logging.DEBUG:
        reactor.callLater(40, reactor.stop)
    else: reactor.stop()

def main():
    # Vista n'affiche pas les popup des services dans l'environnement utilisateur mais sur une interface " ct".
    # On laisse quand mme une possiblit de l'afficher en DEBUG
    if type_os == 'Vista' and option.get_log_level() > logging.DEBUG:
        updt = upDater()
        d = threads.deferToThread(updt.update)
        d.addCallback(ret_update)
        d.addErrback(ret_update)
    else:
        app = wx.PySimpleApp()
        frame = UpdaterFrame()
        frame.Show()
        reactor.registerWxApp(app)
    reactor.run()

if __name__ == '__main__':
    main()
