Type Net_API_Status=Word;

Function NetJoinDomain(const lpServer: PWChar; const lpDomain:PWChar;const lpAccountOU: PWChar;
                       const lpAccount: PWChar; const lpPassword:PWChar; const fJoinOptions: DWord)
                       : NET_API_STATUS; stdcall; external 'netapi32.dll';

Function CodeDecode(s:string):string;
Var sr:String;
  i:Integer;
Begin
sr:='';
If s<>'' Then For i:=1 to length(s) Do sr:=sr+chr(ord(s[i]) Xor $da);
CodeDecode:=sr;
End;

Function ExecAndWait(ExecFile:PChar; TimeOut:Word; AllowKill:Boolean; Show:Boolean):Integer;
Var
  PROCESSINFO : TProcessInformation;
  STARTUPINFO : TStartupInfo;
  lpExitCode  : Cardinal;
  Msg         : TMsg;
  sTime       : TDateTime;
  hrs,mins,secs,msecs: Word;

Begin
  sTime:=SysUtils.Time;
  Result := 0;
  With STARTUPINFO do begin
    cb          := SizeOf(STARTUPINFO);
    lpReserved  := nil;
    lpDesktop   := nil;
    lpTitle     := nil;
    dwFlags     := STARTF_USESHOWWINDOW;
    lpReserved  := nil;
    cbReserved2 := 0;
    lpReserved2 := nil;
    If Show then
      wShowWindow := SW_NORMAL
    else
      wShowWindow := SW_HIDE;
  end;
  If CreateProcess(nil,ExecFile,nil,nil,False,NORMAL_PRIORITY_CLASS,nil,nil,
                   STARTUPINFO,PROCESSINFO) then begin
    Repeat
      While PeekMessage(Msg,0,0,0,PM_REMOVE) do begin
        If Msg.message = WM_QUIT then Halt(Msg.wParam);
        TranslateMessage(Msg);
        DispatchMessage(Msg);
      end;
      GetExitCodeProcess(PROCESSINFO.hProcess,lpExitCode);
      decodetime (sysutils.time-stime,hrs,mins,secs,msecs);
      hrs:=hrs*60+mins;
      hrs:=hrs*60+secs;
      If (TimeOut > 0) and (TimeOut < hrs) then begin
        Result := 1;
        If AllowKill then begin
          If TerminateProcess(PROCESSINFO.hProcess,0) then
            Result := 2
          else
            Result := 3;
        end;
        Break;
      end;
    Until lpExitCode <> STILL_ACTIVE;
    With PROCESSINFO do begin
      CloseHandle(hThread);
      CloseHandle(hProcess);
    end;
    If Result = 0 then Result := lpExitCode;
  end
  else Result := GetLastError;
end;

Procedure Reboot;
Var sTokenIn,sTokenOut : TTOKENPRIVILEGES ;
    dwLen : DWORD ;
    hCurrentProcess,hToken : THANDLE ;
    Luid1 : TLargeInteger ;  // LUID ;
Begin
  // Handle du process en cours
  hCurrentProcess := GetCurrentProcess ;
  OpenProcessToken (hCurrentProcess,TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY, hToken);
  // valeur du privilege SHUTDOWN
  LookupPrivilegeValue(nil,'SeShutdownPrivilege',Luid1) ;
  sTokenIn.PrivilegeCount := 1;
  sTokenIn.Privileges[0].Luid := Luid1;
  sTokenIn.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED;
  // Ajustement du privilege avec les nouvelles valeurs
  AdjustTokenPrivileges ( hToken, FALSE, sTokenIn,sizeof(TTOKENPRIVILEGES),sTokenOut, dwLen);
  CloseHandle (hToken);
  ExitWindowsEx(EWX_REBOOT {or EWX_FORCE}, 0) ;//Sortie NT
End;

function GetOS: String;
//--------------------------------------------------------------------------
// *** Information about Win32CSDVersion ***
// In the Win 9x family, Win32CSDVersion detects Win 95 OSR2 and Win 98 SE
// In the Win NT family, Win32CSDVersion detects Service Pack information
// CSD is an acronym for Corrective Service Disk
//--------------------------------------------------------------------------
var
  PlatformId, VersionNumber: string;
  CSDVersion: String;
begin
  CSDVersion := '';

  // Detect platform
  case Win32Platform of
    // Test for the Windows 95 product family
    VER_PLATFORM_WIN32_WINDOWS:
    begin
      if Win32MajorVersion = 4 then
        case Win32MinorVersion of
          0:  if (Length(Win32CSDVersion) > 0) and
                 (Win32CSDVersion[1] in ['B', 'C']) then
                PlatformId := '95 OSR2'
              else
                PlatformId := '95';
          10: if (Length(Win32CSDVersion) > 0) and
                 (Win32CSDVersion[1] = 'A') then
                PlatformId := '98 SE'
              else
                PlatformId := '98';
          90: PlatformId := 'ME';
        end
      else
        PlatformId := '9x version (unknown)';
    end;
    // Test for the Windows NT product family
    VER_PLATFORM_WIN32_NT:
    begin
      if Length(Win32CSDVersion) > 0 then CSDVersion := Win32CSDVersion;
      if Win32MajorVersion <= 4 then
        PlatformId := 'NT'
      else
        if Win32MajorVersion = 5 then
          case Win32MinorVersion of
            0: PlatformId := '2000';
            1: PlatformId := 'XP';
            2: PlatformId := 'Server 2003';
          end
        else if (Win32MajorVersion = 6) and (Win32MinorVersion = 0) then
          PlatformId := 'Vista'
        else
          PlatformId := 'Future Windows version (unknown)';
    end;
  end;
  VersionNumber := Format(' Version %d.%d Build %d %s', [Win32MajorVersion,
                                                        Win32MinorVersion,
                                                        Win32BuildNumber,
                                                        CSDVersion]);
  Result := 'Microsoft Windows ' + PlatformId + VersionNumber;
end;

 function GetOSId: String;
//--------------------------------------------------------------------------
// *** Information about Win32CSDVersion ***
// In the Win 9x family, Win32CSDVersion detects Win 95 OSR2 and Win 98 SE
// In the Win NT family, Win32CSDVersion detects Service Pack information
// CSD is an acronym for Corrective Service Disk
//--------------------------------------------------------------------------
var
  PlatformId, VersionNumber: string;
  CSDVersion: String;
begin
  CSDVersion := '';

  // Detect platform
  case Win32Platform of
    // Test for the Windows 95 product family
    VER_PLATFORM_WIN32_WINDOWS:
    begin
      if Win32MajorVersion = 4 then
        case Win32MinorVersion of
          0:  if (Length(Win32CSDVersion) > 0) and
                 (Win32CSDVersion[1] in ['B', 'C']) then
                PlatformId := '95 OSR2'
              else
                PlatformId := '95';
          10: if (Length(Win32CSDVersion) > 0) and
                 (Win32CSDVersion[1] = 'A') then
                PlatformId := '98 SE'
              else
                PlatformId := '98';
          90: PlatformId := 'ME';
        end
      else
        PlatformId := '9x version (unknown)';
    end;
    // Test for the Windows NT product family
    VER_PLATFORM_WIN32_NT:
    begin
      if Length(Win32CSDVersion) > 0 then CSDVersion := Win32CSDVersion;
      if Win32MajorVersion <= 4 then
        PlatformId := 'NT'
      else
        if Win32MajorVersion = 5 then
          case Win32MinorVersion of
            0: PlatformId := '2000';
            1: PlatformId := 'XP';
            2: PlatformId := 'Server 2003';
          end
        else if (Win32MajorVersion = 6) and (Win32MinorVersion = 0) then
          PlatformId := 'Vista'
        else
          PlatformId := 'Future Windows version (unknown)';
    end;
  end;
  VersionNumber := Format(' Version %d.%d Build %d %s', [Win32MajorVersion,
                                                        Win32MinorVersion,
                                                        Win32BuildNumber,
                                                        CSDVersion]);
  Result := PlatformId;
end;

Function IsWin64: Boolean;
var
  KernelModule: HMODULE;
  GetNativeSystemInfoFunc: procedure(var lpSystemInfo: TSystemInfo); stdcall;
  IsWow64ProcessFunc: function(hProcess: THandle; var Wow64Process: BOOL): BOOL; stdcall;
  Wow64Process: BOOL;
  SysInfo: TSystemInfo;
 
  function AreFsRedirectionFunctionsAvailable: Boolean;
  var
    Wow64DisableWow64FsRedirectionFunc: function(var OldValue: Pointer): BOOL; stdcall;
    Wow64RevertWow64FsRedirectionFunc: function(OldValue: Pointer): BOOL; stdcall;
  begin
    Wow64DisableWow64FsRedirectionFunc := GetProcAddress(GetModuleHandle(kernel32), 'Wow64DisableWow64FsRedirection');
    Wow64RevertWow64FsRedirectionFunc := GetProcAddress(GetModuleHandle(kernel32), 'Wow64RevertWow64FsRedirection');
    Result := Assigned(Wow64DisableWow64FsRedirectionFunc) and Assigned(Wow64RevertWow64FsRedirectionFunc);
  end;
 
begin
  { Le systeme est considr comme "Win64" si toutes ces conditions sont respectes:
    1. GetNativeSystemInfo est valide.
    2. IsWow64Process est valide et returne vrai pour ce processus.
    3. Wow64DisableWow64FsRedirection est valide.
    4. Wow64RevertWow64FsRedirection est valide.
    5. GetSystemWow64DirectoryA est valide.
    6. RegDeleteKeyExA est valide. // }
  Result := False;
  KernelModule := GetModuleHandle(kernel32);
  GetNativeSystemInfoFunc := GetProcAddress(KernelModule, 'GetNativeSystemInfo');
  if Assigned(GetNativeSystemInfoFunc) then begin
    GetNativeSystemInfoFunc(SysInfo);
    IsWow64ProcessFunc := GetProcAddress(KernelModule, 'IsWow64Process');
    if Assigned(IsWow64ProcessFunc) and IsWow64ProcessFunc(GetCurrentProcess, Wow64Process) and Wow64Process then begin
      if AreFsRedirectionFunctionsAvailable and (GetProcAddress(KernelModule, 'GetSystemWow64DirectoryA') <> nil) and (GetProcAddress(GetModuleHandle(advapi32), 'RegDeleteKeyExA') <> nil) then
        Result := True;
    end;
  end;
  FreeLibrary(KernelModule);
end;

