#!/usr/bin/env python
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# manage_stations.py
#
# Librairie de gestion des stations allumées
#
#
###########################################################################

######################################################
#                                                    #
# récupère la liste des stations allumées
# dans le fichier '/var/lib/eole/stations_up.txt' #
# vérifie si un utilisateur y a une session ouverte  #
# peut vérifier si la station est réellement ON      #
#                                                    #
######################################################

import pickle
import sys
sys.path.append('/usr/share/eole/client')
from os import system
from os.path import join
import socket
from getopt import getopt, GetoptError
import config
from cliscribe import Cliscribe, reactor
from connexions import Connexions

class manage_station:

    def __init__(self):
        self.fich = join(config.vareole, 'stations_up.txt')
        self.get_stations()

    def purge(self):
        file(self.fich, 'w').write('')
        self.get_stations()

    def get_stations(self):
        """renvoie [(ip, nom_machine), (ip2, nom_mach2), ...]
        """
        try:
            self.stations = pickle.load(file(self.fich, 'r'))
        except:
            self.stations = []

    def add_station(self, ip, nom=None):
        if not nom: nom = ip
        station = (ip, nom)
        for item_ip, item_name in self.stations:
            if ip == item_ip:
                self.del_station(ip)
        self.stations.append(station)

    def del_station(self, ip):
        """supprime une station de la liste à partir de son IP
        """
        nstations_l = []
        for station in self.stations:
            if station[0] != ip: nstations_l.append(station)
        self.stations = nstations_l

    def flush(self):
        pickle.dump(self.stations, file(self.fich, 'w'))

    def verif_station(self, ip):
        """vérifie si la station IP est bien ON
        en se connectant au service Scribe
        """
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.settimeout(1)
        try:
            s.connect((ip, 8788))
            s.close()
            return True
        except:
            return False

    def print_stations(self, verif = None):
        """Affiche la liste des stations
        """
        if self.stations:
            liste = ''
            connectes = self.get_connectes()
            user = ''
            for sta in self.stations:
                for conn in connectes:
                    if sta[0] == conn[1]:
                        user = conn[0]
                        break
                    else: user = ''
                if not verif:
                    #print ";%s, %s, %s"%(sta[0], sta[1], user)
                    liste += "%s, %s, %s;" % (sta[0], sta[1], user)
                elif self.verif_station(sta[0]):
                    #print "%s, %s, %s;"%(sta[0], sta[1], user)
                    liste += "%s, %s, %s;" % (sta[0], sta[1], user)
            print liste[:-1]
        return

    def get_name(self, ip):
        """renvoie le nom de la station à partir de son IP
        """
        nom = ip
        if len(self.stations) > 0:
            for sta in self.stations:
                if sta[0] == ip:
                    nom = sta[1]
                    break
        return nom

    def shutdown_sta(self, ip, reboot=0):
        """Appelle la fonction distante remote_shutdown du client Scribe
        reboot : 0=halt, 1=reboot, 2=logoff
        """
        nom = self.get_name(ip)
        try :
            force = False
            if int(reboot) == 0:
                label = 'Extinction de'
                self.del_station(ip)
                self.flush()
            elif int(reboot) == 1:
                label = 'Redémarrage de'
                self.del_station(ip)
                self.flush()
            elif int(reboot) == 2:
                if not Connexions().has_session(ip):
                    print "Aucune session n'est ouverte sur %s (%s)" % (nom, ip)
                    return
                label = 'Fermeture de session sur'
                force = True
            d = Cliscribe(ip, disconnect=False).shutdown(reboot=reboot, force=force)
            d.addCallback(lambda _: reactor.stop())
            d.addErrback(lambda _: reactor.stop())
            reactor.run()
            print '%s %s' % (label, nom)
        except Exception, e:
            print "L'action sur %s a échoué, Erreur : %s" % (nom, e)
            pass

    def get_connectes(self):
        """récupère la liste des connectés
        renvoie [(uid, ip), (uid2, ip2), ...]
        """
        return [(i[0], i[4]) for i in Connexions().sessions]

def purge():
    m = manage_station()
    m.purge()
    return

def liste_sta(verify=None):
    m = manage_station()
    m.print_stations(verif = verify)
    return

def add_sta(ip, nom=None, ost=None, mac=None):
    if nom and ost:
        system('/usr/share/eole/client/renseigne_machine.sh %s %s %s %s' % (nom, ip, ost, mac))
    if not nom: nom = ip
    m = manage_station()
    m.add_station(ip, nom)
    m.flush()
    return True

def del_sta(ip):
    m = manage_station()
    m.del_station(ip)
    m.flush()
    return True

def myhelp():
    print """Usage :
%s -l --liste (-v --verify)
%s -s IP --shutdown ip
%s -t VAL --type_shutdown VAL (0=halt, 1=reboot, 2=logoff)
""" % (sys.argv[0], sys.argv[0], sys.argv[0])

def main():
    m = manage_station()
    liste = None
    verify = None
    shutdown = None
    reboot = 0
    try:
        options, args = getopt(sys.argv[1:], 's:t:hlv',
        ['shutdown=',
        'type_shutdown=',
        'help',
        'liste',
        'verify'])

    except GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg.split(' ')[1])

    for (opt, val) in options:
        # quel support
        if (opt == '-s') or (opt == '--shutdown'):
            shutdown = 1
            ip = val.lower()
        elif (opt == '-t') or (opt == '--type_shutdown'):
            reboot = val
        #listing
        elif (opt == '-l') or (opt == '--liste'):
            liste = 1
        elif (opt == '-v') or (opt == '--verify'):
            verify = 1
        else:
            myhelp()

    if shutdown:
        m.shutdown_sta(ip, reboot)
    elif liste:
        m.print_stations(verif = verify)
    else:
        myhelp()


if __name__ == "__main__":
    main()

