#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_

import reg , logging, os

def get_gp_log_level():
    """renvoie le niveau de log pour "gestion-postes"
    """
    log_conf = 'log_level.txt'
    if not os.path.isfile(log_conf):
        return logging.INFO
    try:
        llevel = file(log_conf).readline().strip().upper()
        if llevel in ['CRITICAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG']:
                return getattr(logging, llevel)
    except:
        return logging.INFO

def get_log_level():
    try:
        llevel = get_log_string().upper()
        if llevel in ['CRITICAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG']:
            return getattr(logging, llevel)
        return logging.INFO
    except:
        return logging.INFO

def get_log_string():
    return reg.get_option(r'Software\Eole\Scribe', 'log_level')

def get_debug_logon():
    return reg.get_option(r'Software\Eole\Scribe', 'debug_logon')

def get_inst_args():
    return reg.get_option(r'Software\Eole\Scribe', 'inst_args')

def get_inst_path():
    return reg.get_option(r'Software\Eole\Scribe', 'inst_path')

def get_ip_access_list():
    return eval(reg.get_option(r'Software\Eole\Scribe', 'ip_access_list'))

def get_ip_scribe():
    return reg.get_option(r'Software\Eole\Scribe', 'ip_scribe')

def get_nom_domaine():
    return reg.get_option(r'Software\Eole\Scribe', 'nom_domaine')

def get_nom_scribe():
    return reg.get_option(r'Software\Eole\Scribe', 'nom_scribe')

def get_port_client():
    return reg.get_option(r'Software\Eole\Scribe', 'port_client')

def get_port_scribe():
    return reg.get_option(r'Software\Eole\Scribe', 'port_scribe')

def get_port_scribe_update():
    return reg.get_option(r'Software\Eole\Scribe', 'port_scribe_update')

def get_port_utilisateur():
    return reg.get_option(r'Software\Eole\Scribe', 'port_utilisateur')

def get_vnc_viewonly():
    return reg.get_option(r'Software\Eole\Scribe', 'vnc_viewonly')

def get_download_attempts():
    return reg.get_option(r'Software\Eole\Scribe', 'download_attempts')

def get_network_timeout():
    return reg.get_option(r'Software\Eole\Scribe', 'network_timeout')


## Esu ##
def get_esu_clean_reg():
    return reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'CleanRegistry')

def get_esu_show_username():
    return reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'ShowUsername')

def get_esu_disconnect_bad_user():
    return reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'DisconnectBadUsers')

def get_esu_mode_debug():
    return reg.get_option(r'SOFTWARE\CRDP Bretagne\ESU', 'ModeDebug')

