#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_


import re
import os
import logging
import traceback
import win32print as wp
import win32api as wa
from reg import get_option

# LImprimantes
# SetDefautPrinter
# DelNotInList

MACHINE = wa.GetComputerName()

def liste_printers():
    """Liste les imprimantes connectes depuis le rseau
    """
    liste = [i[2] for i in wp.EnumPrinters(wp.PRINTER_ENUM_CONNECTIONS)]
    return liste

def remove_printers():
    """Dsinstalle les imprimantes si paramtr dans Esu
    """
    if get_option(r'Software\CRDP Bretagne\esu', 'DelNotInList', 'HKEY_CURRENT_USER') == 1:
        logging.info('Desinstallation des imprimantes non gerees')
        for printer in liste_printers():
            logging.debug('Desinstallation de "%s"'%printer)
            try: wp.DeletePrinterConnection(printer)
            except Exception, e:
                logging.error("""Erreur de suppression de l'imprimante %s, erreur : "%s" """%(printer, e))
                logging.debug('Erreur %s'%traceback.format_exc())

def get_esu_printers():
    return get_option(r'Software\CRDP Bretagne\esu', 'LImprimantes', 'HKEY_CURRENT_USER')

def install_printers():
    remove_printers()
    printers = get_esu_printers()
    if not printers:
        logging.debug('Aucune imprimante configuree')
        return
    for printer in printers.split(','):
        printer = printer.strip()
        if test_printer(printer):
            logging.info("Installation de l'imprimante \"%s\""%printer)
            try: wp.AddPrinterConnection(printer)
            except Exception, e:
                logging.error("""Erreur de connexion de l'imprimante %s, erreur : "%s" """%(printer, e))
                logging.debug('Erreur %s'%traceback.format_exc())
        else: logging.debug('"%s" est une imprimante locale'%printer)
    setdefault()

def setdefault():
    """Place la premire comme imprimante par dfaut
    """
    try:
        printers = get_esu_printers()
        if get_option(r'Software\CRDP Bretagne\esu', 'SetDefautPrinter', 'HKEY_CURRENT_USER') == 1 and printers:
            printer = printers.split(',')[0]
            printer_name = get_nom_imprimante(printer)
            if printer_name:
                logging.debug("""Definition de l'imprimante "%s" : "%s" par defaut"""%(printer, printer_name))
                wp.SetDefaultPrinter(printer_name)
    except Exception, e:
        logging.error("Erreur lors de la mise en place de l'imprimante par defaut : %s"%e)
        logging.debug('Erreur %s'%traceback.format_exc())

def get_nom_imprimante(partage):
    """rcupre le nom de l'imprimante <partage>
    "\\VM-XP2\compaq" => "\\VM-XP2\Compaq IJ600 Inkjet Printer"
    """
    for i in wp.EnumPrinters(wp.PRINTER_ENUM_CONNECTIONS, None, 2):
        if partage.lower() == os.path.join(i['pServerName'], i['pShareName']).lower():
            return i['pPrinterName']
    logging.debug("nom de l'imprimante %s non trouve"%partage)

def test_printer(printer):
    regexp = r'\\\\([^\\]+)\\'
    res = re.match(regexp, printer.strip())
    if not res:
        logging.debug("""Mauvaise syntaxe pour l'imprimante "%s" """%printer)
        return False
    if res.group(1).upper() == MACHINE.upper():
        logging.debug('Imprimante "%s" connectee localement, rien a faire.'%printer)
        return False
    return True
