# _*_ coding: iso-8859-1 _*_
#!/usr/bin/python


#TTF_FILENAME = "/usr/share/fonts/truetype/ttf-dejavu/DejaVuSerif-Bold.ttf"
TTF_FILENAME = "Arial.ttf"
#TTF_FILENAME = "C:\Windows\Fonts\Arial.ttf"
BORDER = 5
FONT_BIG = 24
FONT_SMALL = 20
FONT_COLOR = "white"

from sys import stderr, argv, exit
import Image
import ImageDraw
import ImageFont
import os
from encodage import utftoiso

def renderMosaic(image, orig_image):
    # Render image mosaic
    y = 0
    while y < image.size[1]:
        x = 0
        while x < image.size[0]:
            image.paste(orig_image, (x,y))
            x += orig_image.size[0]
        y += orig_image.size[1]

def renderImage(input_filename, output_filename, mode, messages, bgcolor=None, resolution=None):
    """
    Cree une image de la taille resolution (tuple (largeur, hauteur)
    en pixels) avec comme couleur de fond bgcolor (voir ImageColor).

    Utilise l'image input_filename et sauve le rsultat dans output_image.
    Si input_filename n'est pas une chane vide (''), mode dtermine comment
    l'image est rendue :
    - "centre" : centre l'image source
    - "etendre" : redimensionne l'image source  la taille de sortie
    - "mosaique" : rpte l'image pour crer une mosaque

    messages est une liste de chane de caractres qui seront crites
    en haut  droite.
    """
    if bgcolor:
        BACKGROUND_COLOR = bgcolor
    else:
        BACKGROUND_COLOR = '#004e98'
    if resolution:
        size = resolution
    else:
        size = (1024, 768)
    # Create destination image
    image = Image.new("RGB", size)
    width = image.size[0]
    draw = ImageDraw.Draw(image)

    # Fill with color
    draw.rectangle([(0,0), image.size], fill=BACKGROUND_COLOR)

    try:
        if input_filename and os.path.isfile(input_filename):
            orig_image = Image.open(input_filename).convert("RGB")
            if mode == "etendre":
                orig_image = orig_image.resize(image.size, Image.ANTIALIAS)
                image.paste(orig_image, (0,0))
            elif mode == "centre":
                x = (image.size[0] - orig_image.size[0]) // 2
                y = (image.size[1] - orig_image.size[1]) // 2
                image.paste(orig_image, (x,y))
            else: # mode == "mosaique"
                renderMosaic(image, orig_image)
    except:
        pass

    # Render text
    ttf_big = ImageFont.truetype(TTF_FILENAME, FONT_BIG)
    ttf_small = ImageFont.truetype(TTF_FILENAME, FONT_SMALL)
    y = BORDER
    count = 0
    for message in messages:
        message = utftoiso(message)
        count += 1
        if 1 < count:
            font = ttf_small
        else:
            font = ttf_big
        size = font.getsize(message)
        x = width - BORDER - size[0]
        draw.text((x, y), message, font=font, fill=FONT_COLOR)
        y += size[1]

    # Save image result
    image.save(output_filename)

def main():
    if len(argv) < 4 or argv[3] not in ("etendre", "centre", "mosaique"):
        print >>stderr, "usage: %s input output mode message1 message2 ..." % argv[0]
        print >>stderr, 'mode: "etendre", "centre" ou "moisaique"'
        exit(1)
    charset = "UTF-8"
    messages = [unicode(item, charset) for item in argv[3:]]
    renderImage(argv[1], argv[2], argv[3], messages)

if __name__ == "__main__":
    main()

