#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_


import logging
from PyNetstat import getOpenPorts
import time
import os

import process
from lance_cmd import lancecmd



# Lance les commandes VNC dans l'environnement utilisateur
# Utile pour Vista
class VncUser:
    """Gestion vnc distante. Actions possibles :
            - start_listen / stop_listen
            - connect / disconnect
    """
    def __init__(self, vncdir):
##        print vncdir
        self.vncdir = vncdir
        self.vnc_conf = os.path.join(self.vncdir, 'eole_conf.vnc')
        self.winvnc_exe = os.path.join(self.vncdir, 'winvnc.exe')
        self.vncviewer = os.path.join(self.vncdir, 'vncviewer.exe')


    ############
    ## WinVNC ##
    ############
    def start(self):
        """Dmarre winvnc dans l'environnement de l'utilisateur (Vista oblige)
        """
        logging.debug('Tentative de demarrage de winvnc')
        if self._is_serv_listening(): return True
        self._stop()
        logging.debug('Demarrage de winvnc')
        lancecmd(self.winvnc_exe, nowait=True)
        # attendre qques secondes que vnc dmarre
        for i in range(100):
            if self._is_serv_listening():
                logging.debug('"winvnc" en ecoute')
                return True
            time.sleep(0.1)
        return False

    def _is_serv_listening(self):
        """Test si le port 5900 ('winvnc.exe') est ouvert
        """
##        if 1:
        if "5900/TCP" in getOpenPorts():
            return True
        else:
            return False

    def _stop(self):
        """Mthode la plus sre (radicale) pour arrter "winvnc"
        A pour inconvnient de laisser l'icne  ct de l'heure.
        """
        logging.debug("Tentative d'arret de winvnc")
        if not self._isrunning(): return True
        logging.debug('Arret de winvnc')
        ret = process.killProcName('winvnc.exe')
        time.sleep(1)
        return ret

    def _isrunning(self):
        """Y'a-t-il un procesus "winvnc.exe" ?
        """
        return process.isrunning('winvnc.exe')

    def connect(self, ip):
        """connecter une ip qui est en mode "listen"
        => Envoyer son cran sur "ip"
        """
        if self.start(): return lancecmd('%s -connect %s'%(self.winvnc_exe, ip), nowait=True)
        logging.error('Erreur de connexion sur "%s"'%ip)
        return False

    def disconnect(self):
        """Arrte winvnc.exe
        """
        self._stop()

    ################
    ## VNC Viewer ##
    ################
    def start_listen(self, args=None):
        """se mettre en mode listen
        => Attendre que qqun envoie son cran
        """
        if self._is_listening(): return True
        if not args: args = ''
        cmd = '%s /config "%s" /listen %s'%(self.vncviewer, self.vnc_conf, args)
        lancecmd(cmd.strip(), nowait=True)
        for i in range(100):
            if self._is_listening():
                logging.debug('"vncviewer" en ecoute')
                return True
            time.sleep(0.1)
        return False

    def _is_listening(self):
        """Test si le port 5400 ('vncviewer /listen') est ouvert
        NE PAS tester le port 5500, a fait gueuler 'vncviewer /listen' (DSM plugin toussa)
        """
        if "5500/TCP" in getOpenPorts():
            return True
        else:
            return False

    def stop_listen(self):
        """kill self.listen_pid"""
        process.killProcName('vncviewer.exe')

    def view(self, ip, args=None, conf=None):
        """Mode  l'ancienne, utilise pour Win9x
        """
        if not args: args = ''
        if conf: file(self.vnc_conf, 'w').write(conf)
        cmd = '%s /config "%s" %s %s'%(self.vncviewer, self.vnc_conf, args, ip)
        lancecmd(cmd, nowait=True)


