# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# gest_sessions.py
#
# Librairie pour la gestion des clients Windows
#
###########################################################################

import sys
from twisted.python import log
sys.path.append('/usr/share/eole/client')
from cliscribe import Cliscribe
import esu

from connexions import Connexions
try:
    from horus import backend
except ImportError:
    import ldap_utils as backend

class Logon:

    def __init__(self):
        """Gestion d'ouverture de session sur les postes clients
        - gestion VNC
        """

    def logon(self, ip, os_type): #, blocage):
        self.ip, self.os_type = ip, os_type
        self.user = Connexions().get_user(self.ip)
        self.userlname = backend.get_user_long_name(self.user)
        self.groups = backend.get_user_groups(self.user)
        self.sid = backend.get_user_sid(self.user)
        logon_dict = esu.ESU(self)._esu_dict
        if not logon_dict:
            log.err('Machine non geree par Esu')
            return ('Err', u'Machine non gérée par Esu')
        try:
            d = Cliscribe(self.ip).logon(logon_dict=logon_dict)
        except Exception, e:
            log.err(e)
            return ('Err', str(e))
        if not logon_dict['esu_dict']['ESU_GU']:
            d.addCallback(lambda _: ('Err', u'Utilisateur non géré par Esu'))
            return d
        return d

