#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_

import os
import logging
import traceback

import option
from os_type import type_os, sp
from lance_cmd import lancecmd
from replace_win_vars import replace_vars


#class Logging:
#    def error(self, a):
#        print a
#    def debug(self, a):
#        print a
#logging = Logging()

def lancecmd_dbg(a, hide=True):
##    print '*****', a
    logging.debug(a)
    try: return lancecmd(a, hide)
    except Exception, e:
        logging.error('%s'%e)
        logging.debug('Erreur %s'%traceback.format_exc())

class Rule:
    """ Representation d'une regle """
    def __init__(self, name, ip_src = "any", ip_dst = "any", action = "allow", proto = "tcp", port_dst = "any", program = None):
        self.name = name
        self.ip_src = ip_src
        self.ip_dst = ip_dst
        self.action = action
        self.proto = proto
        self.port_dst = port_dst
        if program: program = replace_vars(program)
        self.program = program
        self.numero = 0
    def __str__(self):
        if self.program != None:
            return "%s%s: %s %s %s -> %s(%s) '%s'"%(self.numero, self.name, self.action, self.proto, self.ip_src, self.ip_dst, self.port_dst, self.program)
        else:
            return "%s%s: %s %s %s -> %s(%s)"%(self.numero, self.name, self.action, self.proto, self.ip_src, self.ip_dst, self.port_dst)

class ScribeFW:
    """ Firewall generique, contient la liste des rgles appliques """
    def __init__(self):
        self.rule_map = {}

    def SetMode(self, inpt='allow', output='allow'):
        """Dfinit le comportement du parefeu (Vista uniquement)"""
        return

    def AddRule(self, rule):
        """ Ajout d'une rgle """
        # Ajout de la regle a la liste de regles
        name = rule.name
        if name not in self.rule_map:
            self.rule_map[name] = []
        self.rule_map[name].append(rule)

    def DelRule(self, name):
        """ Efface une rgle """
        # Suppression de la regle de la liste de regles
##        if name not in self.rule_map.keys():
##            logging.error('La regle "%s" n\'existe pas.'%name)
##            return False
        #  l'initialisation la liste est vide
        # mais la machine Vista peut contenir des rgles Eole*  supprimer
        self.rule_map.pop(name, True)
        return True

    def ShowRules(self):
        """ Affiche les rgles """
        l = []
        for rules_name in self.rule_map.keys():
            for rule in self.rule_map[rules_name]:
                l.append(rule)
        return l

    def GetRules(self, name):
        """ Renvoie la liste des rgles dont le nom est *name* """
        if name not in self.rule_map.keys():
            logging.error("Impossible de trouver la regle %s"%name)
            return []
        return self.rule_map[name]
    
    def RuleExists(self, name):
        return name in self.rule_map.keys()

    def MakeRuleFromCommand(self, cmd):
        """ Cre un objet Rule  partir d'une commande Scribe (sous forme de chane
        la chane attendue est de la forme:
            name action proto ip_src ip_dst port_dst (program)
        par ex:
            VNC allow tcp any me any C:\VNC.exe

        valeur autorises pour name: chane (sans espace)
        valeur autorises pour action: allow ou block
        valeur autorises pour proto: tcp, udp, icmp ou any
        valeur autorises pour ip_src et ip_dst: any, me ou une ip
        valeur autorises pour port_dst: numro de port
        valeur autorises pour program: chane (espaces supports)
        """

        args = cmd.split()
        if len(args) < 6:
            logging.error("Pas assez d'arguments pour creer une regle.")
            return None
        program = None
        (name, action, proto, ip_src, ip_dst, port_dst) = args[:6]
        if len(args) > 6: # La rgle contient un nom d'application
            program = '"%s"'%' '.join(args[6:])
        return Rule(name, ip_src, ip_dst, action, proto, port_dst, program)

class IpfwFW(ScribeFW):
    """ Controle du pare-feu IpFW """
    def __init__(self, inst_path):
        ScribeFW.__init__(self)
        self.inst_path = inst_path
        self.rule_nbr = 50 # Numro de la premire rgle dans Ipfw
        # dsactivation du parefeu XP SP2
##        logging.info('INIT FW %s %s'%(self.rule_nbr, sp))
        if sp >= '2': lancecmd_dbg('netsh firewall set opmode mode=disable profile=ALL', hide=True)

    def Init_Fw(self):
        # Initialisation de "ipfw"
        lancecmd_dbg("ipfw %s\\wipfw\\wipfw.conf"%self.inst_path)

    def GetRuleStrs(self, regle):
        """ Renvoie la liste des regles IpFW generes, sous forme d'une liste de chane.
            La liste ne contient qu'un seul lment.
        """
        # Verification des arguments
        if regle.program != None:
            logging.debug("IpFW ne gere pas le filtrage par application '%s'"%regle.program)
            return []
        # Verification des ip sources et destination
        if regle.ip_src == "me" and regle.ip_dst == "me":
            logging.error("Ips source et destination invalides")
            return []
        # Verification de l'action
        if regle.action != "allow" and regle.action != "block":
            logging.error('Action "%s" invalide (allow|block).'%regle.action)
            return []
        # Verification du protocol
        if regle.proto != "tcp" and regle.proto != "udp" and regle.proto != "any" and regle.proto != "icmp":
            logging.error('Protocol "%s" invalide.'%regle.proto)
            return []
        elif regle.proto == "icmp" and regle.port_dst != "any":
            logging.error("Impossible de specifier un port destination avec le protocole ICMP")
            return []
 
        # Creation de la regle 
        if regle.action == "block":
            regle.action = "deny"
        if regle.proto == "any":
            regle.proto = "ip"
        if regle.port_dst == "any":
            regle.port_dst = ""
        regle.name = "Eole%s"%regle.name            

        cmd = regle.action + " " + regle.proto + " from " + regle.ip_src + " to " + regle.ip_dst + " " + regle.port_dst
        return [cmd]

    def AddRule(self, regle):
        for cmd_args in self.GetRuleStrs(regle):
            regle.numero = self.rule_nbr
            if self.rule_nbr >= 65532:
                logging.error("Nombre de regle maximal depasse. Impossible de rajouter la regle")
                return
            self.rule_nbr += 1
            lancecmd_dbg("ipfw add %s %s keep-state"%(regle.numero, cmd_args), hide=True)
        ScribeFW.AddRule(self, regle)

    def DelRule(self, name):
        name = "Eole" + name
        if not self.RuleExists(name): return True
        rules = self.GetRules(name)
        for rule in rules:
            lancecmd_dbg("ipfw delete %s"%rule.numero, hide=True)
        return ScribeFW.DelRule(self, name)

    def SetMode(self, inpt, output):
        ALLOWIN = Rule('ALLOWINPUT', ip_src = "any", ip_dst = "me", action = "allow", proto = "any", port_dst = "any")
        BLOCKIN = Rule('BLOCKINPUT', ip_src = "any", ip_dst = "me", action = "block", proto = "any", port_dst = "any")
        ALLOWOUT = Rule('ALLOWOUTPUT', ip_src = "me", ip_dst = "any", action = "allow", proto = "any", port_dst = "any")
        BLOCKOUT = Rule('BLOCKOUTPUT', ip_src = "me", ip_dst = "any", action = "block", proto = "any", port_dst = "any")
        for i in ['ALLOWINPUT', 'BLOCKINPUT', 'ALLOWOUTPUT', 'BLOCKOUTPUT']:
            self.DelRule(i)
##        if inpt == 'allow' and output == 'allow': return True
        if inpt == 'allow' and output == 'block':
            self.AddRule(ALLOWIN)
            self.AddRule(BLOCKOUT)
        elif inpt == 'block' and output == 'block':
            self.AddRule(BLOCKIN)
            self.AddRule(BLOCKOUT)
        elif inpt == 'block' and output == 'allow':
            pass
##            # le mode bloc-allow n'est pas utilis avec ipfw (il l'est avec Vista)
##            self.AddRule(ALLOWOUT)
##            self.AddRule(BLOCKIN)
        else: #UserERR
            logging.error('INPUT : mode inconnu "%s" (block|allow)'%inpt)
            return
        return True
    
    def Activate(self, activate):
        return

class VistaFW(ScribeFW):
    """ Controle du pare-feu Vista """
    def __init__(self):
        ScribeFW.__init__(self)

    def GetRuleStrs(self, regle):
        """ Renvoie la liste des regles de fw Vista generes, sous forme d'une liste de chane.
            La liste PEUT contenir plusierus lments
        """
        # Verification des ip sources et destination
        if regle.ip_src == "me" and regle.ip_dst == "me":
            logging.error("Ips source et destination invalides")
            return
        # Verification de l'action
        if regle.action != "allow" and regle.action != "block":
            logging.error('Action "%s" invalide.'%regle.action)
            return
        # Verification du protocol
        if regle.proto != "tcp" and regle.proto != "udp" and regle.proto != "any" and regle.proto != "icmp":
            logging.error('Protocol "%s" invalide.'%regle.proto)
            return
        elif regle.proto == "icmp" and regle.port_dst != "any":
            logging.error("Impossible de specifier un port destination avec le protocole ICMP")
            return
##        regle.proto = regle.proto.upper()
        regle.name = "Eole" + regle.name            

        # Creation de la regle
        cmd = 'action=%s name="%s"'%(regle.action, regle.name)

        # proto
        if regle.proto != "any":
            cmd += " protocol=%s"%regle.proto
        # program
        if regle.program != None:
            cmd += ' program="%s"' % (regle.program)

        #logging.error(cmd

        if regle.ip_dst == "me": # Connexion entrante
            sub_cmd = cmd + " dir=in"
            if regle.ip_src != "any":
                sub_cmd += " remoteip=%s"%regle.ip_src
            if regle.port_dst != "any":
                sub_cmd += " localport=%s"%regle.port_dst
            return [sub_cmd]

        elif regle.ip_dst == "any": # Connexion sortante
            if regle.ip_src == "me":
                sub_cmd = cmd + " dir=out"
                if regle.port_dst != "any":
                    sub_cmd += " remoteport=" + regle.port_dst
                return [sub_cmd]

            elif regle.ip_src == "any": # Connexion bi-directionnel
                sub_cmd1 = cmd + " dir=in"
                sub_cmd2 = cmd + " dir=out"

                if regle.port_dst != "any":
                    sub_cmd1 += " localport=" + regle.port_dst
                    sub_cmd2 += " remoteport=" + regle.port_dst
                return [sub_cmd1, sub_cmd2]

            else:
                logging.error("Ips sources et distantes invalides.")
                return []
        else:
            if regle.ip_src != "me":
                logging.error("Ips sources et distantes invalides.")
                return []
            else:
                sub_cmd = cmd + " dir=out"
                sub_cmd += " remoteip=" + regle.ip_dst
                if regle.port_dst != "any":
                    sub_cmd += " remoteport=" + regle.port_dst
                return [sub_cmd]

    def Init_Fw(self):
        ## Activation et destruction des anciennes rgles Eole
        lancecmd_dbg('netsh firewall set opmode mode=ENABLE exceptions=ENABLE profile=ALL', hide=True)
        lancecmd_dbg('netsh firewall set opmode mode=ENABLE exceptions=ENABLE', hide=True)
        # Autorisation du Partage de fichiers et d'imprimantes IN & OUT
        lancecmd_dbg('netsh firewall set service type=FILEANDPRINT mode=ENABLE scope=ALL profile=STANDARD', hide=True)
        lancecmd_dbg('netsh firewall set service type=FILEANDPRINT mode=ENABLE scope=ALL profile=CURRENT', hide=True)
        lancecmd_dbg('netsh firewall set service type=FILEANDPRINT mode=ENABLE scope=ALL profile=DOMAIN', hide=True)
        lancecmd_dbg('netsh firewall set service type=FILEANDPRINT mode=ENABLE scope=ALL profile=ALL', hide=True)
        
    def AddRule(self, rule):
        """ Ajoute une regle de filtrage """
        for cmd_args in self.GetRuleStrs(rule):
            lancecmd_dbg("netsh advfirewall firewall add rule " + cmd_args, hide=True)
        ScribeFW.AddRule(self, rule)

    def DelRule(self, name):
        """ Supprime une regle de filtrage """
        name = "Eole%s"%name
        lancecmd_dbg('netsh advfirewall firewall del rule name="%s"' % (name), hide=True)
        return ScribeFW.DelRule(self, name)

    def SetMode(self, inpt, output):
        if inpt == 'allow': inpt = 'allowinbound'
        elif inpt == 'block': inpt = 'blockinbound'
        else:
            logging.error('INPUT : mode inconnu "%s" (block|allow)'%inpt)
            return
        if output == 'allow': output = 'allowoutbound'
        elif output == 'block': output = 'blockoutbound'
        else:
            logging.error('OUTPUT : mode inconnu "%s" (block|allow)'%inpt)
            return
        return lancecmd_dbg('netsh advfirewall set allprofiles firewallpolicy %s,%s'%(inpt, output))
    
    def Activate(self, activate):
        if activate: mode = 'mode=ENABLE exceptions=ENABLE'
        else: mode = 'mode=DISABLE'
        lancecmd_dbg('netsh firewall set opmode %s profile=ALL'%mode, hide=True)
        lancecmd_dbg('netsh firewall set opmode %s'%mode, hide=True)
        return True


####################
class WinFw:
    def __init__(self):
        if type_os in ['WinNT', 'Win2K', 'Win2K3', 'WinXP']: # and sp == '2':
            self.fw = IpfwFW(option.get_inst_path())
        
        elif type_os == 'Vista':
            self.fw = VistaFW()

    def init_fw(self, fich=None):
        logging.debug("Firewall init, fich=%s, os=%s"%(fich, type_os))
        self.fw.Init_Fw()
        #fw.AddRule(Rule("Service", ip_src = "me" , ip_dst = "any", port_dst ="80"))
        # Initialisation de rgles additionnelles  partir d'un fichier
        if not fich: return
        self.addrules_from_file(fich)

    def addrules_from_file(self, fich):
        if not os.path.isfile(fich):
            logging.error('Fichier %s introuvable'%fich)
            return
    ##    if 1:
        try:
            rules, todel = get_rules_from_file(fich)
            for rule in todel:
                try: self.fw.DelRule(rule)
                except Exception, e:
                    logging.error('%s'%e)
                    logging.debug('Erreur %s'%traceback.format_exc())
            for rule in rules:
                try: self.fw.AddRule(rule)
                except Exception, e:
                    logging.error('%s'%e)
                    logging.debug('Erreur %s'%traceback.format_exc())
        except Exception, e:
            logging.error('%s'%e)
            logging.debug('Erreur %s'%traceback.format_exc())
    
    #name, ip_src = <ip>|"any", ip_dst = <ip>|"any", action = "allow|block",
    # proto = "tcp|udp|icmp|any", port_dst = <port>|"any", program = "myprog"
    def addrules(self, lst):
        rules, todel = get_rules_from_list(lst)
        for rule in todel:
            try: self.fw.DelRule(rule)
            except Exception, e:
                logging.error('%s'%e)
                logging.debug('Erreur %s'%traceback.format_exc())
        for rule in rules:
            try: self.fw.AddRule(rule)
            except Exception, e:
                logging.error('%s'%e)
                logging.debug('Erreur %s'%traceback.format_exc())
        
    def addrule(self, rulestr):
        rule = get_rule_from_str(rulestr)
        return self.fw.AddRule(rule)
    
    def delrule(self, name):
        return self.fw.DelRule(name)
    
    def setmode(self, inpt, output):
        return self.fw.SetMode(inpt, output)
    
    def activate(self, activate):
        return self.fw.Activate(activate)
    
    def showrules(self):
        return self.fw.ShowRules()
    
    def getrules(self, name):
        return self.fw.GetRules(name)


def get_rule_from_str(s):
    """s = 'Nom, ip_src=AA, ip_dst=BB, action=CC, proto=DD, port_dst=EE, program=FF'
    """
    s = replace_vars(s)
    name = [i.strip() for i in s.split(';;')][0].replace('"','').replace("'","").strip()
    args = [i.strip() for i in s.split(';;')][1:]
    d = {}
    for arg in args:
        k, v = [i.strip() for i in arg.split('=')]
        v = v.replace('"','').replace("'","").strip()
        d[k] = v
    return Rule(name, **d)
    
def get_rules_from_list(lst):
    rules, todel = [], []
    for li in lst:
        if li.startswith('#') or li == '': continue # ne prend pas les commentaires et lignes vides
        ostype = li.split('::')[0].strip()
        if type_os not in ostype: continue
        rulestr = li.split('::')[1].strip()
        if 'DELETE' in rulestr:
            name = rulestr.split(';;')[0].replace('"','').replace("'","").strip()
            todel.append(name)
        else:
            rules.append(get_rule_from_str(rulestr))
    return rules, todel
        
def get_rules_from_file(fich):
    """Gnre une liste de Rule()  partir du fichier <fich>
    * WinXP|Vista : "Nom", ip_src = "any", ip_dst = "any", action = "allow", proto = "tcp", port_dst = "any", program = None
    et une liste de rgles  supprimer <todel>
    * WinXP|Vista : "Nom", DELETE
    """
    lst = [i.strip() for i in file(fich).readlines()]
    return get_rules_from_list(lst)
##    rules, todel = [], []
##    for li in [i.strip() for i in file(fich).readlines()]:
##        if li.startswith('#') or li == '': continue # ne prend pas les commentaires et lignes vides
##        ostype = li.split('::')[0].strip()
##        if type_os not in ostype: continue
##        rulestr = li.split('::')[1].strip()
##        if 'DELETE' in rulestr:
##            name = rulestr.split(';;')[0].replace('"','').replace("'","").strip()
##            todel.append(name)
##        else:
##            rules.append(get_rule_from_str(rulestr))
##    return rules, todel


##fw = WinFw()

