# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import sys
from eole import option
# ne pas generer de *.exe.log
if option.get_log_level() > 10:
    sys.stderr = sys.stdout

# lorsque compile en .exe les accents posent probleme
if hasattr(sys, 'setdefaultencoding'):
    import locale
    loc = locale.getdefaultlocale()
    if loc[1]:
        encoding = loc[1]
        sys.setdefaultencoding(encoding)

import threading
import traceback
import os
import socket
import time
import logging
import inspect
##os.environ['path']='%s;%s'%(os.environ['path'], os.path.join(os.path.abspath('.'), 'dlls'))

import win32api as wa
import ntsecuritycon as ntsec
from win32com.shell import shell
import win32serviceutil, win32service

try:
    from twisted.internet import reactor #,threads
except:
    wa.WinExec('userinit.exe')
    sys.exit()

from logging.handlers import RotatingFileHandler

from eole.pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

from eole.process import killProcName, isrunning
from eole.messagebox import gmessage, ask
from eole.lance_cmd import lancecmd
from eole.lecteur import connect
from eole.perms import set_acl, AdjustPrivilege
from eole import win32_64
from eole import reg
from eole.os_type import type_os
from eole.log import LOGON_LOG, LOGON_FORMATTER
from eole.replace_win_vars import convert

import wx
app = wx.App()

class LogonLogging:
    def __init__(self):
        """active (si possible) le fichier de log si HKLM\Eole\Scribe : debug_logon est renseigne a "1"
        """
        scribe_dom = option.get_nom_domaine()
        scribe_name = option.get_nom_scribe()
        self.log = None
        if option.get_debug_logon() != '1': return
        try:
            # on log sur 2 fichiers de 100ko
            handler = RotatingFileHandler(LOGON_LOG,'a',100000,0)
            handler.setFormatter(LOGON_FORMATTER)
            self.log = logging.getLogger()
            self.log.addHandler(handler)
            self.log.setLevel(option.get_log_level())
            try:
                if not os.path.isfile(LOGON_LOG): file(LOGON_LOG, 'w').write('')
                if scribe_dom == wa.GetDomainName(): set_acl(LOGON_LOG, scribe_dom, scribe_name)
            except: pass
        except: pass

    def info(self, msg):
        """Enregistre l'evenement "msg" dans le fichier de log si debug_logon=on (regedit HKLM/Software/Eole/cliscribe)
        """
        if self.log:
            msg = '"%s" %s'%(inspect.stack()[1][3], msg)
            try: self.log.info(msg)
            except: pass

    def error(self, msg):
        if self.log:
            msg = '"%s" %s'%(inspect.stack()[1][3], msg)
            try: self.log.error(msg)
            except: pass

    def debug(self, msg):
        if self.log:
            msg = '"%s" %s'%(inspect.stack()[1][3], msg)
            try: self.log.debug(msg)
            except: pass

class Mbox(threading.Thread):
    def __init__ ( self, msg, style='error'):
        self.msg = msg
        self.style = style
        threading.Thread.__init__ ( self )

    def run(self):
        gmessage(self.msg, "Logon.exe", self.style)

class Logon:
    def __init__(self):
        self.username = wa.GetUserName().strip().lower()
        self.domname = wa.GetDomainName().strip().lower()
        self.scribe_dom = option.get_nom_domaine().lower()
        self.scribe_name = option.get_nom_scribe().lower()
        self.type_os = type_os
        fich_ext = '.txt'
        self.userfich = '%s%s%s'%(self.username, self.type_os, fich_ext) #userWinXP.txt
        self.fpath = r'\\%s\netlogon\%s'%(self.scribe_name, self.userfich)
        # privileges de modifier des ACLs, fichier de log si debug=on, dossier temporaire
        AdjustPrivilege([ntsec.SE_SECURITY_NAME, ntsec.SE_RESTORE_NAME])
        self.log = LogonLogging()

    def error(self, msg):
        """Affiche "msg" dans une MessageBox
        et dans le fichier de log
        """
        # if tracebk is not None:
            # if hasattr(tracebk, 'strerror'):
                # e = tracebk.strerror
            # else:
                # e = tracebk
            # e = '%s %s'%(e, [args])
            # self.log.error('%s : %s'%(msg, e))
        # else:
        self.log.error('%s'%(msg))
        m = """%s
Veuillez consulter les fichiers de log pour plus de details"""%(msg)
        self.mbox(m)

    def test_logon_type(self):
        """S'agit-il d'un login du domaine
        ou d'un login local
        """
        self.log.info('domaine : %s, dom_scribe : %s'%(self.domname, self.scribe_dom))
        if self.domname == self.scribe_dom:
            return True
        elif self.domname == wa.GetComputerName().lower():
            self.log.info('Connexion locale')
        else:
            self.log.error('Domaine inconnu : %s'%self.domname)
        return False

    def test_port_smb(self):
        # appel de la mthode remote_logon avec type_os en argument
        # attente que utilisateur.exe se lance
        cport_l = [139, 445]
        ip = option.get_ip_scribe()
        for cport in cport_l:
            for nb in range(1,4):
                try:
                    time.sleep(0.5)
                    test_ip(ip, cport)
                    return True
                except Exception, e:
                    self.log.debug('Test serv (IP=%s, PORT=%s): Passage %s => %s'%(ip, cport, nb, e))
                    nb += 1
                    pass

    def logon(self):
        """Cherche le fichier <user><Os>.txt le parcour et le traite
        Si OK, appel "remote_logon" sur controle-vnc-serveur
        """
        self.log.info("""
########## SESSION ##########""")
        self.log.info('Ouverture de session de %s sur %s'%(self.username, self.domname))
        if not self.test_logon_type():
            if type_os == 'Vista':
                try: reg.load_default_menus()
                except:
                    if not shell.IsUserAnAdmin():
                        if ask('Re-initialiser le Menu demarrer et le Bureau ?', 'Ouverture de session') == 2: # a repondu "oui"
                            try:
                                cmd, args = sys.argv[0], None
                                wa.ShellExecute(0, 'runas', cmd, args, '.', 1)
                                sys.exit()
                            except Exception, e:
                                self.error('Erreur lors de la re-initialisation des menus : %s'%e)
            else:
                try: reg.load_default_menus()
                except: pass
            return False
        # lancement du serveur PB permettant d'acceder a l'environnement utilisateur
        cmd = os.path.join(option.get_inst_path(), 'cliscribe', 'utilisateur.exe')
##        us = os.path.join(r'c:\cliscribe', 'utilisateur.py')
##        cmd = r'C:\python25\python.exe %s'%us
        if not os.path.isfile(cmd):
            self.error('Fichier "%s" non trouve'%cmd)
            return False
        lancecmd(cmd, nowait=True)
        try: return self.traitefich()
        except: return

    def traitefich(self):
        """Lit le fichier <user><Os>.txt
        et le traite ligne par ligne
        """
        if not self.test_port_smb(): return False
        self.log.info('Traitement de %s'%self.fpath)
        for i in range(10):
            try:
                f_cont = file(self.fpath, 'r').readlines()
                break
            except Exception, e:
                time.sleep(0.5)
                os.listdir(os.path.dirname(self.fpath))
                if i == 9:
                    msg = """Impossible de lire "%s" :
%s"""%(self.fpath, e)
                    self.error(msg)
                    return True
        for ligne in [ i.strip() for i in f_cont ]:
            if ligne.startswith('#'): continue
            if len(ligne) > 0:
                try: self.parse_line(ligne)
                except Exception, e:
                    msg = """Une erreur s'est produite lors du traitement du fichier %s
%s
%s"""%(self.fpath, e, ligne)
                    self.error(msg)
                    self.log.debug('Erreur %s'%traceback.format_exc())
# on ne supprime plus,
# peut poser probleme en cas d'utilisation du meme login au meme instant
# sur plusieurs stations
##        try: os.unlink(self.fpath)
##        except: pass
        return True

    def parse_line(self, line):
        """Traite une ligne du fichier
        cmd = commande a lancer, options possibles :
            - HIDDEN : cache la fenetre d'execution
            - NOWAIT : n'attend pas le retour
        lecteur = lettre et partage a monter dessus :
            si lecteur existe deja et est un lecteur reseau, il est prealablement demonte
            sinon passage au lecteur suivant
        """
        items = [ i.strip() for i in line.split(',')]
        # executer une commande
        if items[0] == 'cmd':
            hide = 'HIDDEN' in [i.upper() for i in items[2:]]
            nowait = 'NOWAIT' in [i.upper() for i in items[2:]]
            cmd = convert(items[1])
            self.log.info('cmd : %s HIDDEN=%s NOWAIT=%s'%(cmd, hide, nowait))
            with win32_64.disable_file_system_redirection():
                ret = lancecmd(cmd, hide, nowait)
            if ret == 0: return True
            self.log.error('La commande "%s" a echouee avec le code de sortie "%s"'%(cmd, ret))
            self.mbox('La commande "%s" a echouee avec le code de sortie "%s"'%(cmd, ret))
            return False
        # monter un partage
        if items[0] == 'lecteur':
            lettre, partage = items[1], items[2]
            self.log.info('lecteur : %s %s'%(lettre, partage))
            ret = connect(lettre, partage)
            if not ret[0]:
                msg = """Impossible de connecter le partage "%s" sur "%s"
%s"""%(partage, ret[1][0].upper(), ret[1][2])
                self.error(msg)
            elif ret[1] != lettre:
                self.log.error('Lecteur "%s" occupe, utilisation de "%s" pour "%s"'%(lettre, ret[1], partage))
                self.mbox('Le lecteur "%s" occupe, utilisation de "%s" pour "%s"'%(lettre, ret[1], partage))
            return ret[0]

    # Appel distant de remote_logon
    def test_port_user(self):
        # appel de la mthode remote_logon avec type_os en argument
        # attente que utilisateur.exe se lance
        cport = int(option.get_port_utilisateur())
        nb = 0
        ip = '127.0.0.1'
        while True:
            try:
                time.sleep(0.5)
                test_ip(ip, cport)
                break
            except Exception, e:
                if nb >= 30 : return False
                self.log.debug('self.logon : Passage %s => %s'%(nb, e))
                nb += 1
                pass
        return True

    def wait_servscribe_starts(self):
        self.log.info("Verification de l'etat du service")
        try:
            win32serviceutil.WaitForServiceStatus('servscribe', win32service.SERVICE_RUNNING, 25)
            return True
        except:
            return False

    def rlogon(self):
##        if not self.wait_servscribe_starts():
##            self.log.error("Le service a mis trop de temps a repondre")
##            self.mbox("Le service a mis trop de temps a repondre")
##            return False
        self.log.info('Appel de remote_logon(%s)'%self.type_os)
        d = getrootobject()
        d.addCallback(self.return_pbroot)
        d.addErrback(self.return_err)
        return d

    def return_pbroot(self, pbroot):
        """Fonction de retour du CallBack de GetRootObject
        """
        self.pbroot = pbroot
        d = self.pbroot.callRemote('logon', self.type_os)
        d.addCallback(self.return_logon)
        d.addErrback(self.return_err)
        return d

    def return_logon(self, ret=''):
        """Fonction de retour du CallBack de CallRemote("remote_logon")
        Si le serveur n'arrive pas a se reconnecter au service scribe windows
        cette fonction est appelee aussi (pas le Errback)
        """
        disconnect()
        if type(ret) == tuple:
            if ret[0] == 'Err': return self.return_err(ret[1])
        self.log.info('Retour remote_logon : %s'%[ret])

    def return_err(self, o='', *args):
        """Fonction d'erreur, peut servir a un ErrBack
        """
        disconnect()
        try:
            if hasattr(o, 'value'):
                message = '%s'%o.value
            else:
                message = '%s'%o
            trcbck = ' TRACEBACK : %s'%o.getBriefTraceback()
        except:
            message = o
            trcbck = traceback.format_exc()
        msg = """Une erreur s'est produite lors de l'appel distant (remote_logon) :

"%s"
"""%message
        self.error(msg)
        self.log.debug(trcbck)

    def mbox(self, msg):
        # affichage d'une popup WX
        # gmessage(msg, "Logon.exe", 'error')
        # afficher une fenetre WX dans un thread ne fonctionne pas
        Mbox(msg, 'error').start()

def test_ip(ip, port):
    s = socket.socket()
    s.settimeout(1)
    s.connect((ip, port))
    s.close()

def userinit():
    """Lance userinit.exe et quitte.
    Doit etre appele dans tous les cas
    """
    if isrunning('explorer.exe'): killProcName('explorer.exe')
    time.sleep(2)
    cmd = 'userinit.exe'
    while not isrunning('explorer.exe'):
        with win32_64.disable_file_system_redirection():
            logging.debug('Userinit %s'%lancecmd(cmd, nowait=True))
        time.sleep(30)

def logonCallback(*args):
    try: reactor.stop()
    except: pass

def main():
    try: killProcName('logon.exe', own=False)
    except: pass
    l = Logon()
    if l.logon() and l.test_port_user():
        d = l.rlogon()
        if not d: return
        d.addCallback(logonCallback, l)
        d.addErrback(logonCallback, l)
        reactor.run()
##    reactor.callWhenRunning(lance)
##    lance()
##    while True: # avec py2exe il faut attendre que tous les threads se terminent
##        if len(threading.enumerate()) == 1: return
##        time.sleep(0.3)

if __name__ == '__main__':
#    try: main()
#    except: pass
    main()
    time.sleep(2)
    userinit()
    while True: # avec py2exe il faut attendre que tous les threads se terminent
        if len(threading.enumerate()) == 1: break
        time.sleep(0.3)

